/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting;

import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.helper.LoadableRecipeSerializer;
import slimeknights.mantle.recipe.helper.TypeAwareRecipeSerializer;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.library.recipe.casting.DisplayCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingContainer;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;

public class PotionCastingRecipe
implements ICastingRecipe,
IMultiRecipe<DisplayCastingRecipe> {
    public static final RecordLoadable<PotionCastingRecipe> LOADER = RecordLoadable.create((RecordField)LoadableRecipeSerializer.TYPED_SERIALIZER.requiredField(), (RecordField)ContextKey.ID.requiredField(), (RecordField)LoadableRecipeSerializer.RECIPE_GROUP, (RecordField)IngredientLoadable.DISALLOW_EMPTY.requiredField("bottle", r -> r.bottle), (RecordField)FluidIngredient.LOADABLE.requiredField("fluid", r -> r.fluid), (RecordField)Loadables.ITEM.requiredField("result", r -> r.result), (RecordField)IntLoadable.FROM_ONE.defaultField("cooling_time", (Object)5, r -> r.coolingTime), PotionCastingRecipe::new);
    private final TypeAwareRecipeSerializer<?> serializer;
    private final ResourceLocation id;
    private final String group;
    private final Ingredient bottle;
    private final FluidIngredient fluid;
    private final Item result;
    private final int coolingTime;
    private List<DisplayCastingRecipe> displayRecipes = null;

    public RecipeType<?> m_6671_() {
        return this.serializer.getType();
    }

    public boolean matches(ICastingContainer inv, Level level) {
        return this.bottle.test(inv.getStack()) && this.fluid.test(inv.getFluid());
    }

    @Override
    public int getFluidAmount(ICastingContainer inv) {
        return this.fluid.getAmount(inv.getFluid());
    }

    @Override
    public boolean isConsumed() {
        return true;
    }

    @Override
    public boolean switchSlots() {
        return false;
    }

    @Override
    public int getCoolingTime(ICastingContainer inv) {
        return this.coolingTime;
    }

    public ItemStack assemble(ICastingContainer inv, RegistryAccess access) {
        ItemStack result = new ItemStack((ItemLike)this.result);
        result.m_41751_(inv.getFluidTag());
        return result;
    }

    public List<DisplayCastingRecipe> getRecipes(RegistryAccess access) {
        if (this.displayRecipes == null) {
            List<ItemStack> bottles = List.of(this.bottle.m_43908_());
            this.displayRecipes = ForgeRegistries.POTIONS.getValues().stream().map(potion -> {
                ItemStack result = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)this.result), (Potion)potion);
                return new DisplayCastingRecipe(this.m_6423_(), this.m_6671_(), bottles, this.fluid.getFluids().stream().map(fluid -> new FluidStack(fluid.getFluid(), fluid.getAmount(), result.m_41783_())).toList(), result, this.coolingTime, true);
            }).toList();
        }
        return this.displayRecipes;
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.bottle});
    }

    @Deprecated
    public ItemStack m_8043_(RegistryAccess access) {
        return new ItemStack((ItemLike)this.result);
    }

    public PotionCastingRecipe(TypeAwareRecipeSerializer<?> serializer, ResourceLocation id, String group, Ingredient bottle, FluidIngredient fluid, Item result, int coolingTime) {
        this.serializer = serializer;
        this.id = id;
        this.group = group;
        this.bottle = bottle;
        this.fluid = fluid;
        this.result = result;
        this.coolingTime = coolingTime;
    }

    public TypeAwareRecipeSerializer<?> getSerializer() {
        return this.serializer;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }
}

