/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.shape.Shape;

public abstract class AbstractRenderHandler {
    public abstract void register();

    public abstract void renderShapeBuffer(Shape var1);

    protected abstract void setupRenderingShape(Shape var1);

    protected abstract void endRenderingShape();

    protected abstract boolean textureEnabled();

    protected abstract boolean depthTestEnabled();

    protected abstract boolean depthMaskEnabled();

    protected abstract boolean blendEnabled();

    protected abstract void setTexture(boolean var1);

    protected abstract void setDepthTest(boolean var1);

    protected abstract void setDepthMask(boolean var1);

    protected abstract void setBlend(boolean var1);

    protected abstract void setupNotCulling();

    protected abstract void setupBlendFunc();

    protected abstract void pushProfiler(String var1);

    protected abstract void popProfiler();

    public void render() {
        this.pushProfiler("buildguide");
        if (((Boolean)BuildGuide.stateManager.getState().propertyEnable.value).booleanValue() && BuildGuide.stateManager.getState().isShapeAvailable() && BuildGuide.stateManager.getState().getCurrentShape().basepos != null) {
            if (((Boolean)BuildGuide.stateManager.getState().propertyAdvancedMode.value).booleanValue()) {
                for (Shape s : BuildGuide.stateManager.getState().advancedModeShapes) {
                    this.renderShape(s);
                }
            } else {
                this.renderShape(BuildGuide.stateManager.getState().getCurrentShape());
            }
        }
        this.popProfiler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderShape(Shape shape) {
        if (shape.lock.tryLock()) {
            try {
                if (shape.visible && shape.ready && !shape.error) {
                    boolean toggleBlend;
                    if (!shape.vertexBufferUnpacked) {
                        shape.buffer.end();
                        shape.vertexBufferUnpacked = true;
                    }
                    this.setupRenderingShape(shape);
                    boolean toggleTexture = this.textureEnabled();
                    boolean hasDepthTest = this.depthTestEnabled();
                    boolean toggleDepthTest = (Boolean)BuildGuide.stateManager.getState().propertyDepthTest.value ^ hasDepthTest;
                    boolean toggleDepthMask = this.depthMaskEnabled();
                    boolean bl = toggleBlend = !this.blendEnabled();
                    if (toggleTexture) {
                        this.setTexture(false);
                    }
                    if (toggleDepthTest && hasDepthTest) {
                        this.setDepthTest(false);
                    } else if (toggleDepthTest) {
                        this.setDepthTest(true);
                    }
                    if (toggleDepthMask) {
                        this.setDepthMask(false);
                    }
                    this.setupNotCulling();
                    this.setupBlendFunc();
                    if (toggleBlend) {
                        this.setBlend(true);
                    }
                    this.renderShapeBuffer(shape);
                    if (toggleBlend) {
                        this.setBlend(false);
                    }
                    if (toggleDepthTest && hasDepthTest) {
                        this.setDepthTest(true);
                    } else if (toggleDepthTest) {
                        this.setDepthTest(false);
                    }
                    if (toggleDepthMask) {
                        this.setDepthMask(true);
                    }
                    if (toggleTexture) {
                        this.setTexture(true);
                    }
                    this.endRenderingShape();
                }
            }
            finally {
                shape.lock.unlock();
            }
        }
    }
}

