/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.property;

import brentmaas.buildguide.common.screen.PropertyScreen;
import brentmaas.buildguide.common.screen.widget.IButton;
import brentmaas.buildguide.common.screen.widget.ICheckboxRunnableButton;
import brentmaas.buildguide.common.screen.widget.ITextField;
import java.util.ArrayList;

public abstract class Property<T> {
    protected static final int baseY = 125;
    protected static final int height = 20;
    protected int y = 125;
    public T value;
    protected String name;
    public ArrayList<IButton> buttonList = new ArrayList();
    public ArrayList<ITextField> textFieldList = new ArrayList();
    public ArrayList<ICheckboxRunnableButton> checkboxList = new ArrayList();
    protected boolean visible = true;

    public Property(T value, String name) {
        this.value = value;
        this.name = name;
    }

    public void onSelectedInGUI() {
        for (IButton b : this.buttonList) {
            b.setVisible(true);
        }
        for (ITextField tf : this.textFieldList) {
            tf.setVisibility(true);
        }
        for (ICheckboxRunnableButton cb : this.checkboxList) {
            cb.setVisible(true);
        }
        this.visible = true;
    }

    public void onDeselectedInGUI() {
        for (IButton b : this.buttonList) {
            b.setVisible(false);
        }
        for (ITextField tf : this.textFieldList) {
            tf.setVisibility(false);
        }
        for (ICheckboxRunnableButton cb : this.checkboxList) {
            cb.setVisible(false);
        }
        this.visible = false;
    }

    public void addToPropertyScreen(PropertyScreen screen) {
        for (IButton b : this.buttonList) {
            screen.addButton(b);
        }
        for (ITextField tf : this.textFieldList) {
            screen.addTextField(tf);
        }
        for (ICheckboxRunnableButton cb : this.checkboxList) {
            screen.addCheckbox(cb);
        }
    }

    public void setValue(T value) {
        this.value = value;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSlot(int slot) {
        this.y = 125 + slot * 20;
        for (IButton button : this.buttonList) {
            button.setYPosition(this.y);
        }
        for (ITextField textField : this.textFieldList) {
            textField.setYPosition(this.y);
        }
        for (ICheckboxRunnableButton checkbox : this.checkboxList) {
            checkbox.setYPosition(this.y);
        }
    }

    public void render(PropertyScreen screen) {
        this.drawString(screen, this.name, 5, this.y + 5, 0xFFFFFF);
    }

    public void drawString(PropertyScreen screen, String text, int x, int y, int colour) {
        if (this.visible) {
            screen.drawShadow(text, x, y, 0xFFFFFF);
        }
    }

    public void drawStringCentred(PropertyScreen screen, String text, int x, int y, int colour) {
        if (this.visible) {
            screen.drawShadowCentred(text, x, y, 0xFFFFFF);
        }
    }
}

