/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.property;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.property.Property;
import brentmaas.buildguide.common.screen.widget.ITextField;

public class PropertyMinimumFloat
extends Property<Float> {
    private ITextField valueTextField;
    private float minValue;
    private boolean inclusive;

    public PropertyMinimumFloat(float value, String name, Runnable onPress, float minValue, boolean inclusive) {
        super(Float.valueOf(value), name);
        this.minValue = minValue;
        this.inclusive = inclusive;
        this.buttonList.add(BuildGuide.widgetHandler.createButton(90, this.y, 20, 20, "-", () -> {
            if (((Float)this.value).floatValue() - 1.0f > this.minValue || this.inclusive && ((Float)this.value).floatValue() - 1.0f == this.minValue) {
                this.value = Float.valueOf(((Float)this.value).floatValue() - 1.0f);
                this.valueTextField.setTextValue("" + this.value);
                this.valueTextField.setTextColour(0xFFFFFF);
                if (onPress != null) {
                    onPress.run();
                }
            }
        }));
        this.buttonList.add(BuildGuide.widgetHandler.createButton(190, this.y, 20, 20, "+", () -> {
            this.value = Float.valueOf(((Float)this.value).floatValue() + 1.0f);
            this.valueTextField.setTextValue("" + this.value);
            this.valueTextField.setTextColour(0xFFFFFF);
            if (onPress != null) {
                onPress.run();
            }
        }));
        this.buttonList.add(BuildGuide.widgetHandler.createButton(160, this.y, 30, 20, BuildGuide.screenHandler.translate("screen.buildguide.set"), () -> {
            try {
                float newVal = Float.parseFloat(this.valueTextField.getTextValue());
                if (newVal > this.minValue || this.inclusive && newVal == this.minValue) {
                    this.value = Float.valueOf(newVal);
                    this.valueTextField.setTextColour(0xFFFFFF);
                    if (onPress != null) {
                        onPress.run();
                    }
                } else {
                    this.valueTextField.setTextColour(0xFF0000);
                }
            }
            catch (NumberFormatException e) {
                this.valueTextField.setTextColour(0xFF0000);
            }
        }));
        this.valueTextField = BuildGuide.widgetHandler.createTextField(110, this.y, 50, 20, "");
        this.valueTextField.setTextValue("" + value);
        this.valueTextField.setTextColour(0xFFFFFF);
        this.textFieldList.add(this.valueTextField);
    }

    @Override
    public void setValue(Float value) {
        if (value.floatValue() > this.minValue || this.inclusive && value.floatValue() == this.minValue) {
            super.setValue(value);
            this.valueTextField.setTextValue("" + value);
            this.valueTextField.setTextColour(0xFFFFFF);
        }
    }
}

