/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.screen;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.screen.IScreenWrapper;
import brentmaas.buildguide.common.screen.widget.IButton;
import brentmaas.buildguide.common.screen.widget.ICheckboxRunnableButton;
import brentmaas.buildguide.common.screen.widget.IShapeList;
import brentmaas.buildguide.common.screen.widget.ISlider;
import brentmaas.buildguide.common.screen.widget.ITextField;

public abstract class BaseScreen {
    public String title;
    protected IScreenWrapper wrapper;

    public BaseScreen(String title) {
        this.title = BuildGuide.screenHandler.translate(title);
    }

    public void setWrapper(IScreenWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public void addButton(IButton button) {
        if (this.wrapper != null) {
            this.wrapper.addButton(button);
        }
    }

    public void addTextField(ITextField textField) {
        if (this.wrapper != null) {
            this.wrapper.addTextField(textField);
        }
    }

    public void addCheckbox(ICheckboxRunnableButton checkbox) {
        if (this.wrapper != null) {
            this.wrapper.addCheckbox(checkbox);
        }
    }

    public void addSlider(ISlider slider) {
        if (this.wrapper != null) {
            this.wrapper.addSlider(slider);
        }
    }

    public void addShapeList(IShapeList shapeList) {
        if (this.wrapper != null) {
            this.wrapper.addShapeList(shapeList);
        }
    }

    public void drawShadow(String text, int x, int y, int colour) {
        if (this.wrapper != null) {
            this.wrapper.drawShadow(text, x, y, colour);
        }
    }

    public void drawShadowCentred(String text, int x, int y, int colour) {
        if (this.wrapper != null) {
            this.wrapper.drawShadow(text, x - this.wrapper.getTextWidth(text) / 2, y, colour);
        }
    }

    public abstract void init();

    public abstract void render();

    public abstract boolean isPauseScreen();
}

