/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.screen;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.screen.BaseScreen;
import brentmaas.buildguide.common.screen.BuildGuideScreen;
import brentmaas.buildguide.common.screen.widget.IButton;
import brentmaas.buildguide.common.screen.widget.ICheckboxRunnableButton;
import brentmaas.buildguide.common.screen.widget.IShapeList;
import brentmaas.buildguide.common.screen.widget.ITextField;
import brentmaas.buildguide.common.shape.Shape;
import brentmaas.buildguide.common.shape.ShapeRegistry;
import java.util.Random;

public class ShapelistScreen
extends BaseScreen {
    private String titleNewShape = BuildGuide.screenHandler.translate("screen.buildguide.newshape");
    private String titleShapes = BuildGuide.screenHandler.translate("screen.buildguide.shapes");
    private String titleGlobalBasepos = BuildGuide.screenHandler.translate("screen.buildguide.globalbasepos");
    private String titleVisible = BuildGuide.screenHandler.translate("screen.buildguide.visible");
    private String titleNumberOfBlocks = BuildGuide.screenHandler.translate("screen.buildguide.numberofblocks");
    private IShapeList shapeList;
    private IButton buttonClose;
    private IButton buttonBack = BuildGuide.widgetHandler.createButton(0, 0, 20, 20, "<-", () -> BuildGuide.screenHandler.showScreen(new BuildGuideScreen()));
    private IButton buttonNewShapePrevious = BuildGuide.widgetHandler.createButton(0, 25, 20, 20, "<-", () -> this.updateNewShape(-1));
    private IButton buttonNewShapeNext = BuildGuide.widgetHandler.createButton(120, 25, 20, 20, "->", () -> this.updateNewShape(1));
    private IButton buttonAdd = BuildGuide.widgetHandler.createButton(0, 45, 140, 20, BuildGuide.screenHandler.translate("screen.buildguide.add"), () -> {
        Shape newShape = ShapeRegistry.getNewInstance(ShapeRegistry.getClassIdentifiers().get(BuildGuide.stateManager.getState().iAdvancedNew));
        newShape.resetBasepos();
        if (((Boolean)BuildGuide.stateManager.getState().propertyAdvancedModeRandomColours.value).booleanValue()) {
            Random random = new Random();
            newShape.colourShapeR = random.nextFloat();
            newShape.colourShapeG = random.nextFloat();
            newShape.colourShapeB = random.nextFloat();
            newShape.colourBaseposR = random.nextFloat();
            newShape.colourBaseposG = random.nextFloat();
            newShape.colourBaseposB = random.nextFloat();
        }
        newShape.update();
        BuildGuide.stateManager.getState().advancedModeShapes.add(newShape);
        this.shapeList.addEntry(BuildGuide.stateManager.getState().advancedModeShapes.size() - 1);
        this.checkActive();
    });
    private ICheckboxRunnableButton buttonVisible = BuildGuide.widgetHandler.createCheckbox(120, 65, 20, 20, "", true, false, () -> this.setShapeVisibility());
    private IButton buttonDelete = BuildGuide.widgetHandler.createButton(0, 85, 140, 20, BuildGuide.screenHandler.translate("screen.buildguide.delete"), () -> {
        if (this.shapeList.getSelected() != null) {
            BuildGuide.stateManager.getState().advancedModeShapes.remove(this.shapeList.getSelected().getShapeId());
            this.shapeList.removeEntry(this.shapeList.getSelected());
        }
        this.checkActive();
    });
    private IButton buttonGlobalBasepos = BuildGuide.widgetHandler.createButton(0, 125, 140, 20, BuildGuide.screenHandler.translate("screen.buildguide.setglobalbasepos"), () -> {
        if (BuildGuide.stateManager.getState().isShapeAvailable()) {
            this.setGlobalBasepos();
        }
    });
    private IButton buttonBaseposXDecrease = BuildGuide.widgetHandler.createButton(20, 145, 20, 20, "-", () -> this.shiftGlobalBasepos(-1, 0, 0));
    private IButton buttonBaseposXIncrease = BuildGuide.widgetHandler.createButton(120, 145, 20, 20, "+", () -> this.shiftGlobalBasepos(1, 0, 0));
    private IButton buttonBaseposYDecrease = BuildGuide.widgetHandler.createButton(20, 165, 20, 20, "-", () -> this.shiftGlobalBasepos(0, -1, 0));
    private IButton buttonBaseposYIncrease = BuildGuide.widgetHandler.createButton(120, 165, 20, 20, "+", () -> this.shiftGlobalBasepos(0, 1, 0));
    private IButton buttonBaseposZDecrease = BuildGuide.widgetHandler.createButton(20, 185, 20, 20, "-", () -> this.shiftGlobalBasepos(0, 0, -1));
    private IButton buttonBaseposZIncrease = BuildGuide.widgetHandler.createButton(120, 185, 20, 20, "+", () -> this.shiftGlobalBasepos(0, 0, 1));
    private ITextField textFieldX = BuildGuide.widgetHandler.createTextField(40, 145, 50, 20, "");
    private ITextField textFieldY = BuildGuide.widgetHandler.createTextField(40, 165, 50, 20, "");
    private ITextField textFieldZ = BuildGuide.widgetHandler.createTextField(40, 185, 50, 20, "");
    private IButton buttonSetX = BuildGuide.widgetHandler.createButton(90, 145, 30, 20, BuildGuide.screenHandler.translate("screen.buildguide.set"), () -> {
        try {
            int newval = Integer.parseInt(this.textFieldX.getTextValue());
            int delta = newval - BuildGuide.stateManager.getState().getCurrentShape().basepos.x;
            for (Shape s : BuildGuide.stateManager.getState().advancedModeShapes) {
                s.shiftBasepos(delta, 0, 0);
            }
            this.textFieldX.setTextColour(0xFFFFFF);
        }
        catch (NumberFormatException e) {
            this.textFieldX.setTextColour(0xFF0000);
        }
    });
    private IButton buttonSetY = BuildGuide.widgetHandler.createButton(90, 165, 30, 20, BuildGuide.screenHandler.translate("screen.buildguide.set"), () -> {
        try {
            int newval = Integer.parseInt(this.textFieldY.getTextValue());
            int delta = newval - BuildGuide.stateManager.getState().getCurrentShape().basepos.y;
            for (Shape s : BuildGuide.stateManager.getState().advancedModeShapes) {
                s.shiftBasepos(0, delta, 0);
            }
            this.textFieldY.setTextColour(0xFFFFFF);
        }
        catch (NumberFormatException e) {
            this.textFieldY.setTextColour(0xFF0000);
        }
    });
    private IButton buttonSetZ = BuildGuide.widgetHandler.createButton(90, 185, 30, 20, BuildGuide.screenHandler.translate("screen.buildguide.set"), () -> {
        try {
            int newval = Integer.parseInt(this.textFieldZ.getTextValue());
            int delta = newval - BuildGuide.stateManager.getState().getCurrentShape().basepos.z;
            for (Shape s : BuildGuide.stateManager.getState().advancedModeShapes) {
                s.shiftBasepos(0, 0, delta);
            }
            this.textFieldZ.setTextColour(0xFFFFFF);
        }
        catch (NumberFormatException e) {
            this.textFieldZ.setTextColour(0xFF0000);
        }
    });

    public ShapelistScreen() {
        super(BuildGuide.screenHandler.translate("screen.buildguide.shapelist"));
    }

    @Override
    public void init() {
        this.buttonClose = BuildGuide.widgetHandler.createButton(this.wrapper.getWidth() - 20, 0, 20, 20, "X", () -> BuildGuide.screenHandler.showScreen(null));
        this.checkActive();
        this.addButton(this.buttonClose);
        this.addButton(this.buttonBack);
        this.addButton(this.buttonNewShapePrevious);
        this.addButton(this.buttonNewShapeNext);
        this.addButton(this.buttonAdd);
        this.addCheckbox(this.buttonVisible);
        this.addButton(this.buttonDelete);
        this.addButton(this.buttonGlobalBasepos);
        this.addButton(this.buttonBaseposXDecrease);
        this.addButton(this.buttonBaseposXIncrease);
        this.addButton(this.buttonBaseposYDecrease);
        this.addButton(this.buttonBaseposYIncrease);
        this.addButton(this.buttonBaseposZDecrease);
        this.addButton(this.buttonBaseposZIncrease);
        this.addButton(this.buttonSetX);
        this.addButton(this.buttonSetY);
        this.addButton(this.buttonSetZ);
        this.textFieldX.setTextValue((String)(BuildGuide.stateManager.getState().isShapeAvailable() ? "" + BuildGuide.stateManager.getState().getCurrentShape().basepos.x : "-"));
        this.textFieldX.setTextColour(0xFFFFFF);
        this.textFieldY.setTextValue((String)(BuildGuide.stateManager.getState().isShapeAvailable() ? "" + BuildGuide.stateManager.getState().getCurrentShape().basepos.y : "-"));
        this.textFieldY.setTextColour(0xFFFFFF);
        this.textFieldZ.setTextValue((String)(BuildGuide.stateManager.getState().isShapeAvailable() ? "" + BuildGuide.stateManager.getState().getCurrentShape().basepos.z : "-"));
        this.textFieldZ.setTextColour(0xFFFFFF);
        this.addTextField(this.textFieldX);
        this.addTextField(this.textFieldY);
        this.addTextField(this.textFieldZ);
        this.shapeList = BuildGuide.widgetHandler.createShapelist(150, 300, 25, this.wrapper.getHeight(), 20, () -> {
            if (BuildGuide.stateManager.getState().isShapeAvailable()) {
                this.textFieldX.setTextValue("" + BuildGuide.stateManager.getState().getCurrentShape().basepos.x);
                this.textFieldY.setTextValue("" + BuildGuide.stateManager.getState().getCurrentShape().basepos.y);
                this.textFieldZ.setTextValue("" + BuildGuide.stateManager.getState().getCurrentShape().basepos.z);
            } else {
                this.textFieldX.setTextValue("-");
                this.textFieldY.setTextValue("-");
                this.textFieldZ.setTextValue("-");
            }
            this.textFieldX.setTextColour(0xFFFFFF);
            this.textFieldY.setTextColour(0xFFFFFF);
            this.textFieldZ.setTextColour(0xFFFFFF);
            if (BuildGuide.stateManager.getState().isShapeAvailable()) {
                this.buttonVisible.setChecked(BuildGuide.stateManager.getState().getCurrentShape().visible);
            }
        });
        this.addShapeList(this.shapeList);
    }

    @Override
    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public void render() {
        this.drawShadowCentred(this.title, this.wrapper.getWidth() / 2, 5, 0xFFFFFF);
        this.drawShadowCentred(this.titleNewShape, 70, 15, 0xFFFFFF);
        this.drawShadowCentred(this.titleShapes, 220, 15, 0xFFFFFF);
        this.drawShadowCentred(this.titleGlobalBasepos, 70, 115, 0xFFFFFF);
        this.drawShadowCentred(this.titleNumberOfBlocks, 355, 15, 0xFFFFFF);
        this.drawShadowCentred(BuildGuide.screenHandler.translate(ShapeRegistry.getTranslationKeys().get(BuildGuide.stateManager.getState().iAdvancedNew)), 70, 30, 0xFFFFFF);
        this.drawShadow(this.titleVisible, 5, 70, BuildGuide.stateManager.getState().isShapeAvailable() ? 0xFFFFFF : 0x444444);
        this.drawShadow("X", 5, 150, 0xFFFFFF);
        this.drawShadow("Y", 5, 170, 0xFFFFFF);
        this.drawShadow("Z", 5, 190, 0xFFFFFF);
        int n = 0;
        for (Shape s : BuildGuide.stateManager.getState().advancedModeShapes) {
            if (!s.visible) continue;
            n += s.getNumberOfBlocks();
        }
        this.drawShadowCentred("" + n, 355, 30, 0xFFFFFF);
        this.drawShadowCentred("(" + n / 64 + " x 64 + " + n % 64 + ")", 355, 45, 0xFFFFFF);
    }

    private void updateNewShape(int di) {
        BuildGuide.stateManager.getState().iAdvancedNew = Math.floorMod(BuildGuide.stateManager.getState().iAdvancedNew + di, ShapeRegistry.getNumberOfShapes());
    }

    private void shiftGlobalBasepos(int dx, int dy, int dz) {
        for (Shape s : BuildGuide.stateManager.getState().advancedModeShapes) {
            s.shiftBasepos(dx, dy, dz);
        }
        if (BuildGuide.stateManager.getState().isShapeAvailable()) {
            if (dx != 0) {
                this.textFieldX.setTextValue("" + BuildGuide.stateManager.getState().getCurrentShape().basepos.x);
                this.textFieldX.setTextColour(0xFFFFFF);
            }
            if (dy != 0) {
                this.textFieldY.setTextValue("" + BuildGuide.stateManager.getState().getCurrentShape().basepos.y);
                this.textFieldY.setTextColour(0xFFFFFF);
            }
            if (dz != 0) {
                this.textFieldZ.setTextValue("" + BuildGuide.stateManager.getState().getCurrentShape().basepos.z);
                this.textFieldZ.setTextColour(0xFFFFFF);
            }
        } else {
            if (dx != 0) {
                this.textFieldX.setTextValue("-");
                this.textFieldX.setTextColour(0xFFFFFF);
            }
            if (dy != 0) {
                this.textFieldY.setTextValue("-");
                this.textFieldY.setTextColour(0xFFFFFF);
            }
            if (dz != 0) {
                this.textFieldZ.setTextValue("-");
                this.textFieldZ.setTextColour(0xFFFFFF);
            }
        }
    }

    private void setGlobalBasepos() {
        Shape.Basepos pos = BuildGuide.shapeHandler.getPlayerPosition();
        int deltaX = pos.x - BuildGuide.stateManager.getState().getCurrentShape().basepos.x;
        int deltaY = pos.y - BuildGuide.stateManager.getState().getCurrentShape().basepos.y;
        int deltaZ = pos.z - BuildGuide.stateManager.getState().getCurrentShape().basepos.z;
        this.shiftGlobalBasepos(deltaX, deltaY, deltaZ);
    }

    private void setShapeVisibility() {
        if (BuildGuide.stateManager.getState().isShapeAvailable()) {
            BuildGuide.stateManager.getState().getCurrentShape().visible = this.buttonVisible.isCheckboxSelected();
        }
    }

    private void checkActive() {
        if (!BuildGuide.stateManager.getState().isShapeAvailable()) {
            this.buttonVisible.setActive(false);
            this.buttonDelete.setActive(false);
            this.buttonGlobalBasepos.setActive(false);
            this.buttonBaseposXDecrease.setActive(false);
            this.buttonBaseposXIncrease.setActive(false);
            this.buttonBaseposYDecrease.setActive(false);
            this.buttonBaseposYIncrease.setActive(false);
            this.buttonBaseposZDecrease.setActive(false);
            this.buttonBaseposZIncrease.setActive(false);
            this.buttonSetX.setActive(false);
            this.buttonSetY.setActive(false);
            this.buttonSetZ.setActive(false);
        } else {
            this.buttonVisible.setActive(true);
            this.buttonDelete.setActive(true);
            this.buttonGlobalBasepos.setActive(true);
            this.buttonBaseposXDecrease.setActive(true);
            this.buttonBaseposXIncrease.setActive(true);
            this.buttonBaseposYDecrease.setActive(true);
            this.buttonBaseposYIncrease.setActive(true);
            this.buttonBaseposZDecrease.setActive(true);
            this.buttonBaseposZIncrease.setActive(true);
            this.buttonSetX.setActive(true);
            this.buttonSetY.setActive(true);
            this.buttonSetZ.setActive(true);
        }
    }
}

