/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.shape;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.property.PropertyBoolean;
import brentmaas.buildguide.common.property.PropertyEnum;
import brentmaas.buildguide.common.property.PropertyNonzeroInt;
import brentmaas.buildguide.common.property.PropertyPositiveFloat;
import brentmaas.buildguide.common.shape.IShapeBuffer;
import brentmaas.buildguide.common.shape.Shape;

public class ShapeCircle
extends Shape {
    private String[] directionNames = new String[]{"X", "Y", "Z"};
    private PropertyEnum<direction> propertyDir = new PropertyEnum<direction>(direction.X, BuildGuide.screenHandler.translate("property.buildguide.direction"), () -> this.update(), this.directionNames);
    private PropertyPositiveFloat propertyRadius = new PropertyPositiveFloat(3.0f, BuildGuide.screenHandler.translate("property.buildguide.radius"), () -> this.update());
    private PropertyNonzeroInt propertyDepth = new PropertyNonzeroInt(1, BuildGuide.screenHandler.translate("property.buildguide.depth"), () -> this.update());
    private PropertyBoolean propertyEvenMode = new PropertyBoolean(false, BuildGuide.screenHandler.translate("property.buildguide.evenmode"), () -> this.update());

    public ShapeCircle() {
        this.properties.add(this.propertyDir);
        this.properties.add(this.propertyRadius);
        this.properties.add(this.propertyDepth);
        this.properties.add(this.propertyEvenMode);
    }

    @Override
    protected void updateShape(IShapeBuffer buffer) throws InterruptedException {
        float dx = ((Float)this.propertyRadius.value).floatValue();
        float dy = ((Float)this.propertyRadius.value).floatValue();
        float dz = ((Float)this.propertyRadius.value).floatValue();
        double offset = (Boolean)this.propertyEvenMode.value != false ? 0.5 : 0.0;
        switch ((direction)((Object)this.propertyDir.value)) {
            case X: {
                dx = 0.0f;
                break;
            }
            case Y: {
                dy = 0.0f;
                break;
            }
            case Z: {
                dz = 0.0f;
            }
        }
        this.setBaseposOffset(dx == 0.0f ? 0.0 : offset, dy == 0.0f ? 0.0 : offset, dz == 0.0f ? 0.0 : offset);
        for (int x = (int)Math.floor((double)(-dx) + this.baseposOffsetX); x <= (int)Math.ceil((double)dx + this.baseposOffsetX); ++x) {
            for (int y = (int)Math.floor((double)(-dy) + this.baseposOffsetY); y <= (int)Math.ceil((double)dy + this.baseposOffsetY); ++y) {
                for (int z = (int)Math.floor((double)(-dz) + this.baseposOffsetZ); z <= (int)Math.ceil((double)dz + this.baseposOffsetZ); ++z) {
                    double r2 = ((double)x - this.baseposOffsetX) * ((double)x - this.baseposOffsetX) + ((double)y - this.baseposOffsetY) * ((double)y - this.baseposOffsetY) + ((double)z - this.baseposOffsetZ) * ((double)z - this.baseposOffsetZ);
                    if (!(r2 >= ((double)((Float)this.propertyRadius.value).floatValue() - 0.5) * ((double)((Float)this.propertyRadius.value).floatValue() - 0.5)) || !(r2 <= ((double)((Float)this.propertyRadius.value).floatValue() + 0.5) * ((double)((Float)this.propertyRadius.value).floatValue() + 0.5))) continue;
                    for (int s = (Integer)this.propertyDepth.value > 0 ? 0 : (Integer)this.propertyDepth.value + 1; s < ((Integer)this.propertyDepth.value > 0 ? (Integer)this.propertyDepth.value : 1); ++s) {
                        this.addShapeCube(buffer, x + (this.propertyDir.value == direction.X ? s : 0), y + (this.propertyDir.value == direction.Y ? s : 0), z + (this.propertyDir.value == direction.Z ? s : 0));
                    }
                }
            }
        }
    }

    @Override
    public String getTranslationKey() {
        return "shape.buildguide.circle";
    }

    private static enum direction {
        X,
        Y,
        Z;

    }
}

