/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.shape;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.property.PropertyEnum;
import brentmaas.buildguide.common.property.PropertyNonzeroInt;
import brentmaas.buildguide.common.shape.IShapeBuffer;
import brentmaas.buildguide.common.shape.Shape;

public class ShapeCuboid
extends Shape {
    private String[] wallsNames = new String[]{"XYZ", "X", "Y", "Z", "XY", "XZ", "YZ", "-"};
    private PropertyNonzeroInt propertyX = new PropertyNonzeroInt(3, "X", () -> this.update());
    private PropertyNonzeroInt propertyY = new PropertyNonzeroInt(3, "Y", () -> this.update());
    private PropertyNonzeroInt propertyZ = new PropertyNonzeroInt(3, "Z", () -> this.update());
    private PropertyEnum<walls> propertyWalls = new PropertyEnum<walls>(walls.ALL, BuildGuide.screenHandler.translate("property.buildguide.walls"), () -> this.update(), this.wallsNames);

    public ShapeCuboid() {
        this.properties.add(this.propertyX);
        this.properties.add(this.propertyY);
        this.properties.add(this.propertyZ);
        this.properties.add(this.propertyWalls);
    }

    @Override
    protected void updateShape(IShapeBuffer buffer) throws InterruptedException {
        int z;
        int y;
        int x;
        int dx = (Integer)this.propertyX.value;
        int dy = (Integer)this.propertyY.value;
        int dz = (Integer)this.propertyZ.value;
        walls w = (walls)((Object)this.propertyWalls.value);
        for (x = dx > 0 ? 0 : dx + 1; x < (dx > 0 ? dx : 1); ++x) {
            this.addShapeCube(buffer, x, 0, 0);
            if (dy != 1 && dy != -1) {
                this.addShapeCube(buffer, x, dy > 0 ? dy - 1 : dy + 1, 0);
            }
            if (dz != 1 && dz != -1) {
                this.addShapeCube(buffer, x, 0, dz > 0 ? dz - 1 : dz + 1);
            }
            if (dy == 1 || dy == -1 || dz == 1 || dz == -1) continue;
            this.addShapeCube(buffer, x, dy > 0 ? dy - 1 : dy + 1, dz > 0 ? dz - 1 : dz + 1);
        }
        for (y = dy > 0 ? 1 : dy + 2; y < (dy > 0 ? dy - 1 : 0); ++y) {
            this.addShapeCube(buffer, 0, y, 0);
            if (dx != 1 && dx != -1) {
                this.addShapeCube(buffer, dx > 0 ? dx - 1 : dx + 1, y, 0);
            }
            if (dz != 1 && dz != -1) {
                this.addShapeCube(buffer, 0, y, dz > 0 ? dz - 1 : dz + 1);
            }
            if (dx == 1 || dx == -1 || dz == 1 || dz == -1) continue;
            this.addShapeCube(buffer, dx > 0 ? dx - 1 : dx + 1, y, dz > 0 ? dz - 1 : dz + 1);
        }
        for (int z2 = dz > 0 ? 1 : dz + 2; z2 < (dz > 0 ? dz - 1 : 0); ++z2) {
            this.addShapeCube(buffer, 0, 0, z2);
            if (dx != 1 && dx != -1) {
                this.addShapeCube(buffer, dx > 0 ? dx - 1 : dx + 1, 0, z2);
            }
            if (dy != 1 && dy != -1) {
                this.addShapeCube(buffer, 0, dy > 0 ? dy - 1 : dy + 1, z2);
            }
            if (dx == 1 || dx == -1 || dy == 1 || dy == -1) continue;
            this.addShapeCube(buffer, dx > 0 ? dx - 1 : dx + 1, dy > 0 ? dy - 1 : dy + 1, z2);
        }
        if (w == walls.ALL || w == walls.X || w == walls.XY || w == walls.XZ) {
            for (y = dy > 0 ? 1 : dy + 2; y < (dy > 0 ? dy - 1 : 0); ++y) {
                for (z = dz > 0 ? 1 : dz + 2; z < (dz > 0 ? dz - 1 : 0); ++z) {
                    this.addShapeCube(buffer, 0, y, z);
                    if (dx == 1 || dx == -1) continue;
                    this.addShapeCube(buffer, dx > 0 ? dx - 1 : dx + 1, y, z);
                }
            }
        }
        if (w == walls.ALL || w == walls.Y || w == walls.XY || w == walls.YZ) {
            for (x = dx > 0 ? 1 : dx + 2; x < (dx > 0 ? dx - 1 : 0); ++x) {
                for (z = dz > 0 ? 1 : dz + 2; z < (dz > 0 ? dz - 1 : 0); ++z) {
                    this.addShapeCube(buffer, x, 0, z);
                    if (dy == 1 || dy == -1) continue;
                    this.addShapeCube(buffer, x, dy > 0 ? dy - 1 : dy + 1, z);
                }
            }
        }
        if (w == walls.ALL || w == walls.Z || w == walls.XZ || w == walls.YZ) {
            for (x = dx > 0 ? 1 : dx + 2; x < (dx > 0 ? dx - 1 : 0); ++x) {
                for (int y2 = dy > 0 ? 1 : dy + 2; y2 < (dy > 0 ? dy - 1 : 0); ++y2) {
                    this.addShapeCube(buffer, x, y2, 0);
                    if (dz == 1 || dz == -1) continue;
                    this.addShapeCube(buffer, x, y2, dz > 0 ? dz - 1 : dz + 1);
                }
            }
        }
    }

    @Override
    public String getTranslationKey() {
        return "shape.buildguide.cuboid";
    }

    private static enum walls {
        ALL,
        X,
        Y,
        Z,
        XY,
        XZ,
        YZ,
        NONE;

    }
}

