/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.shape;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.property.PropertyBoolean;
import brentmaas.buildguide.common.property.PropertyEnum;
import brentmaas.buildguide.common.property.PropertyNonzeroInt;
import brentmaas.buildguide.common.property.PropertyPositiveFloat;
import brentmaas.buildguide.common.shape.IShapeBuffer;
import brentmaas.buildguide.common.shape.Shape;

public class ShapeEllipse
extends Shape {
    private String[] directionNames = new String[]{"X", "Y", "Z"};
    private PropertyEnum<direction> propertyDir = new PropertyEnum<direction>(direction.X, BuildGuide.screenHandler.translate("property.buildguide.direction"), () -> this.update(), this.directionNames);
    private PropertyPositiveFloat propertySemi1 = new PropertyPositiveFloat(3.0f, BuildGuide.screenHandler.translate("property.buildguide.semiaxis", "Y"), () -> this.update());
    private PropertyPositiveFloat propertySemi2 = new PropertyPositiveFloat(3.0f, BuildGuide.screenHandler.translate("property.buildguide.semiaxis", "Z"), () -> this.update());
    private PropertyNonzeroInt propertyDepth = new PropertyNonzeroInt(1, BuildGuide.screenHandler.translate("property.buildguide.depth"), () -> this.update());
    private PropertyBoolean propertyEvenMode = new PropertyBoolean(false, BuildGuide.screenHandler.translate("property.buildguide.evenmode"), () -> this.update());

    public ShapeEllipse() {
        this.properties.add(this.propertyDir);
        this.properties.add(this.propertySemi1);
        this.properties.add(this.propertySemi2);
        this.properties.add(this.propertyDepth);
        this.properties.add(this.propertyEvenMode);
    }

    @Override
    protected void updateShape(IShapeBuffer buffer) throws InterruptedException {
        float da = ((Float)this.propertySemi1.value).floatValue();
        float db = ((Float)this.propertySemi2.value).floatValue();
        double offset = (Boolean)this.propertyEvenMode.value != false ? 0.5 : 0.0;
        switch ((direction)((Object)this.propertyDir.value)) {
            case X: {
                this.setBaseposOffset(0.0, offset, offset);
                break;
            }
            case Y: {
                this.setBaseposOffset(offset, 0.0, offset);
                break;
            }
            case Z: {
                this.setBaseposOffset(offset, offset, 0.0);
            }
        }
        for (int a = (int)Math.floor((double)(-da) + offset); a <= (int)Math.ceil((double)da + offset); ++a) {
            for (int b = (int)Math.floor((double)(-db) + offset); b <= (int)Math.ceil((double)db + offset); ++b) {
                double r2_outer2;
                double r2_inner2;
                double drb2;
                double dra2;
                double corr2;
                double theta2;
                double theta = Math.atan2((double)da / (double)db * ((double)b - offset), (double)a - offset);
                double corr = Math.sqrt(1.0 + ((double)da * (double)da / (double)db / (double)db - 1.0) * Math.sin(theta) * Math.sin(theta));
                double dra = 0.5 * Math.cos(theta) / corr;
                double drb = 0.5 * Math.sin(theta) * (double)da / (double)db / corr;
                double r2_inner = ((double)a - offset - dra) * ((double)a - offset - dra) / (double)da / (double)da + ((double)b - offset - drb) * ((double)b - offset - drb) / (double)db / (double)db;
                double r2_outer = ((double)a - offset + dra) * ((double)a - offset + dra) / (double)da / (double)da + ((double)b - offset + drb) * ((double)b - offset + drb) / (double)db / (double)db;
                if (!(r2_outer >= 1.0 && r2_inner <= 1.0 || (double)a - offset == 0.0) && (double)b - offset != 0.0) continue;
                if ((double)a - offset == 0.0 && Math.abs((double)b - offset) != (double)db) {
                    theta2 = Math.atan2((double)da / (double)db * (double)b - offset, 1.0);
                    corr2 = Math.sqrt(1.0 + ((double)da * (double)da / (double)db / (double)db - 1.0) * Math.sin(theta2) * Math.sin(theta2));
                    dra2 = 0.5 * Math.cos(theta2) / corr2;
                    drb2 = 0.5 * Math.sin(theta2) * (double)da / (double)db / corr2;
                    r2_inner2 = (1.0 - dra2) * (1.0 - dra2) / (double)da / (double)da + ((double)b - offset - drb2) * ((double)b - offset - drb2) / (double)db / (double)db;
                    r2_outer2 = (1.0 + dra2) * (1.0 + dra2) / (double)da / (double)da + ((double)b - offset + drb2) * ((double)b - offset + drb2) / (double)db / (double)db;
                    if (r2_outer2 >= 1.0 && r2_inner2 <= 1.0 || 1.0 / (double)da / (double)da + ((double)b - offset) * ((double)b - offset) / (double)db / (double)db < 1.0) continue;
                }
                if ((double)b - offset == 0.0 && Math.abs((double)a - offset) != (double)da) {
                    theta2 = Math.atan2((double)da / (double)db, (double)a - offset);
                    corr2 = Math.sqrt(1.0 + ((double)da * (double)da / (double)db / (double)db - 1.0) * Math.sin(theta2) * Math.sin(theta2));
                    dra2 = 0.5 * Math.cos(theta2) / corr2;
                    drb2 = 0.5 * Math.sin(theta2) * (double)da / (double)db / corr2;
                    r2_inner2 = ((double)a - offset - dra2) * ((double)a - offset - dra2) / (double)da / (double)da + (1.0 - drb2) * (1.0 - drb2) / (double)db / (double)db;
                    r2_outer2 = ((double)a - offset + dra2) * ((double)a - offset + dra2) / (double)da / (double)da + (1.0 + drb2) * (1.0 + drb2) / (double)db / (double)db;
                    if (r2_outer2 >= 1.0 && r2_inner2 <= 1.0 || ((double)a - offset) * ((double)a - offset) / (double)da / (double)da + 1.0 / (double)db / (double)db < 1.0) continue;
                }
                block17: for (int s = (Integer)this.propertyDepth.value > 0 ? 0 : (Integer)this.propertyDepth.value + 1; s < ((Integer)this.propertyDepth.value > 0 ? (Integer)this.propertyDepth.value : 1); ++s) {
                    switch ((direction)((Object)this.propertyDir.value)) {
                        case X: {
                            this.addShapeCube(buffer, s, a, b);
                            continue block17;
                        }
                        case Y: {
                            this.addShapeCube(buffer, a, s, b);
                            continue block17;
                        }
                        case Z: {
                            this.addShapeCube(buffer, a, b, s);
                        }
                    }
                }
            }
        }
        switch ((direction)((Object)this.propertyDir.value)) {
            case X: {
                this.propertySemi1.setName(BuildGuide.screenHandler.translate("property.buildguide.semiaxis", "Y"));
                this.propertySemi2.setName(BuildGuide.screenHandler.translate("property.buildguide.semiaxis", "Z"));
                break;
            }
            case Y: {
                this.propertySemi1.setName(BuildGuide.screenHandler.translate("property.buildguide.semiaxis", "X"));
                this.propertySemi2.setName(BuildGuide.screenHandler.translate("property.buildguide.semiaxis", "Z"));
                break;
            }
            case Z: {
                this.propertySemi1.setName(BuildGuide.screenHandler.translate("property.buildguide.semiaxis", "X"));
                this.propertySemi2.setName(BuildGuide.screenHandler.translate("property.buildguide.semiaxis", "Y"));
            }
        }
    }

    @Override
    public String getTranslationKey() {
        return "shape.buildguide.ellipse";
    }

    private static enum direction {
        X,
        Y,
        Z;

    }
}

