/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.shape;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.property.PropertyBoolean;
import brentmaas.buildguide.common.property.PropertyEnum;
import brentmaas.buildguide.common.property.PropertyPositiveFloat;
import brentmaas.buildguide.common.shape.IShapeBuffer;
import brentmaas.buildguide.common.shape.Shape;

public class ShapeEllipsoid
extends Shape {
    private String[] domeNames = new String[]{"-", "+X", "+Y", "+Z", "-X", "-Y", "-Z"};
    private PropertyPositiveFloat propertySemiX = new PropertyPositiveFloat(3.0f, BuildGuide.screenHandler.translate("property.buildguide.semiaxis", "X"), () -> this.update());
    private PropertyPositiveFloat propertySemiY = new PropertyPositiveFloat(3.0f, BuildGuide.screenHandler.translate("property.buildguide.semiaxis", "Y"), () -> this.update());
    private PropertyPositiveFloat propertySemiZ = new PropertyPositiveFloat(3.0f, BuildGuide.screenHandler.translate("property.buildguide.semiaxis", "Z"), () -> this.update());
    private PropertyEnum<dome> propertyDome = new PropertyEnum<dome>(dome.NO, BuildGuide.screenHandler.translate("property.buildguide.dome"), () -> this.update(), this.domeNames);
    private PropertyBoolean propertyEvenMode = new PropertyBoolean(false, BuildGuide.screenHandler.translate("property.buildguide.evenmode"), () -> this.update());

    public ShapeEllipsoid() {
        this.properties.add(this.propertySemiX);
        this.properties.add(this.propertySemiY);
        this.properties.add(this.propertySemiZ);
        this.properties.add(this.propertyDome);
        this.properties.add(this.propertyEvenMode);
    }

    @Override
    protected void updateShape(IShapeBuffer buffer) throws InterruptedException {
        float dx = ((Float)this.propertySemiX.value).floatValue();
        float dy = ((Float)this.propertySemiY.value).floatValue();
        float dz = ((Float)this.propertySemiZ.value).floatValue();
        double offset = (Boolean)this.propertyEvenMode.value != false ? 0.5 : 0.0;
        this.setBaseposOffset(offset, offset, offset);
        for (int x = (int)Math.floor((this.propertyDome.value == dome.POSITIVE_X ? 0.5 : (double)(-dx)) + offset); x <= (int)Math.ceil((this.propertyDome.value == dome.NEGATIVE_X ? -0.5 : (double)dx) + offset); ++x) {
            for (int y = (int)Math.floor((this.propertyDome.value == dome.POSITIVE_Y ? 0.5 : (double)(-dy)) + offset); y <= (int)Math.ceil((this.propertyDome.value == dome.NEGATIVE_Y ? -0.5 : (double)dy) + offset); ++y) {
                for (int z = (int)Math.floor((this.propertyDome.value == dome.POSITIVE_Z ? 0.5 : (double)(-dz)) + offset); z <= (int)Math.ceil((this.propertyDome.value == dome.NEGATIVE_Z ? -0.5 : (double)dz) + offset); ++z) {
                    double phi = Math.atan2((double)dx / (double)dy * ((double)y - offset), (double)x - offset);
                    double theta = Math.atan2(Math.sqrt(((double)x - offset) * ((double)x - offset) + (double)dx * (double)dx / (double)dy / (double)dy * ((double)y - offset) * ((double)y - offset)), (double)dx / (double)dz * ((double)z - offset));
                    double corr = Math.sqrt(1.0 + ((double)dx * (double)dx / (double)dy / (double)dy - 1.0) * Math.sin(phi) * Math.sin(phi) * Math.sin(theta) * Math.sin(theta) + ((double)dx * (double)dx / (double)dz / (double)dz - 1.0) * Math.cos(theta) * Math.cos(theta));
                    double drx = 0.5 * Math.cos(phi) * Math.sin(theta) / corr;
                    double dry = 0.5 * Math.sin(phi) * Math.sin(theta) * (double)dx / (double)dy / corr;
                    double drz = 0.5 * Math.cos(theta) * (double)dx / (double)dz / corr;
                    double r2_inner = ((double)x - offset - drx) * ((double)x - offset - drx) / (double)dx / (double)dx + ((double)y - offset - dry) * ((double)y - offset - dry) / (double)dy / (double)dy + ((double)z - offset - drz) * ((double)z - offset - drz) / (double)dz / (double)dz;
                    double r2_outer = ((double)x - offset + drx) * ((double)x - offset + drx) / (double)dx / (double)dx + ((double)y - offset + dry) * ((double)y - offset + dry) / (double)dy / (double)dy + ((double)z - offset + drz) * ((double)z - offset + drz) / (double)dz / (double)dz;
                    if (!(r2_outer >= 1.0) || !(r2_inner <= 1.0)) continue;
                    this.addShapeCube(buffer, x, y, z);
                }
            }
        }
    }

    @Override
    public String getTranslationKey() {
        return "shape.buildguide.ellipsoid";
    }

    private static enum dome {
        NO,
        POSITIVE_X,
        POSITIVE_Y,
        POSITIVE_Z,
        NEGATIVE_X,
        NEGATIVE_Y,
        NEGATIVE_Z;

    }
}

