/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.shape;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.property.PropertyBoolean;
import brentmaas.buildguide.common.property.PropertyEnum;
import brentmaas.buildguide.common.property.PropertyPositiveFloat;
import brentmaas.buildguide.common.shape.IShapeBuffer;
import brentmaas.buildguide.common.shape.Shape;

public class ShapeTorus
extends Shape {
    private String[] directionNames = new String[]{"X", "Y", "Z"};
    private PropertyEnum<direction> propertyDir = new PropertyEnum<direction>(direction.X, BuildGuide.screenHandler.translate("property.buildguide.direction"), () -> this.update(), this.directionNames);
    private PropertyPositiveFloat propertyOuterRadius = new PropertyPositiveFloat(5.0f, BuildGuide.screenHandler.translate("property.buildguide.outerradius"), () -> this.updateOuter());
    private PropertyPositiveFloat propertyInnerRadius = new PropertyPositiveFloat(3.0f, BuildGuide.screenHandler.translate("property.buildguide.innerradius"), () -> this.updateInner());
    private PropertyBoolean propertyOuterEvenMode = new PropertyBoolean(false, BuildGuide.screenHandler.translate("property.buildguide.outerevenmode"), () -> this.update());
    private PropertyBoolean propertyInnerEvenMode = new PropertyBoolean(false, BuildGuide.screenHandler.translate("property.buildguide.innerevenmode"), () -> this.update());

    public ShapeTorus() {
        this.properties.add(this.propertyDir);
        this.properties.add(this.propertyOuterRadius);
        this.properties.add(this.propertyInnerRadius);
        this.properties.add(this.propertyOuterEvenMode);
        this.properties.add(this.propertyInnerEvenMode);
    }

    @Override
    protected void updateShape(IShapeBuffer buffer) throws InterruptedException {
        float or = ((Float)this.propertyOuterRadius.value).floatValue();
        float ir = ((Float)this.propertyInnerRadius.value).floatValue();
        double offsetOuter = (Boolean)this.propertyOuterEvenMode.value != false ? 0.5 : 0.0;
        double offsetInner = (Boolean)this.propertyInnerEvenMode.value != false ? 0.5 : 0.0;
        switch ((direction)((Object)this.propertyDir.value)) {
            case X: {
                this.setBaseposOffset(offsetInner, offsetOuter, offsetOuter);
                break;
            }
            case Y: {
                this.setBaseposOffset(offsetOuter, offsetInner, offsetOuter);
                break;
            }
            case Z: {
                this.setBaseposOffset(offsetOuter, offsetOuter, offsetInner);
            }
        }
        for (int a = (int)Math.floor((double)(-or - ir) - offsetOuter); a < (int)Math.ceil((double)(or + ir + 1.0f) + offsetOuter); ++a) {
            for (int b = (int)Math.floor((double)(-or - ir) - offsetOuter); b < (int)Math.ceil((double)(or + ir + 1.0f) + offsetOuter); ++b) {
                double theta = Math.atan2((double)b - offsetOuter, (double)a - offsetOuter);
                double a_circ = (double)or * Math.cos(theta) + offsetOuter;
                double b_circ = (double)or * Math.sin(theta) + offsetOuter;
                block12: for (int c = (int)Math.floor((double)(-ir) + offsetInner); c < (int)Math.ceil((double)(ir + 1.0f) + offsetInner); ++c) {
                    double r2 = ((double)a - a_circ) * ((double)a - a_circ) + ((double)b - b_circ) * ((double)b - b_circ) + ((double)c - offsetInner) * ((double)c - offsetInner);
                    if (!(r2 >= ((double)ir - 0.5) * ((double)ir - 0.5)) || !(r2 < ((double)ir + 0.5) * ((double)ir + 0.5))) continue;
                    switch ((direction)((Object)this.propertyDir.value)) {
                        case X: {
                            this.addShapeCube(buffer, c, b, a);
                            continue block12;
                        }
                        case Y: {
                            this.addShapeCube(buffer, a, c, b);
                            continue block12;
                        }
                        case Z: {
                            this.addShapeCube(buffer, b, a, c);
                        }
                    }
                }
            }
        }
    }

    private void updateOuter() {
        if (((Float)this.propertyOuterRadius.value).floatValue() < ((Float)this.propertyInnerRadius.value).floatValue()) {
            this.propertyInnerRadius.setValue((Float)this.propertyOuterRadius.value);
        }
        this.update();
    }

    private void updateInner() {
        if (((Float)this.propertyOuterRadius.value).floatValue() < ((Float)this.propertyInnerRadius.value).floatValue()) {
            this.propertyOuterRadius.setValue((Float)this.propertyInnerRadius.value);
        }
        this.update();
    }

    @Override
    public String getTranslationKey() {
        return "shape.buildguide.torus";
    }

    private static enum direction {
        X,
        Y,
        Z;

    }
}

