/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client;

import com.google.common.collect.Lists;
import com.teamresourceful.resourcefulconfig.client.ValueWidget;
import com.teamresourceful.resourcefulconfig.client.options.Options;
import com.teamresourceful.resourcefulconfig.common.annotations.Comment;
import com.teamresourceful.resourcefulconfig.common.annotations.ConfigEntry;
import com.teamresourceful.resourcefulconfig.common.config.ParsingUtils;
import com.teamresourceful.resourcefulconfig.common.config.ResourcefulConfigEntry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class ConfigValueWidget
extends ValueWidget {
    private final int left;
    private final ResourcefulConfigEntry entry;
    private final Component label;
    private AbstractWidget children;
    private final AbstractWidget reset;
    private final Component tooltip;

    public ConfigValueWidget(int left, int right, ResourcefulConfigEntry entry) {
        this.left = left;
        this.entry = entry;
        ConfigEntry annotation = entry.field().getAnnotation(ConfigEntry.class);
        this.label = annotation == null ? CommonComponents.f_237098_ : Component.m_237115_((String)annotation.translation());
        this.children = Options.create(right - 110, 0, 100, entry);
        this.reset = Button.m_253074_((Component)Component.m_237113_((String)"\u274c").m_130940_(ChatFormatting.BOLD), button -> {
            entry.reset();
            this.children = Options.create(right - 110, 0, 100, entry);
        }).m_252987_(right - 140, 0, 20, 20).m_253136_();
        this.reset.f_93623_ = this.children.f_93623_ && entry.isModified(ParsingUtils.getField(entry.field()));
        Comment comment = entry.field().getAnnotation(Comment.class);
        this.tooltip = comment == null ? CommonComponents.f_237098_ : (comment.translation().isEmpty() ? Component.m_237113_((String)comment.value()) : Component.m_237115_((String)comment.translation()));
    }

    @Override
    public void m_6311_(@NotNull GuiGraphics graphics, int i, int j, int k, int l, int m, int n, int o, boolean bl, float f) {
        Font font = Minecraft.m_91087_().f_91062_;
        graphics.m_280614_(font, this.label, this.left + 10, j + 5, 0xFFFFFF, false);
        this.reset.f_93623_ = this.children.f_93623_ && this.entry.isModified(ParsingUtils.getField(this.entry.field()));
        this.reset.m_253211_(j);
        this.reset.m_88315_(graphics, n, o, f);
        this.children.m_253211_(j);
        this.children.m_88315_(graphics, n, o, f);
    }

    @Override
    @NotNull
    public List<? extends GuiEventListener> m_6702_() {
        return Lists.newArrayList((Object[])new AbstractWidget[]{this.children, this.reset});
    }

    @Override
    @NotNull
    public List<? extends NarratableEntry> m_142437_() {
        return Lists.newArrayList((Object[])new AbstractWidget[]{this.children, this.reset});
    }

    public AbstractWidget getChildren() {
        return this.children;
    }

    public AbstractWidget getReset() {
        return this.reset;
    }

    @Override
    public List<FormattedCharSequence> getTooltip() {
        return Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)this.tooltip, 200);
    }
}

