/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.repack.org.quartz.core;

import net.creeperhost.ftbbackups.repack.org.quartz.JobKey;
import net.creeperhost.ftbbackups.repack.org.quartz.SchedulerException;
import net.creeperhost.ftbbackups.repack.org.quartz.Trigger;
import net.creeperhost.ftbbackups.repack.org.quartz.core.QuartzScheduler;
import net.creeperhost.ftbbackups.repack.org.quartz.core.QuartzSchedulerThread;
import net.creeperhost.ftbbackups.repack.org.quartz.spi.SchedulerSignaler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerSignalerImpl
implements SchedulerSignaler {
    Logger log = LoggerFactory.getLogger(SchedulerSignalerImpl.class);
    protected QuartzScheduler sched;
    protected QuartzSchedulerThread schedThread;

    public SchedulerSignalerImpl(QuartzScheduler sched, QuartzSchedulerThread schedThread) {
        this.sched = sched;
        this.schedThread = schedThread;
        this.log.info("Initialized Scheduler Signaller of type: " + this.getClass());
    }

    public void notifyTriggerListenersMisfired(Trigger trigger) {
        try {
            this.sched.notifyTriggerListenersMisfired(trigger);
        }
        catch (SchedulerException se) {
            this.sched.getLog().error("Error notifying listeners of trigger misfire.", (Throwable)se);
            this.sched.notifySchedulerListenersError("Error notifying listeners of trigger misfire.", se);
        }
    }

    public void notifySchedulerListenersFinalized(Trigger trigger) {
        this.sched.notifySchedulerListenersFinalized(trigger);
    }

    public void signalSchedulingChange(long candidateNewNextFireTime) {
        this.schedThread.signalSchedulingChange(candidateNewNextFireTime);
    }

    public void notifySchedulerListenersJobDeleted(JobKey jobKey) {
        this.sched.notifySchedulerListenersJobDeleted(jobKey);
    }
}

