/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen.list;

import com.google.common.collect.Streams;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.client.screen.list.EnumListType;
import com.mrcrayfish.configured.client.screen.list.IListConfigValue;
import com.mrcrayfish.configured.client.screen.list.IListType;
import com.mrcrayfish.configured.client.screen.list.ListType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;

public class ListTypes {
    private static final Map<IConfigValue<?>, IListType<?>> TYPE_CACHE = new HashMap();
    private static final IListType<?> UNKNOWN = new ListType<String>(Object::toString, o -> o, "configured.parser.not_a_value");
    public static final IListType<Boolean> BOOLEAN = new ListType<Boolean>(Object::toString, Boolean::valueOf, "configured.parser.not_a_boolean");
    public static final IListType<Integer> INTEGER = new ListType<Integer>(Object::toString, Integer::parseInt, "configured.parser.not_a_number");
    public static final IListType<Long> LONG = new ListType<Long>(Object::toString, Long::parseLong, "configured.parser.not_a_number");
    public static final IListType<Double> DOUBLE = new ListType<Double>(Object::toString, Double::parseDouble, "configured.parser.not_a_number");
    public static final IListType<String> STRING = new ListType<String>(Function.identity(), Function.identity(), "configured.parser.not_a_value");

    public static <T> IListType<T> getUnknown() {
        return UNKNOWN;
    }

    public static <T> IListType<T> getType(IConfigValue<List<T>> holder) {
        IListConfigValue provider;
        IListType type;
        if (holder instanceof IListConfigValue && (type = (provider = (IListConfigValue)holder).getListType()) != null) {
            return type;
        }
        return TYPE_CACHE.computeIfAbsent(holder, value -> ListTypes.fromHolder(holder));
    }

    private static <T> IListType<T> fromHolder(IConfigValue<List<T>> holder) {
        return ListTypes.getListValues(holder).map(ListTypes::fromObject).filter(t -> t != UNKNOWN).findAny().orElseGet(() -> ListTypes.fromElementValidator(holder));
    }

    private static <T> Stream<T> getListValues(IConfigValue<List<T>> holder) {
        return Streams.concat((Stream[])new Stream[]{holder.get().stream(), holder.getDefault().stream()}).filter(Objects::nonNull);
    }

    private static <T> IListType<T> fromObject(T o) {
        if (o instanceof Boolean) {
            return BOOLEAN;
        }
        if (o instanceof Integer) {
            return INTEGER;
        }
        if (o instanceof Long) {
            return LONG;
        }
        if (o instanceof Double) {
            return DOUBLE;
        }
        if (o instanceof String) {
            return STRING;
        }
        if (o instanceof Enum) {
            Enum enumValue = (Enum)o;
            return new EnumListType(enumValue.getClass());
        }
        return UNKNOWN;
    }

    private static <T> IListType<T> fromElementValidator(IConfigValue<List<T>> spec) {
        if (ListTypes.safeTryIsValid(spec, Collections.singletonList("s"))) {
            return STRING;
        }
        if (ListTypes.safeTryIsValid(spec, Collections.singletonList(true))) {
            return BOOLEAN;
        }
        if (ListTypes.safeTryIsValid(spec, Collections.singletonList(0.0))) {
            return DOUBLE;
        }
        if (ListTypes.safeTryIsValid(spec, Collections.singletonList(0L))) {
            return LONG;
        }
        if (ListTypes.safeTryIsValid(spec, Collections.singletonList(0))) {
            return INTEGER;
        }
        return UNKNOWN;
    }

    private static <T> boolean safeTryIsValid(IConfigValue<List<T>> spec, List<?> list) {
        try {
            return spec.isValid(list);
        }
        catch (ClassCastException ignored) {
            return false;
        }
    }
}

