/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.container;

import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.zeith.hammerlib.api.forge.ContainerAPI;
import org.zeith.hammerlib.api.inv.IScreenContainer;
import org.zeith.solarflux.block.SolarPanelTile;
import org.zeith.solarflux.client.screen.SolarPanelScreen;
import org.zeith.solarflux.container.SlotChargable;
import org.zeith.solarflux.container.SlotUpgrade;
import org.zeith.solarflux.util.ComplexProgressManager;

public class SolarPanelContainer
extends AbstractContainerMenu
implements IScreenContainer {
    public final SolarPanelTile panel;
    public final ComplexProgressManager progressHandler = new ComplexProgressManager(36, 0);

    public SolarPanelContainer(int id, Inventory playerInv, SolarPanelTile tile) {
        super(ContainerAPI.TILE_CONTAINER, id);
        this.panel = tile;
        this.addPlayerInventorySlotsToContainer(playerInv, 8, 98);
        this.addPlayerActionSlotsToContainer(playerInv, 8, 156);
        for (int i = 0; i < tile.upgradeInventory.getSlots(); ++i) {
            this.m_38897_((Slot)new SlotUpgrade(tile, i, i * 18 + 9, 61));
        }
        this.m_38897_((Slot)new SlotChargable((IItemHandlerModifiable)tile.chargeInventory, 0, 151, 9));
    }

    protected void addPlayerInventorySlotsToContainer(Inventory pInventoryPlayer, int pLeft, int pTop) {
        for (int inventoryRowIndex = 0; inventoryRowIndex < 3; ++inventoryRowIndex) {
            for (int inventoryColumnIndex = 0; inventoryColumnIndex < 9; ++inventoryColumnIndex) {
                this.m_38897_(new Slot((Container)pInventoryPlayer, inventoryColumnIndex + inventoryRowIndex * 9 + 9, pLeft + inventoryColumnIndex * 18, pTop + inventoryRowIndex * 18));
            }
        }
    }

    protected void addPlayerActionSlotsToContainer(Inventory player, int x, int y) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)player, i, x + i * 18, y));
        }
    }

    public void m_38946_() {
        this.progressHandler.putLong(0, this.panel.energy);
        this.progressHandler.putLong(8, this.panel.capacity.getValueL());
        this.progressHandler.putLong(16, this.panel.currentGeneration);
        this.progressHandler.putLong(24, this.panel.generation.getValueL());
        this.progressHandler.putFloat(32, this.panel.sunIntensity);
        this.progressHandler.detectAndSendChanges(this);
        super.m_38946_();
    }

    public void m_7511_(int id, int data) {
        this.progressHandler.updateChange(id, data);
    }

    public boolean m_6875_(Player playerIn) {
        return this.panel.m_58899_().m_203195_((Position)playerIn.m_20182_(), 64.0) && !this.panel.m_58901_();
    }

    public ItemStack m_7648_(Player p_82846_1_, int p_82846_2_) {
        return ItemStack.f_41583_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Screen openScreen(Inventory inv, Component label) {
        return new SolarPanelScreen(this, inv, label);
    }
}

