/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.serializer;

import com.christofmeg.justenoughbreeding.JustEnoughBreeding;
import com.christofmeg.justenoughbreeding.recipe.BaseRecipe;
import com.christofmeg.justenoughbreeding.recipe.TransformationRecipe;
import com.christofmeg.justenoughbreeding.utils.CommonUtils;
import com.christofmeg.justenoughbreeding.utils.Utils;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class TransformationSerializer
implements RecipeSerializer<TransformationRecipe> {
    @NotNull
    public TransformationRecipe fromJson(@NotNull ResourceLocation jsonPath, @NotNull JsonObject json) {
        return (TransformationRecipe)TransformationSerializer.readJsonContents(jsonPath, json);
    }

    @NotNull
    public TransformationRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
        ResourceLocation inputEntityId = buf.m_130281_();
        EntityType<?> inputEntityType = JustEnoughBreeding.getEntityFromLoaderRegistries(inputEntityId);
        if (inputEntityType == null) {
            throw new JsonParseException("Unknown input EntityType in TransformationRecipe#fromNetwork: " + inputEntityId);
        }
        ResourceLocation outputEntityId = buf.m_130281_();
        EntityType<?> outputEntityType = JustEnoughBreeding.getEntityFromLoaderRegistries(outputEntityId);
        if (outputEntityType == null) {
            throw new JsonParseException("Unknown output EntityType in TransformationRecipe#fromNetwork: " + outputEntityId);
        }
        Ingredient inputStack = Ingredient.m_43940_((FriendlyByteBuf)buf);
        Ingredient inputSpawnEgg = Ingredient.m_43940_((FriendlyByteBuf)buf);
        boolean hasExtraInput = buf.readBoolean();
        Ingredient extraInputStack = hasExtraInput ? Ingredient.m_43940_((FriendlyByteBuf)buf) : Ingredient.f_43901_;
        Ingredient outputSpawnEgg = Ingredient.m_43940_((FriendlyByteBuf)buf);
        Boolean needsToBeTamed = buf.readBoolean() ? Boolean.valueOf(buf.readBoolean()) : null;
        String jsonModID = buf.m_130277_();
        String modFolder = buf.m_130277_();
        String fileName = buf.m_130277_();
        CompoundTag inputEntityNbt = buf.readBoolean() ? buf.m_130260_() : null;
        CompoundTag outputEntityNbt = buf.readBoolean() ? buf.m_130260_() : null;
        return new TransformationRecipe(inputEntityType, inputStack, inputSpawnEgg, extraInputStack, outputEntityType, outputSpawnEgg, needsToBeTamed, jsonModID, modFolder, fileName, inputEntityNbt, outputEntityNbt);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull TransformationRecipe recipe) {
        ResourceLocation inKey = JustEnoughBreeding.getKeyLoaderRegistries(recipe.inputEntityType);
        ResourceLocation outKey = JustEnoughBreeding.getKeyLoaderRegistries(recipe.outputEntityType);
        if (inKey == null || outKey == null) {
            throw new JsonParseException("Unknown EntityType in TransformationRecipe: " + recipe.inputEntityType + " / " + recipe.outputEntityType);
        }
        buf.m_130085_(inKey);
        buf.m_130085_(outKey);
        CommonUtils.safe(recipe.inputStack).m_43923_(buf);
        CommonUtils.safe(recipe.inputSpawnEgg).m_43923_(buf);
        boolean hasExtra = recipe.extraInputStack != null && !recipe.extraInputStack.m_43947_();
        buf.writeBoolean(hasExtra);
        if (hasExtra) {
            recipe.extraInputStack.m_43923_(buf);
        }
        CommonUtils.safe(recipe.outputSpawnEgg).m_43923_(buf);
        if (recipe.needsToBeTamed != null) {
            buf.writeBoolean(true);
            buf.writeBoolean(recipe.needsToBeTamed.booleanValue());
        } else {
            buf.writeBoolean(false);
        }
        buf.m_130070_(recipe.jsonModID);
        buf.m_130070_(recipe.modFolder);
        buf.m_130070_(recipe.fileName);
        if (recipe.inputEntityNbt != null) {
            buf.writeBoolean(true);
            buf.m_130079_(recipe.inputEntityNbt);
        } else {
            buf.writeBoolean(false);
        }
        if (recipe.outputEntityNbt != null) {
            buf.writeBoolean(true);
            buf.m_130079_(recipe.outputEntityNbt);
        } else {
            buf.writeBoolean(false);
        }
    }

    public static BaseRecipe readJsonContents(@NotNull ResourceLocation jsonPath, @NotNull JsonObject json) {
        ItemStack spawnEgg;
        String jsonModID = json.get("mod").getAsString();
        String modFolder = jsonPath.m_135827_();
        String fileName = jsonPath.m_135815_().substring(jsonPath.m_135815_().lastIndexOf(47) + 1);
        if (jsonPath.m_135827_().equals("justenoughbreeding")) {
            modFolder = jsonPath.m_135815_().split("/")[1];
        }
        if (!JustEnoughBreeding.isModLoaded(modFolder).booleanValue() || !JustEnoughBreeding.isModLoaded(jsonModID).booleanValue()) {
            return new TransformationRecipe.DummyRecipe(jsonModID, modFolder, fileName);
        }
        ArrayList<Ingredient> inputIngredients = new ArrayList<Ingredient>();
        ArrayList<Ingredient> extraInputIngredients = new ArrayList<Ingredient>();
        ArrayList<Ingredient> inputSpawnEggs = new ArrayList<Ingredient>();
        ArrayList<Ingredient> outputSpawnEggs = new ArrayList<Ingredient>();
        EntityType<?> inputEntityType = null;
        if (json.has("input_entity")) {
            String input_entity = json.get("input_entity").getAsString();
            inputEntityType = JustEnoughBreeding.getEntityFromLoaderRegistries(new ResourceLocation(input_entity));
        }
        EntityType<?> outputEntityType = null;
        if (json.has("output_entity")) {
            String outputEntity = json.get("output_entity").getAsString();
            outputEntityType = JustEnoughBreeding.getEntityFromLoaderRegistries(new ResourceLocation(outputEntity));
        }
        if (inputEntityType == null || outputEntityType == null) {
            throw new JsonParseException("Transformation recipe missing/unknown entities in " + jsonPath);
        }
        Utils.addIngredients(json, inputIngredients, "inputs");
        Utils.addIngredients(json, extraInputIngredients, "extra_inputs");
        Utils.addIngredients(json, inputSpawnEggs, "input_spawn_eggs");
        Utils.addIngredients(json, outputSpawnEggs, "output_spawn_eggs");
        if (inputSpawnEggs.isEmpty()) {
            spawnEgg = Optional.ofNullable(JustEnoughBreeding.getSpawnEggItem(inputEntityType)).map(Item::m_7968_).orElse(ItemStack.f_41583_);
            inputSpawnEggs = new ArrayList<Ingredient>(List.of(Ingredient.m_43927_((ItemStack[])new ItemStack[]{spawnEgg})));
        }
        if (outputSpawnEggs.isEmpty()) {
            spawnEgg = Optional.ofNullable(JustEnoughBreeding.getSpawnEggItem(outputEntityType)).map(Item::m_7968_).orElse(ItemStack.f_41583_);
            outputSpawnEggs = new ArrayList<Ingredient>(List.of(Ingredient.m_43927_((ItemStack[])new ItemStack[]{spawnEgg})));
        }
        for (TransformationRecipe existingRecipe : JustEnoughBreeding.transformationRecipes) {
            if (!existingRecipe.m_6423_().equals((Object)jsonPath)) continue;
            inputIngredients.add(existingRecipe.inputStack);
            extraInputIngredients.add(existingRecipe.extraInputStack);
            inputSpawnEggs.add(existingRecipe.inputSpawnEgg);
            outputSpawnEggs.add(existingRecipe.outputSpawnEgg);
            existingRecipe.setInputIngredient(Utils.deduplicateIngredients(inputIngredients));
            existingRecipe.setExtraInputIngredient(Utils.deduplicateIngredients(extraInputIngredients));
            existingRecipe.setInputSpawnEggs(Utils.deduplicateIngredients(inputSpawnEggs));
            existingRecipe.setOutputSpawnEggs(Utils.deduplicateIngredients(outputSpawnEggs));
            return existingRecipe;
        }
        boolean isTamed = json.has("tamed") && json.get("tamed").getAsBoolean();
        CompoundTag inputEntityNbt = json.has("input_entity_nbt") ? CommonUtils.parseJsonNBT(json.get("input_entity_nbt")) : null;
        CompoundTag outputEntityNbt = json.has("output_entity_nbt") ? CommonUtils.parseJsonNBT(json.get("output_entity_nbt")) : null;
        TransformationRecipe r = new TransformationRecipe(inputEntityType, Utils.deduplicateIngredients(inputIngredients), Utils.deduplicateIngredients(inputSpawnEggs), Utils.deduplicateIngredients(extraInputIngredients), outputEntityType, Utils.deduplicateIngredients(outputSpawnEggs), isTamed, jsonModID, modFolder, fileName, inputEntityNbt, outputEntityNbt);
        JustEnoughBreeding.transformationRecipes.add(r);
        return r;
    }
}

