/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.block;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.NetworkedPipeBlock;
import jagm.classicpipes.blockentity.PipeEntity;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.FacingOrNone;
import jagm.classicpipes.util.MiscUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;

public abstract class ContainerAdjacentNetworkedPipeBlock
extends NetworkedPipeBlock {
    public static final EnumProperty<FacingOrNone> FACING = FacingOrNone.BLOCK_PROPERTY;

    public ContainerAdjacentNetworkedPipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(FACING, (Comparable)((Object)FacingOrNone.NONE)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState superState = super.m_5573_(context);
        if (superState != null) {
            for (Direction direction : Direction.values()) {
                if (!this.isPipeConnected(superState, direction) || !Services.LOADER_SERVICE.canAccessContainer(context.m_43725_(), context.m_8083_().m_121945_(direction), direction.m_122424_())) continue;
                return (BlockState)superState.m_263224_(FACING, (Comparable)((Object)FacingOrNone.with(direction)));
            }
            return (BlockState)superState.m_263224_(FACING, (Comparable)((Object)FacingOrNone.NONE));
        }
        return this.m_49966_();
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction initialDirection, BlockState neighborState, LevelAccessor level, BlockPos pipePos, BlockPos neighborPos) {
        BlockEntity blockEntity;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pipePos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        boolean wasConnected = this.isPipeConnected(state, initialDirection);
        boolean willConnect = this.canConnect((Level)level, pipePos, initialDirection);
        Direction direction = (state = this.setPipeConnected(state, initialDirection, willConnect)).m_61143_(FACING) == FacingOrNone.NONE ? Direction.DOWN : ((FacingOrNone)((Object)state.m_61143_(FACING))).getDirection();
        state = (BlockState)state.m_61124_(FACING, (Comparable)((Object)FacingOrNone.NONE));
        for (int i = 0; i < 6; ++i) {
            if (this.isPipeConnected(state, direction) && Services.LOADER_SERVICE.canAccessContainer((Level)level, pipePos.m_121945_(direction), direction.m_122424_())) {
                state = (BlockState)state.m_61124_(FACING, (Comparable)((Object)FacingOrNone.with(direction)));
                break;
            }
            direction = MiscUtil.nextDirection(direction);
        }
        if (wasConnected != willConnect && (blockEntity = level.m_7702_(pipePos)) instanceof PipeEntity) {
            PipeEntity pipe = (PipeEntity)blockEntity;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                pipe.scheduleUpdate(serverLevel, state, pipePos, initialDirection, wasConnected);
            }
        }
        return state;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pipePos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Direction facing = ((FacingOrNone)((Object)state.m_61143_(FACING))).getDirection();
        if (player.m_150110_().f_35938_ && player.m_6047_() && !MiscUtil.itemIsPipe(player.m_21205_()) && facing != null) {
            Direction direction = MiscUtil.nextDirection(facing);
            for (int i = 0; i < 5; ++i) {
                BlockPos nextPos = pipePos.m_121945_(direction);
                if (this.isPipeConnected(state, direction) && Services.LOADER_SERVICE.canAccessContainer(level, nextPos, direction.m_122424_())) {
                    BlockState newState = (BlockState)state.m_61124_(FACING, (Comparable)((Object)FacingOrNone.with(direction)));
                    level.m_7731_(pipePos, newState, 3);
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_247517_(null, pipePos, ClassicPipes.PIPE_ADJUST_SOUND, SoundSource.BLOCKS);
                        this.onNeighborChange(newState, (LevelReader)serverLevel, pipePos, nextPos);
                    }
                    return InteractionResult.SUCCESS;
                }
                direction = MiscUtil.nextDirection(direction);
            }
        }
        return InteractionResult.PASS;
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
    }
}

