/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.block;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.FluidPipeBlock;
import jagm.classicpipes.blockentity.FluidPipeEntity;
import jagm.classicpipes.blockentity.LapisFluidPipeEntity;
import jagm.classicpipes.blockentity.PipeEntity;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.FacingOrNone;
import jagm.classicpipes.util.FluidInPipe;
import jagm.classicpipes.util.MiscUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class LapisFluidPipeBlock
extends FluidPipeBlock {
    public static final EnumProperty<FacingOrNone> FACING = FacingOrNone.BLOCK_PROPERTY;

    public LapisFluidPipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(FACING, (Comparable)((Object)FacingOrNone.NONE)));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LapisFluidPipeEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return blockEntityType == ClassicPipes.LAPIS_FLUID_PIPE_ENTITY ? PipeEntity::tick : null;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState superState = super.m_5573_(context);
        if (superState != null) {
            for (Direction direction : Direction.values()) {
                if (!this.isPipeConnected(superState, direction) || !Services.LOADER_SERVICE.canAccessFluidContainer(context.m_43725_(), context.m_8083_().m_121945_(direction), direction.m_122424_())) continue;
                return (BlockState)superState.m_263224_(FACING, (Comparable)((Object)FacingOrNone.with(direction)));
            }
            return (BlockState)superState.m_263224_(FACING, (Comparable)((Object)FacingOrNone.NONE));
        }
        return this.m_49966_();
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction initialDirection, BlockState neighborState, LevelAccessor level, BlockPos pipePos, BlockPos neighborPos) {
        BlockState superState = super.m_7417_(state, initialDirection, neighborState, level, pipePos, neighborPos);
        Direction direction = superState.m_61143_(FACING) == FacingOrNone.NONE ? Direction.DOWN : ((FacingOrNone)((Object)superState.m_61143_(FACING))).getDirection();
        for (int i = 0; i < 6; ++i) {
            if (this.isPipeConnected(superState, direction) && Services.LOADER_SERVICE.canAccessFluidContainer((Level)level, pipePos.m_121945_(direction), direction.m_122424_())) {
                return (BlockState)superState.m_61124_(FACING, (Comparable)((Object)FacingOrNone.with(direction)));
            }
            direction = MiscUtil.nextDirection(direction);
        }
        return (BlockState)superState.m_61124_(FACING, (Comparable)((Object)FacingOrNone.NONE));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pipePos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.m_150110_().f_35938_ && !MiscUtil.itemIsPipe(player.m_21205_()) && state.m_61143_(FACING) != FacingOrNone.NONE) {
            Direction direction = MiscUtil.nextDirection(((FacingOrNone)((Object)state.m_61143_(FACING))).getDirection());
            for (int i = 0; i < 5; ++i) {
                if (this.isPipeConnected(state, direction) && Services.LOADER_SERVICE.canAccessFluidContainer(level, pipePos.m_121945_(direction), direction.m_122424_())) {
                    Object object;
                    level.m_7731_(pipePos, (BlockState)state.m_61124_(FACING, (Comparable)((Object)FacingOrNone.with(direction))), 3);
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_247517_(null, pipePos, ClassicPipes.PIPE_ADJUST_SOUND, SoundSource.BLOCKS);
                    }
                    if ((object = level.m_7702_(pipePos)) instanceof FluidPipeEntity) {
                        FluidPipeEntity pipe = (FluidPipeEntity)((Object)object);
                        for (FluidInPipe fluidPacket : pipe.getContents()) {
                            if (fluidPacket.getProgress() >= 1024) continue;
                            pipe.routePacket(state, fluidPacket);
                        }
                        pipe.addQueuedPackets(level, false);
                        pipe.m_6596_();
                    }
                    return InteractionResult.SUCCESS;
                }
                direction = MiscUtil.nextDirection(direction);
            }
        }
        return InteractionResult.PASS;
    }
}

