/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.blockentity.RoundRobinPipeEntity;
import jagm.classicpipes.inventory.container.DirectionalFilterContainer;
import jagm.classicpipes.inventory.container.Filter;
import jagm.classicpipes.inventory.menu.DiamondPipeMenu;
import jagm.classicpipes.util.ItemInPipe;
import jagm.classicpipes.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class DiamondPipeEntity
extends RoundRobinPipeEntity
implements MenuProvider {
    private final DirectionalFilterContainer filter = new DirectionalFilterContainer(this, false);

    public DiamondPipeEntity(BlockPos pos, BlockState state) {
        super(ClassicPipes.DIAMOND_PIPE_ENTITY, pos, state);
    }

    @Override
    protected List<Direction> getValidDirections(BlockState state, ItemInPipe item) {
        int i;
        ArrayList<Direction> validDirections = new ArrayList<Direction>();
        Direction direction = MiscUtil.nextDirection(item.getFromDirection());
        HashMap matchPriority = new HashMap();
        matchPriority.put(Filter.MatchingResult.ITEM, new ArrayList());
        matchPriority.put(Filter.MatchingResult.TAG, new ArrayList());
        matchPriority.put(Filter.MatchingResult.MOD, new ArrayList());
        for (i = 0; i < 5; ++i) {
            Filter.MatchingResult result = this.filter.directionMatches(item.getStack(), direction);
            if (this.isPipeConnected(state, direction) && result.matches) {
                ((List)matchPriority.get((Object)result)).add(direction);
            }
            direction = MiscUtil.nextDirection(direction);
        }
        if (!((List)matchPriority.get((Object)Filter.MatchingResult.ITEM)).isEmpty()) {
            validDirections.addAll((Collection)matchPriority.get((Object)Filter.MatchingResult.ITEM));
        } else if (!((List)matchPriority.get((Object)Filter.MatchingResult.TAG)).isEmpty()) {
            validDirections.addAll((Collection)matchPriority.get((Object)Filter.MatchingResult.TAG));
        } else if (!((List)matchPriority.get((Object)Filter.MatchingResult.MOD)).isEmpty()) {
            validDirections.addAll((Collection)matchPriority.get((Object)Filter.MatchingResult.MOD));
        }
        if (validDirections.isEmpty() && this.filter.directionMatches((ItemStack)item.getStack(), (Direction)direction).matches) {
            validDirections.add(item.getFromDirection());
        }
        if (validDirections.isEmpty()) {
            direction = MiscUtil.nextDirection(item.getFromDirection());
            for (i = 0; i < 5; ++i) {
                if (this.isPipeConnected(state, direction) && this.filter.directionEmpty(direction)) {
                    validDirections.add(direction);
                }
                direction = MiscUtil.nextDirection(direction);
            }
        }
        if (validDirections.isEmpty() && this.filter.directionEmpty(item.getFromDirection())) {
            validDirections.add(item.getFromDirection());
        }
        return validDirections;
    }

    @Override
    protected boolean canJoinNetwork() {
        return false;
    }

    @Override
    public void m_142466_(CompoundTag valueInput) {
        this.filter.m_6211_();
        super.m_142466_(valueInput);
        ListTag filterList = valueInput.m_128437_("filter", 10);
        filterList.forEach(tag -> {
            if (tag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)tag;
                int slot = compoundTag.m_128451_("slot");
                MiscUtil.loadFromTag(tag, ItemStack.f_41582_, stack -> this.filter.m_6836_(slot, (ItemStack)stack));
            }
        });
        this.filter.setMatchComponents(valueInput.m_128471_("match_components"));
    }

    @Override
    protected void m_183515_(CompoundTag valueOutput) {
        super.m_183515_(valueOutput);
        ListTag filterList = new ListTag();
        for (int slot = 0; slot < this.filter.m_6643_(); ++slot) {
            ItemStack stack = this.filter.m_8020_(slot);
            if (stack.m_41619_()) continue;
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("slot", slot);
            MiscUtil.saveToTag((Tag)tag, stack, ItemStack.f_41582_, arg_0 -> filterList.add(arg_0));
        }
        valueOutput.m_128365_("filter", (Tag)filterList);
        valueOutput.m_128379_("match_components", this.filter.shouldMatchComponents());
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.classicpipes.diamond_pipe");
    }

    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return new DiamondPipeMenu(id, playerInventory, (Filter)this.filter);
    }

    public boolean shouldMatchComponents() {
        return this.filter.shouldMatchComponents();
    }
}

