/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.block.ContainerAdjacentNetworkedPipeBlock;
import jagm.classicpipes.block.NetworkedPipeBlock;
import jagm.classicpipes.blockentity.MatchingPipe;
import jagm.classicpipes.blockentity.RecipePipeEntity;
import jagm.classicpipes.blockentity.RoundRobinPipeEntity;
import jagm.classicpipes.blockentity.RoutingPipeEntity;
import jagm.classicpipes.blockentity.StockingPipeEntity;
import jagm.classicpipes.inventory.container.Filter;
import jagm.classicpipes.util.FacingOrNone;
import jagm.classicpipes.util.ItemInPipe;
import jagm.classicpipes.util.MiscUtil;
import jagm.classicpipes.util.PipeNetwork;
import jagm.classicpipes.util.RequestedItem;
import jagm.classicpipes.util.ScheduledRoute;
import jagm.classicpipes.util.SortingMode;
import jagm.classicpipes.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class NetworkedPipeEntity
extends RoundRobinPipeEntity {
    private final Map<ItemStack, ScheduledRoute> routingSchedule = new HashMap<ItemStack, ScheduledRoute>();
    private PipeNetwork network = null;
    private boolean controller = false;
    public BlockPos syncedNetworkPos = this.m_58899_();

    public NetworkedPipeEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    @Override
    public void tickServer(ServerLevel level, BlockPos pos, BlockState state) {
        super.tickServer(level, pos, state);
        if (!this.routingSchedule.isEmpty()) {
            Iterator<ItemStack> iterator = this.routingSchedule.keySet().iterator();
            while (iterator.hasNext()) {
                ScheduledRoute route = this.routingSchedule.get(iterator.next());
                route.tick();
                if (!route.timedOut()) continue;
                iterator.remove();
                this.m_6596_();
            }
        }
        if (this.isController()) {
            this.getNetwork().tick(level);
        }
    }

    @Override
    protected void initialiseNetworking(ServerLevel level, BlockState state, BlockPos pos) {
        if (this.isController() && this.hasNetwork()) {
            this.distributeNetwork(level, this.m_58899_(), new HashSet<NetworkedPipeEntity>(), this.getNetwork());
        }
        super.initialiseNetworking(level, state, pos);
    }

    protected Set<NetworkedPipeEntity> distributeNetwork(ServerLevel level, BlockPos pos, Set<NetworkedPipeEntity> visited, PipeNetwork network) {
        if (visited.contains((Object)this)) {
            return visited;
        }
        visited.add(this);
        for (Direction direction : this.networkDistances.keySet()) {
            BlockPos nextPos = (BlockPos)((Tuple)this.networkDistances.get(direction)).a();
            BlockEntity blockEntity = level.m_7702_(nextPos);
            if (!(blockEntity instanceof NetworkedPipeEntity)) continue;
            NetworkedPipeEntity nextPipe = (NetworkedPipeEntity)blockEntity;
            visited = nextPipe.distributeNetwork(level, nextPos, visited, network);
        }
        this.setController(pos.equals((Object)network.getPos()));
        this.setNetwork(network, level);
        return visited;
    }

    @Override
    protected List<Direction> getValidDirections(BlockState state, ItemInPipe item) {
        ArrayList<Direction> validDirections = new ArrayList<Direction>();
        Direction direction = MiscUtil.nextDirection(item.getFromDirection());
        for (int i = 0; i < 5; ++i) {
            if (((NetworkedPipeBlock.ConnectionState)((Object)state.m_61143_((Property)NetworkedPipeBlock.PROPERTY_BY_DIRECTION.get(direction)))).equals((Object)NetworkedPipeBlock.ConnectionState.LINKED)) {
                validDirections.add(direction);
            }
            direction = MiscUtil.nextDirection(direction);
        }
        if (validDirections.isEmpty()) {
            return super.getValidDirections(state, item);
        }
        return validDirections;
    }

    @Override
    public void routeItem(BlockState state, ItemInPipe item) {
        Level level;
        if (!this.hasNetwork()) {
            super.routeItem(state, item);
            return;
        }
        if (!this.checkRoutingSchedule(item) && (level = this.m_58904_()) instanceof ServerLevel) {
            Block block;
            ServerLevel serverLevel = (ServerLevel)level;
            ArrayList<Object> validTargets = new ArrayList<Object>();
            RequestedItem thisRequestedItem = null;
            ArrayList<ItemInPipe> spareItems = new ArrayList<ItemInPipe>();
            for (RequestedItem requestedItem : this.getNetwork().getRequestedItems()) {
                Object target;
                if (!requestedItem.matches(item) || this.m_58904_() == null || (target = requestedItem.getTarget(this.m_58904_())) == null) continue;
                if (item.getStack().m_41613_() > requestedItem.getAmountRemaining()) {
                    spareItems.add(item.copyWithCount(item.getStack().m_41613_() - requestedItem.getAmountRemaining()));
                    item.getStack().m_41764_(requestedItem.getAmountRemaining());
                }
                thisRequestedItem = requestedItem;
                validTargets.add(target);
                break;
            }
            if (validTargets.isEmpty()) {
                block1: for (StockingPipeEntity stockingPipeEntity : this.network.getStockingPipes()) {
                    for (ItemStack stack : stockingPipeEntity.getMissingItemsCache()) {
                        if (!stack.m_150930_(item.getStack().m_41720_()) || stockingPipeEntity.shouldMatchComponents() && !ItemStack.m_150942_((ItemStack)stack, (ItemStack)item.getStack())) continue;
                        int alreadyRequested = stockingPipeEntity.getAlreadyRequested(stack);
                        if (alreadyRequested >= stack.m_41613_()) continue block1;
                        int surplus = item.getStack().m_41613_() - stack.m_41613_() + alreadyRequested;
                        if (surplus > 0) {
                            spareItems.add(item.copyWithCount(surplus));
                            item.getStack().m_41764_(stack.m_41613_() - alreadyRequested);
                        }
                        validTargets.add((Object)stockingPipeEntity);
                        continue block1;
                    }
                }
            }
            if (validTargets.isEmpty()) {
                for (MatchingPipe matchingPipe : this.network.getMatchingPipes()) {
                    if (!matchingPipe.matches(item.getStack())) continue;
                    validTargets.add((Object)matchingPipe.getAsPipe());
                }
            }
            if (validTargets.isEmpty()) {
                HashMap matchPriority = new HashMap();
                matchPriority.put(Filter.MatchingResult.ITEM, new ArrayList());
                matchPriority.put(Filter.MatchingResult.TAG, new ArrayList());
                matchPriority.put(Filter.MatchingResult.MOD, new ArrayList());
                for (Object routingPipe : this.network.getRoutingPipes()) {
                    Filter.MatchingResult result = ((RoutingPipeEntity)((Object)routingPipe)).canRouteItemHere(item.getStack());
                    if (!result.matches) continue;
                    ((List)matchPriority.get((Object)result)).add(routingPipe);
                }
                if (!((List)matchPriority.get((Object)Filter.MatchingResult.ITEM)).isEmpty()) {
                    validTargets.addAll((Collection)matchPriority.get((Object)Filter.MatchingResult.ITEM));
                } else if (!((List)matchPriority.get((Object)Filter.MatchingResult.TAG)).isEmpty()) {
                    validTargets.addAll((Collection)matchPriority.get((Object)Filter.MatchingResult.TAG));
                } else if (!((List)matchPriority.get((Object)Filter.MatchingResult.MOD)).isEmpty()) {
                    validTargets.addAll((Collection)matchPriority.get((Object)Filter.MatchingResult.MOD));
                }
            }
            if (validTargets.isEmpty()) {
                validTargets.addAll(this.network.getDefaultRoutes());
            }
            if (validTargets.contains((Object)this) && (block = state.m_60734_()) instanceof NetworkedPipeBlock) {
                NetworkedPipeBlock networkedBlock = (NetworkedPipeBlock)block;
                ArrayList<Direction> arrayList = new ArrayList<Direction>();
                if (networkedBlock instanceof ContainerAdjacentNetworkedPipeBlock && state.m_61143_(ContainerAdjacentNetworkedPipeBlock.FACING) != FacingOrNone.NONE) {
                    arrayList.add(((FacingOrNone)((Object)state.m_61143_(ContainerAdjacentNetworkedPipeBlock.FACING))).getDirection());
                } else {
                    for (Direction direction : Direction.values()) {
                        if (!this.isPipeConnected(state, direction) || networkedBlock.isLinked(state, direction)) continue;
                        arrayList.add(direction);
                    }
                }
                if (arrayList.isEmpty() || this instanceof RecipePipeEntity) {
                    item.setEjecting(true);
                    item.setTargetDirection(item.getFromDirection().m_122424_());
                } else {
                    item.setEjecting(false);
                    item.setTargetDirection((Direction)arrayList.get(serverLevel.m_213780_().m_188503_(arrayList.size())));
                }
                if (thisRequestedItem != null) {
                    int remaining = thisRequestedItem.getAmountRemaining();
                    int leftover = item.getStack().m_41613_() - remaining;
                    thisRequestedItem.arrived(item.getStack().m_41613_());
                    if (thisRequestedItem.isDelivered()) {
                        this.getNetwork().removeRequestedItem(thisRequestedItem);
                    }
                    if (leftover > 0) {
                        item.setStack(item.getStack().m_255036_(remaining));
                        spareItems.add(item.copyWithCount(leftover));
                    }
                }
            } else if (!validTargets.isEmpty()) {
                this.schedulePath(serverLevel, item, (NetworkedPipeEntity)((Object)validTargets.get(serverLevel.m_213780_().m_188503_(validTargets.size()))));
                this.checkRoutingSchedule(item);
            } else {
                super.routeItem(state, item);
            }
            for (ItemInPipe itemInPipe : spareItems) {
                this.queued.add(itemInPipe);
                this.routeItem(state, itemInPipe);
            }
        }
    }

    private boolean checkRoutingSchedule(ItemInPipe item) {
        Iterator<ItemStack> iterator = this.routingSchedule.keySet().iterator();
        while (iterator.hasNext()) {
            ItemStack stack = iterator.next();
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)item.getStack()) || stack.m_41613_() != item.getStack().m_41613_()) continue;
            item.setEjecting(false);
            item.setTargetDirection(this.routingSchedule.get(stack).getDirection());
            iterator.remove();
            return true;
        }
        return false;
    }

    public void schedule(ItemStack stack, Direction direction) {
        this.routingSchedule.put(stack, new ScheduledRoute(direction));
    }

    public void schedulePath(ServerLevel level, ItemInPipe item, NetworkedPipeEntity target) {
        HashMap<NetworkedPipeEntity, Tuple<NetworkedPipeEntity, Direction>> cameFrom = new HashMap<NetworkedPipeEntity, Tuple<NetworkedPipeEntity, Direction>>();
        HashMap<NetworkedPipeEntity, Integer> gScore = new HashMap<NetworkedPipeEntity, Integer>();
        gScore.put(this, 0);
        HashMap<NetworkedPipeEntity, Integer> fScore = new HashMap<NetworkedPipeEntity, Integer>();
        fScore.put(this, 0);
        PriorityQueue<NetworkedPipeEntity> openSet = new PriorityQueue<NetworkedPipeEntity>(Comparator.comparingInt(fScore::get));
        openSet.add(this);
        while (!openSet.isEmpty()) {
            NetworkedPipeEntity current = openSet.poll();
            if (current == target) {
                while (cameFrom.containsKey((Object)current)) {
                    Tuple tuple = (Tuple)cameFrom.get((Object)current);
                    current = (NetworkedPipeEntity)((Object)tuple.a());
                    current.schedule(item.getStack(), (Direction)tuple.b());
                    current.m_6596_();
                    level.m_7260_(current.m_58899_(), current.m_58900_(), current.m_58900_(), 2);
                }
            }
            for (Direction side : current.networkDistances.keySet()) {
                Tuple tuple = (Tuple)current.networkDistances.get(side);
                BlockEntity blockEntity = level.m_7702_((BlockPos)tuple.a());
                if (!(blockEntity instanceof NetworkedPipeEntity)) continue;
                NetworkedPipeEntity neighbour = (NetworkedPipeEntity)blockEntity;
                int newScore = (Integer)gScore.get((Object)current) + (Integer)tuple.b();
                if (gScore.containsKey((Object)neighbour) && newScore >= (Integer)gScore.get((Object)neighbour)) continue;
                cameFrom.put(neighbour, new Tuple<NetworkedPipeEntity, Direction>(current, side));
                gScore.put(neighbour, newScore);
                fScore.put(neighbour, newScore + this.f_58858_.m_123333_((Vec3i)neighbour.f_58858_));
                if (openSet.contains((Object)neighbour)) continue;
                openSet.add(neighbour);
            }
        }
    }

    public void setNetwork(PipeNetwork network, ServerLevel level) {
        if (network != null) {
            network.addPipe(this);
        }
        this.network = network;
        this.m_6596_();
        if (level != null) {
            level.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public PipeNetwork getNetwork() {
        return this.network;
    }

    public boolean hasNetwork() {
        return this.network != null;
    }

    public void setController(boolean controller) {
        this.controller = controller;
    }

    public boolean isController() {
        return this.controller;
    }

    public void disconnect(ServerLevel level) {
        this.setController(false);
        this.routingSchedule.clear();
        if (this.hasNetwork()) {
            this.getNetwork().removePipe(level, this);
        }
        this.setNetwork(null, level);
    }

    public Tuple<Boolean, Set<NetworkedPipeEntity>> stillLinkedToNetwork(PipeNetwork network, ServerLevel level, BlockPos thisPos, Set<NetworkedPipeEntity> visited) {
        if (visited.contains((Object)this)) {
            return new Tuple<Boolean, Set<NetworkedPipeEntity>>(false, visited);
        }
        visited.add(this);
        if (network.getPos().equals((Object)thisPos)) {
            return new Tuple<Boolean, Set<NetworkedPipeEntity>>(true, visited);
        }
        for (Direction direction : this.networkDistances.keySet()) {
            BlockPos nextPos = (BlockPos)((Tuple)this.networkDistances.get(direction)).a();
            BlockEntity blockEntity = level.m_7702_(nextPos);
            if (!(blockEntity instanceof NetworkedPipeEntity)) continue;
            NetworkedPipeEntity nextPipe = (NetworkedPipeEntity)blockEntity;
            Tuple<Boolean, Set<NetworkedPipeEntity>> tuple = nextPipe.stillLinkedToNetwork(network, level, nextPos, visited);
            visited = tuple.b();
            if (!tuple.a().booleanValue()) continue;
            return tuple;
        }
        return new Tuple<Boolean, Set<NetworkedPipeEntity>>(false, visited);
    }

    public Tuple<PipeNetwork, Set<NetworkedPipeEntity>> findLinkedNetwork(ServerLevel level, BlockPos thisPos, Set<NetworkedPipeEntity> visited) {
        if (visited.contains((Object)this)) {
            return new Tuple<Object, Set<NetworkedPipeEntity>>(null, visited);
        }
        visited.add(this);
        if (this.hasNetwork() && this.getNetwork().getPos().equals((Object)thisPos)) {
            return new Tuple<PipeNetwork, Set<NetworkedPipeEntity>>(this.getNetwork(), visited);
        }
        for (Direction direction : this.networkDistances.keySet()) {
            BlockPos nextPos = (BlockPos)((Tuple)this.networkDistances.get(direction)).a();
            BlockEntity blockEntity = level.m_7702_(nextPos);
            if (!(blockEntity instanceof NetworkedPipeEntity)) continue;
            NetworkedPipeEntity nextPipe = (NetworkedPipeEntity)blockEntity;
            Tuple<PipeNetwork, Set<NetworkedPipeEntity>> tuple = nextPipe.findLinkedNetwork(level, nextPos, visited);
            visited = tuple.b();
            if (tuple.a() == null) continue;
            return tuple;
        }
        return new Tuple<Object, Set<NetworkedPipeEntity>>(null, visited);
    }

    public Set<NetworkedPipeEntity> disconnectAllLinked(ServerLevel level, Set<NetworkedPipeEntity> visited) {
        if (visited.contains((Object)this)) {
            return visited;
        }
        visited.add(this);
        this.disconnect(level);
        for (Direction direction : this.networkDistances.keySet()) {
            BlockPos nextPos = (BlockPos)((Tuple)this.networkDistances.get(direction)).a();
            BlockEntity blockEntity = level.m_7702_(nextPos);
            if (!(blockEntity instanceof NetworkedPipeEntity)) continue;
            NetworkedPipeEntity nextPipe = (NetworkedPipeEntity)blockEntity;
            visited = nextPipe.disconnectAllLinked(level, visited);
        }
        return visited;
    }

    public void networkChanged(ServerLevel level, BlockPos pos, boolean isLinked) {
        if (this.hasNetwork()) {
            if (!isLinked) {
                if (!this.stillLinkedToNetwork(this.getNetwork(), level, pos, new HashSet<NetworkedPipeEntity>()).a().booleanValue()) {
                    this.disconnectAllLinked(level, new HashSet<NetworkedPipeEntity>());
                    this.distributeNetwork(level, pos, new HashSet<NetworkedPipeEntity>(), new PipeNetwork(pos));
                }
            } else {
                this.distributeNetwork(level, pos, new HashSet<NetworkedPipeEntity>(), this.getNetwork());
            }
        } else {
            PipeNetwork network = this.findLinkedNetwork(level, pos, new HashSet<NetworkedPipeEntity>()).a();
            if (network != null) {
                this.setNetwork(network, level);
                this.setController(network.getPos().equals((Object)pos));
            } else {
                this.distributeNetwork(level, pos, new HashSet<NetworkedPipeEntity>(), new PipeNetwork(pos));
            }
        }
    }

    public void m_7651_() {
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.disconnect(serverLevel);
        }
        super.m_7651_();
    }

    @Override
    public short getTargetSpeed() {
        return 1024;
    }

    @Override
    public short getAcceleration() {
        return 64;
    }

    public boolean isDefaultRoute() {
        return false;
    }

    @Override
    public void m_142466_(CompoundTag valueInput) {
        super.m_142466_(valueInput);
        this.routingSchedule.clear();
        this.setController(valueInput.m_128471_("controller"));
        this.syncedNetworkPos = this.m_58899_();
        if (this.isController()) {
            this.network = new PipeNetwork(this.m_58899_(), SortingMode.fromByte(valueInput.m_128445_("sorting_mode")));
            ListTag requestedItems = valueInput.m_128437_("requested_items", 10);
            requestedItems.forEach(tag -> MiscUtil.loadFromTag(tag, RequestedItem.CODEC, this.network::addRequestedItem));
            this.syncedNetworkPos = this.m_58899_();
        } else {
            MiscUtil.loadFromTag(valueInput.m_128423_("synced_network_pos"), BlockPos.f_121852_, pos -> {
                this.syncedNetworkPos = pos;
            });
        }
        ListTag routingList = valueInput.m_128437_("routing_schedule", 10);
        routingList.forEach(tag -> {
            if (tag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)tag;
                int slot = compoundTag.m_128451_("slot");
                MiscUtil.loadFromTag(tag, ItemStack.f_41582_, stack -> this.routingSchedule.put((ItemStack)stack, new ScheduledRoute(Direction.m_122376_((int)slot))));
            }
        });
    }

    @Override
    protected void m_183515_(CompoundTag valueOutput) {
        super.m_183515_(valueOutput);
        valueOutput.m_128379_("controller", this.isController());
        if (this.hasNetwork() && this.isController()) {
            valueOutput.m_128344_("sorting_mode", this.getNetwork().getSortingMode().getValue());
            ListTag requestedItems = new ListTag();
            for (RequestedItem requestedItem : this.getNetwork().getRequestedItems()) {
                if (requestedItem.isDelivered()) continue;
                MiscUtil.saveToTag(requestedItem, RequestedItem.CODEC, arg_0 -> requestedItems.add(arg_0));
            }
            valueOutput.m_128365_("requested_items", (Tag)requestedItems);
        }
        MiscUtil.saveToTag(this.hasNetwork() ? this.network.getPos() : this.m_58899_(), BlockPos.f_121852_, tag -> valueOutput.m_128365_("synced_network_pos", tag));
        ListTag routingList = new ListTag();
        for (ItemStack stack : this.routingSchedule.keySet()) {
            CompoundTag tag2 = new CompoundTag();
            tag2.m_128405_("slot", this.routingSchedule.get(stack).getDirection().m_122411_());
            MiscUtil.saveToTag((Tag)tag2, stack, ItemStack.f_41582_, arg_0 -> routingList.add(arg_0));
        }
        valueOutput.m_128365_("routing_schedule", (Tag)routingList);
    }
}

