/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.blockentity.FluidPipeEntity;
import jagm.classicpipes.util.FluidInPipe;
import java.util.ListIterator;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.state.BlockState;

public class ObsidianFluidPipeEntity
extends FluidPipeEntity {
    private static final int MIN_GURGLE_DELAY = 80;
    private static final int MAX_GURGLE_DELAY = 160;
    private long lastGurgle = 0L;

    public ObsidianFluidPipeEntity(BlockPos pos, BlockState state) {
        super(ClassicPipes.OBSIDIAN_FLUID_PIPE_ENTITY, pos, state);
    }

    @Override
    public void tickServer(ServerLevel level, BlockPos pos, BlockState state) {
        super.tickServer(level, pos, state);
        if (!this.isEmpty()) {
            boolean sendBlockUpdate = false;
            ListIterator iterator = this.contents.listIterator();
            while (iterator.hasNext()) {
                FluidInPipe fluidPacket = (FluidInPipe)iterator.next();
                if (fluidPacket.getProgress() < 1024) continue;
                iterator.remove();
                sendBlockUpdate = true;
                long timeSinceLastGurgle = level.m_46467_() - this.lastGurgle;
                if (timeSinceLastGurgle <= 160L && (timeSinceLastGurgle <= 80L || level.m_213780_().m_188503_(10) != 0)) continue;
                level.m_247517_(null, pos, ClassicPipes.OBSIDIAN_FLUID_PIPE_GURGLE, SoundSource.BLOCKS);
                this.lastGurgle = level.m_46467_();
            }
            if (sendBlockUpdate) {
                level.m_7260_(pos, state, state, 2);
            }
        }
    }

    @Override
    public void routePacket(BlockState state, FluidInPipe fluidPacket) {
        fluidPacket.setTargetDirection(fluidPacket.getFromDirection());
    }
}

