/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import jagm.classicpipes.blockentity.ItemPipeEntity;
import jagm.classicpipes.util.ItemInPipe;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.phys.Vec3;

public class PipeRenderer
implements BlockEntityRenderer<ItemPipeEntity> {
    private final BlockEntityRendererProvider.Context context;

    public PipeRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(ItemPipeEntity pipe, float partialTicks, PoseStack poses, MultiBufferSource bufferSource, int light, int overlay) {
        PipeRenderer.renderPipeItems(this.context, pipe, partialTicks, poses, bufferSource, light, overlay);
    }

    public static void renderPipeItems(BlockEntityRendererProvider.Context context, ItemPipeEntity pipe, float partialTicks, PoseStack poses, MultiBufferSource bufferSource, int light, int overlay) {
        if (!pipe.isEmpty()) {
            for (ItemInPipe item : pipe.getContents()) {
                Direction direction = item.getProgress() < 1024 ? item.getFromDirection() : item.getTargetDirection();
                poses.m_85836_();
                Vec3 renderPos = item.getRenderPosition(partialTicks);
                poses.m_85837_(renderPos.f_82479_, renderPos.f_82480_, renderPos.f_82481_);
                poses.m_85841_(0.4375f, 0.4375f, 0.4375f);
                if (direction.equals((Object)Direction.EAST) || direction.equals((Object)Direction.WEST)) {
                    poses.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                } else if (direction.equals((Object)Direction.UP) || direction.equals((Object)Direction.DOWN)) {
                    poses.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                }
                context.m_234447_().m_269128_(item.getStack(), ItemDisplayContext.FIXED, light, overlay, poses, bufferSource, pipe.m_58904_(), 0);
                poses.m_85849_();
            }
        }
    }
}

