/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.inventory.menu;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.blockentity.PipeEntity;
import jagm.classicpipes.blockentity.RecipePipeEntity;
import jagm.classicpipes.inventory.container.FilterContainer;
import jagm.classicpipes.inventory.menu.FilterMenu;
import jagm.classicpipes.inventory.menu.FilterSlot;
import jagm.classicpipes.network.ClientBoundRecipePipePayload;
import jagm.classicpipes.util.MiscUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class RecipePipeMenu
extends FilterMenu {
    private final Direction[] ioDirections;
    private final List<Direction> availableDirections;
    private final BlockPos pos;
    private boolean blockingMode;

    public RecipePipeMenu(int id, Inventory playerInventory, ClientBoundRecipePipePayload payload) {
        this(id, playerInventory, new FilterContainer(null, 10, true), payload.slotDirections(), payload.availableDirections(), payload.pos(), payload.blockingMode());
    }

    public RecipePipeMenu(int id, Inventory playerInventory, FilterContainer filter, Direction[] ioDirections, List<Direction> availableDirections, BlockPos pos, boolean blockingMode) {
        super(ClassicPipes.RECIPE_PIPE_MENU, id, filter);
        int i;
        this.ioDirections = ioDirections;
        this.availableDirections = availableDirections;
        this.pos = pos;
        this.blockingMode = blockingMode;
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int j = 0; j < 3; ++j) {
                this.m_38897_(new FilterSlot(filter, j + i2 * 3, 53 + j * 18, 17 + i2 * 18));
            }
        }
        this.m_38897_(new FilterSlot(filter, 9, 125, 35));
        int x = 8;
        int y = 107;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, x + j * 18, y + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, x + i * 18, y + 58));
        }
    }

    public void setSlotDirection(int slot, Direction direction) {
        this.ioDirections[slot] = direction;
    }

    public Direction getSlotDirection(int slot) {
        return this.ioDirections[slot];
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public boolean slotHasItem(int slot) {
        return this.m_38853_(slot).m_6657_();
    }

    public Direction nextDirection(Direction direction) {
        if (this.hasAvailableDirections()) {
            for (int i = 0; i < 6; ++i) {
                if (!this.availableDirections.contains(direction = MiscUtil.nextDirection(direction))) continue;
                return direction;
            }
        }
        return direction;
    }

    public Direction prevDirection(Direction direction) {
        if (this.hasAvailableDirections()) {
            for (int i = 0; i < 6; ++i) {
                if (!this.availableDirections.contains(direction = MiscUtil.prevDirection(direction))) continue;
                return direction;
            }
        }
        return direction;
    }

    public boolean hasAvailableDirections() {
        return !this.availableDirections.isEmpty();
    }

    @Override
    public void m_150399_(int index, int button, ClickType clickType, Player player) {
        if (index >= this.getFilter().m_6643_() || index < 0 || clickType.equals((Object)ClickType.CLONE)) {
            super.m_150399_(index, button, clickType, player);
        } else {
            Slot slot = (Slot)this.f_38839_.get(index);
            ItemStack stack = slot.m_7993_();
            if (clickType == ClickType.QUICK_MOVE) {
                slot.m_5852_(ItemStack.f_41583_);
            } else if (clickType == ClickType.PICKUP) {
                if (stack.m_41619_()) {
                    slot.m_5852_(this.m_142621_().m_255036_(button == 0 ? this.m_142621_().m_41613_() : 1));
                } else {
                    if (this.m_142621_().m_41619_()) {
                        stack.m_41769_(button == 0 ? -1 : 1);
                        if (stack.m_41619_()) {
                            slot.m_5852_(ItemStack.f_41583_);
                        }
                    } else if (ItemStack.m_150942_((ItemStack)stack, (ItemStack)this.m_142621_())) {
                        stack.m_41769_(1);
                    } else {
                        slot.m_5852_(this.m_142621_().m_255036_(1));
                    }
                    if (stack.m_41613_() > 999) {
                        stack.m_41764_(999);
                    }
                }
            }
            slot.m_6654_();
        }
    }

    public boolean isBlockingMode() {
        return this.blockingMode;
    }

    public void setBlockingMode(boolean blockingMode) {
        this.blockingMode = blockingMode;
        PipeEntity pipeEntity = this.getFilter().getPipe();
        if (pipeEntity instanceof RecipePipeEntity) {
            RecipePipeEntity recipePipe = (RecipePipeEntity)pipeEntity;
            recipePipe.setBlockingMode(blockingMode);
        }
    }
}

