/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.network;

import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.network.PayloadWrapper;
import jagm.classicpipes.network.SelfHandler;
import jagm.classicpipes.util.MiscUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public record ServerBoundRequestPayload(ItemStack stack, BlockPos requestPos) implements PayloadWrapper<ServerBoundRequestPayload>
{
    public static final ResourceLocation TYPE = MiscUtil.resourceLocation("request");
    public static final SelfHandler<ServerBoundRequestPayload> HANDLER = new Handler();

    @Override
    public SelfHandler<ServerBoundRequestPayload> getHandler() {
        return HANDLER;
    }

    @Override
    public ResourceLocation getType() {
        return TYPE;
    }

    private static class Handler
    extends SelfHandler<ServerBoundRequestPayload> {
        private Handler() {
        }

        @Override
        public FriendlyByteBuf encode(ServerBoundRequestPayload payload, FriendlyByteBuf buffer) {
            MiscUtil.writeStackToBuffer(buffer, payload.stack());
            buffer.m_130064_(payload.requestPos());
            return buffer;
        }

        @Override
        public ServerBoundRequestPayload decode(FriendlyByteBuf buffer) {
            ItemStack stack = MiscUtil.readStackFromBuffer(buffer);
            BlockPos requestPos = buffer.m_130135_();
            return new ServerBoundRequestPayload(stack, requestPos);
        }

        @Override
        public void handle(ServerBoundRequestPayload payload, Player player) {
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                NetworkedPipeEntity pipe;
                ServerLevel serverLevel = (ServerLevel)level;
                level = player.m_9236_().m_7702_(payload.requestPos());
                if (level instanceof NetworkedPipeEntity && (pipe = (NetworkedPipeEntity)level).hasNetwork()) {
                    pipe.getNetwork().request(serverLevel, payload.stack(), payload.requestPos(), player, false);
                }
            }
        }
    }
}

