/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.network;

import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.inventory.menu.RequestMenu;
import jagm.classicpipes.network.PayloadWrapper;
import jagm.classicpipes.network.SelfHandler;
import jagm.classicpipes.util.MiscUtil;
import jagm.classicpipes.util.SortingMode;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;

public record ServerBoundSortingModePayload(SortingMode sortingMode) implements PayloadWrapper<ServerBoundSortingModePayload>
{
    public static final ResourceLocation TYPE = MiscUtil.resourceLocation("sorting_mode");
    public static final SelfHandler<ServerBoundSortingModePayload> HANDLER = new Handler();

    @Override
    public SelfHandler<ServerBoundSortingModePayload> getHandler() {
        return HANDLER;
    }

    @Override
    public ResourceLocation getType() {
        return TYPE;
    }

    private static class Handler
    extends SelfHandler<ServerBoundSortingModePayload> {
        private Handler() {
        }

        @Override
        public FriendlyByteBuf encode(ServerBoundSortingModePayload payload, FriendlyByteBuf buffer) {
            buffer.writeByte((int)payload.sortingMode().getValue());
            return buffer;
        }

        @Override
        public ServerBoundSortingModePayload decode(FriendlyByteBuf buffer) {
            return new ServerBoundSortingModePayload(SortingMode.fromByte(buffer.readByte()));
        }

        @Override
        public void handle(ServerBoundSortingModePayload payload, Player player) {
            AbstractContainerMenu abstractContainerMenu;
            if (player != null && (abstractContainerMenu = player.f_36096_) instanceof RequestMenu) {
                NetworkedPipeEntity pipe;
                ServerLevel serverLevel;
                RequestMenu menu = (RequestMenu)abstractContainerMenu;
                Level level = player.m_9236_();
                if (level instanceof ServerLevel && (level = (serverLevel = (ServerLevel)level).m_7702_(menu.getNetworkPos())) instanceof NetworkedPipeEntity && (pipe = (NetworkedPipeEntity)level).hasNetwork()) {
                    pipe.getNetwork().setSortingMode(payload.sortingMode());
                    pipe.m_6596_();
                }
            }
        }
    }
}

