/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.util.UUIDTypeAdapter;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.api.ChunkTeamData;
import dev.ftb.mods.ftbchunks.api.ClaimResult;
import dev.ftb.mods.ftbchunks.api.ClaimedChunk;
import dev.ftb.mods.ftbchunks.data.ChunkTeamDataImpl;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkImpl;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManagerImpl;
import dev.ftb.mods.ftbchunks.net.AddWaypointPacket;
import dev.ftb.mods.ftbchunks.net.LoadedChunkViewPacket;
import dev.ftb.mods.ftbchunks.net.RequestBlockColorPacket;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import dev.ftb.mods.ftbteams.data.TeamArgumentProvider;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntMaps;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.UUID;
import java.util.function.ToIntBiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ColorArgument;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FTBChunksCommands {
    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext registry, Commands.CommandSelection selection) {
        LiteralCommandNode command = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ftbchunks").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"claim").executes(context -> FTBChunksCommands.claim((CommandSourceStack)context.getSource(), FTBChunksCommands.selfTeam((CommandSourceStack)context.getSource()), 0))).then(FTBChunksCommands.radiusArg().executes(context -> FTBChunksCommands.claim((CommandSourceStack)context.getSource(), FTBChunksCommands.selfTeam((CommandSourceStack)context.getSource()), FTBChunksCommands.getRadiusArg((CommandContext<CommandSourceStack>)context)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"unclaim").executes(context -> FTBChunksCommands.unclaim((CommandSourceStack)context.getSource(), FTBChunksCommands.selfTeam((CommandSourceStack)context.getSource()), 0))).then(FTBChunksCommands.radiusArg().executes(context -> FTBChunksCommands.unclaim((CommandSourceStack)context.getSource(), FTBChunksCommands.selfTeam((CommandSourceStack)context.getSource()), FTBChunksCommands.getRadiusArg((CommandContext<CommandSourceStack>)context)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"load").executes(context -> FTBChunksCommands.load((CommandSourceStack)context.getSource(), 0))).then(FTBChunksCommands.radiusArg().executes(context -> FTBChunksCommands.load((CommandSourceStack)context.getSource(), FTBChunksCommands.getRadiusArg((CommandContext<CommandSourceStack>)context)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"unload").executes(context -> FTBChunksCommands.unload((CommandSourceStack)context.getSource(), 0))).then(FTBChunksCommands.radiusArg().executes(context -> FTBChunksCommands.unload((CommandSourceStack)context.getSource(), FTBChunksCommands.getRadiusArg((CommandContext<CommandSourceStack>)context)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"unclaim_all").executes(context -> FTBChunksCommands.unclaimAll((CommandSourceStack)context.getSource(), FTBChunksCommands.selfTeam((CommandSourceStack)context.getSource())))).then(FTBChunksCommands.forTeam(FTBChunksCommands::unclaimAll)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"unload_all").executes(context -> FTBChunksCommands.unloadAll((CommandSourceStack)context.getSource(), FTBChunksCommands.selfTeam((CommandSourceStack)context.getSource())))).then(FTBChunksCommands.forTeam(FTBChunksCommands::unloadAll)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"info").executes(context -> FTBChunksCommands.info((CommandSourceStack)context.getSource(), new ChunkDimPos((Level)((CommandSourceStack)context.getSource()).m_81372_(), BlockPos.m_274446_((Position)((CommandSourceStack)context.getSource()).m_81371_()))))).then(Commands.m_82129_((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"z", (ArgumentType)IntegerArgumentType.integer()).executes(context -> FTBChunksCommands.info((CommandSourceStack)context.getSource(), new ChunkDimPos((Level)((CommandSourceStack)context.getSource()).m_81372_(), new BlockPos(IntegerArgumentType.getInteger((CommandContext)context, (String)"x"), 0, IntegerArgumentType.getInteger((CommandContext)context, (String)"z")))))).then(FTBChunksCommands.dimArg().executes(context -> FTBChunksCommands.info((CommandSourceStack)context.getSource(), new ChunkDimPos(FTBChunksCommands.getDimArg((CommandContext<CommandSourceStack>)context).m_46472_(), IntegerArgumentType.getInteger((CommandContext)context, (String)"x") >> 4, IntegerArgumentType.getInteger((CommandContext)context, (String)"z") >> 4)))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"admin").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"bypass_protection").executes(context -> FTBChunksCommands.bypassProtection((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"extra_claim_chunks").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82127_((String)"get").executes(context -> FTBChunksCommands.getExtraClaimChunks((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"number", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> FTBChunksCommands.setExtraClaimChunks((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"number"), false))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"number", (ArgumentType)IntegerArgumentType.integer()).executes(context -> FTBChunksCommands.setExtraClaimChunks((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"number"), true))))))).then(Commands.m_82127_((String)"extra_force_load_chunks").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82127_((String)"get").executes(context -> FTBChunksCommands.getExtraForceLoadChunks((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"number", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> FTBChunksCommands.setExtraForceLoadChunks((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"number"), false))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"number", (ArgumentType)IntegerArgumentType.integer()).executes(context -> FTBChunksCommands.setExtraForceLoadChunks((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"number"), true))))))).then(Commands.m_82127_((String)"claim_as").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"team", (ArgumentType)TeamArgument.create()).executes(context -> FTBChunksCommands.claim((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team"), 0))).then(((RequiredArgumentBuilder)FTBChunksCommands.radiusArg().executes(context -> FTBChunksCommands.claim((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team"), FTBChunksCommands.getRadiusArg((CommandContext<CommandSourceStack>)context)))).then(((RequiredArgumentBuilder)FTBChunksCommands.anchorArg().executes(context -> FTBChunksCommands.claim((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team"), FTBChunksCommands.getRadiusArg((CommandContext<CommandSourceStack>)context), FTBChunksCommands.getAnchorArg((CommandContext<CommandSourceStack>)context), (Level)((CommandSourceStack)context.getSource()).m_81372_()))).then(FTBChunksCommands.dimArg().executes(context -> FTBChunksCommands.claim((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team"), FTBChunksCommands.getRadiusArg((CommandContext<CommandSourceStack>)context), FTBChunksCommands.getAnchorArg((CommandContext<CommandSourceStack>)context), (Level)FTBChunksCommands.getDimArg((CommandContext<CommandSourceStack>)context))))))))).then(Commands.m_82127_((String)"unclaim_as").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"team", (ArgumentType)TeamArgument.create()).executes(context -> FTBChunksCommands.unclaim((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team"), 0))).then(((RequiredArgumentBuilder)FTBChunksCommands.radiusArg().executes(context -> FTBChunksCommands.unclaim((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team"), FTBChunksCommands.getRadiusArg((CommandContext<CommandSourceStack>)context)))).then(((RequiredArgumentBuilder)FTBChunksCommands.anchorArg().executes(context -> FTBChunksCommands.unclaim((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team"), FTBChunksCommands.getRadiusArg((CommandContext<CommandSourceStack>)context), FTBChunksCommands.getAnchorArg((CommandContext<CommandSourceStack>)context), (Level)((CommandSourceStack)context.getSource()).m_81372_()))).then(FTBChunksCommands.dimArg().executes(context -> FTBChunksCommands.unclaim((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team"), FTBChunksCommands.getRadiusArg((CommandContext<CommandSourceStack>)context), FTBChunksCommands.getAnchorArg((CommandContext<CommandSourceStack>)context), (Level)FTBChunksCommands.getDimArg((CommandContext<CommandSourceStack>)context))))))))).then(Commands.m_82127_((String)"unclaim_everything").executes(context -> FTBChunksCommands.unclaimEverything((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"unload_everything").executes(context -> FTBChunksCommands.unloadEverything((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"view_loaded_chunks").executes(context -> FTBChunksCommands.viewLoadedChunks((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81372_()))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").executes(context -> FTBChunksCommands.resetLoadedChunks((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81372_()))).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(context -> FTBChunksCommands.resetLoadedChunks((CommandSourceStack)context.getSource(), DimensionArgument.m_88808_((CommandContext)context, (String)"dimension")))))).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(context -> FTBChunksCommands.viewLoadedChunks((CommandSourceStack)context.getSource(), DimensionArgument.m_88808_((CommandContext)context, (String)"dimension"))))))).then(Commands.m_82127_((String)"block_color").executes(context -> {
            new RequestBlockColorPacket().sendTo(((CommandSourceStack)context.getSource()).m_81375_());
            return 1;
        }))).then(Commands.m_82127_((String)"waypoint").then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"position", (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> FTBChunksCommands.addWaypoint((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), BlockPosArgument.m_118242_((CommandContext)context, (String)"position")))).then(Commands.m_82129_((String)"color", (ArgumentType)ColorArgument.m_85463_()).executes(context -> FTBChunksCommands.addWaypoint((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), BlockPosArgument.m_118242_((CommandContext)context, (String)"position"), ColorArgument.m_85466_((CommandContext)context, (String)"color")))))))));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"chunks").redirect((CommandNode)command));
    }

    private static int addWaypoint(CommandSourceStack source, String name, BlockPos position, ChatFormatting color) throws CommandSyntaxException {
        if (color.m_126665_() != null) {
            ServerPlayer player = source.m_81375_();
            new AddWaypointPacket(name, position, color.m_126665_()).sendTo(player);
        }
        return 1;
    }

    private static int addWaypoint(CommandSourceStack source, String name, BlockPos position) throws CommandSyntaxException {
        int idx = source.m_81375_().m_217043_().m_188503_(ChatFormatting.values().length);
        return FTBChunksCommands.addWaypoint(source, name, position, ChatFormatting.values()[idx]);
    }

    private static int bypassProtection(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        ClaimedChunkManagerImpl manager = FTBChunksCommands.claimManager();
        manager.setBypassProtection(player.m_20148_(), !manager.getBypassProtection(player.m_20148_()));
        source.m_288197_(() -> Component.m_237113_((String)("bypass_protection = " + manager.getBypassProtection(player.m_20148_()))), true);
        return 1;
    }

    private static void forEachChunk(CommandSourceStack source, int r, ChunkCallback callback) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        Team team = (Team)FTBTeamsAPI.api().getManager().getTeamForPlayer(player).orElseThrow(() -> TeamArgument.TEAM_NOT_FOUND.create((Object)player.m_19879_()));
        FTBChunksCommands.forEachChunk(team, (Level)source.m_81372_(), FTBChunksCommands.toColumn(source.m_81371_()), r, callback);
    }

    private static void forEachChunk(Team team, Level level, ColumnPos anchor, int r, ChunkCallback callback) throws CommandSyntaxException {
        ChunkTeamDataImpl data = FTBChunksCommands.claimManager().getOrCreateData(team);
        ResourceKey dimId = level.m_46472_();
        int ox = Mth.m_14143_((float)anchor.f_140723_()) >> 4;
        int oz = Mth.m_14143_((float)anchor.f_140724_()) >> 4;
        ArrayList<ChunkDimPos> list = new ArrayList<ChunkDimPos>();
        for (int z = -(r >>= 4); z <= r; ++z) {
            for (int x = -r; x <= r; ++x) {
                list.add(new ChunkDimPos(dimId, ox + x, oz + z));
            }
        }
        list.sort(Comparator.comparingDouble(cdp -> MathUtils.distSq((double)ox, (double)oz, (double)cdp.x(), (double)cdp.z())));
        for (ChunkDimPos pos : list) {
            callback.accept(data, pos);
        }
    }

    private static int claim(CommandSourceStack source, Team team, int r) throws CommandSyntaxException {
        return FTBChunksCommands.claim(source, team, r, FTBChunksCommands.toColumn(source.m_81371_()), (Level)source.m_81372_());
    }

    private static int claim(CommandSourceStack source, Team team, int r, ColumnPos anchor, Level level) throws CommandSyntaxException {
        int[] success = new int[1];
        FTBChunksCommands.forEachChunk(team, level, anchor, r, (data, pos) -> {
            if (data.claim(source, pos, false).isSuccess()) {
                success[0] = success[0] + 1;
            }
        });
        source.m_288197_(() -> Component.m_237113_((String)("Claimed " + success[0] + " chunks!")), false);
        ChunkDimPos origin = new ChunkDimPos(level.m_46472_(), anchor.f_140723_() >> 4, anchor.f_140724_() >> 4);
        FTBChunks.LOGGER.info(source.m_81368_() + " claimed " + success[0] + " chunks around " + origin + "for team " + team.getShortName());
        return success[0];
    }

    private static int unclaim(CommandSourceStack source, Team team, int r) throws CommandSyntaxException {
        return FTBChunksCommands.unclaim(source, team, r, FTBChunksCommands.toColumn(source.m_81371_()), (Level)source.m_81372_());
    }

    private static int unclaim(CommandSourceStack source, Team team, int r, ColumnPos anchor, Level level) throws CommandSyntaxException {
        int[] success = new int[1];
        FTBChunksCommands.forEachChunk(team, level, anchor, r, (data, pos) -> {
            if (data.unclaim(source, pos, false).isSuccess()) {
                success[0] = success[0] + 1;
            }
        });
        source.m_288197_(() -> Component.m_237113_((String)("Unclaimed " + success[0] + " chunks!")), false);
        ChunkDimPos origin = new ChunkDimPos(level.m_46472_(), anchor.f_140723_() >> 4, anchor.f_140724_() >> 4);
        FTBChunks.LOGGER.info(source.m_81368_() + " unclaimed " + success[0] + " chunks around " + origin + "for team " + team.getShortName());
        return success[0];
    }

    private static int load(CommandSourceStack source, int r) throws CommandSyntaxException {
        int[] success = new int[1];
        FTBChunksCommands.forEachChunk(source, r, (data, pos) -> {
            ClaimResult result = data.forceLoad(source, pos, false);
            if (result.isSuccess()) {
                success[0] = success[0] + 1;
            }
        });
        source.m_288197_(() -> Component.m_237113_((String)("Loaded " + success[0] + " chunks!")), false);
        FTBChunks.LOGGER.info(source.m_81368_() + " loaded " + success[0] + " chunks at " + new ChunkDimPos((Entity)source.m_81375_()));
        return success[0];
    }

    private static int unload(CommandSourceStack source, int r) throws CommandSyntaxException {
        int[] success = new int[1];
        FTBChunksCommands.forEachChunk(source, r, (data, pos) -> {
            if (data.unForceLoad(source, pos, false).isSuccess()) {
                success[0] = success[0] + 1;
            }
        });
        source.m_288197_(() -> Component.m_237113_((String)("Unloaded " + success[0] + " chunks!")), false);
        FTBChunks.LOGGER.info(source.m_81368_() + " unloaded " + success[0] + " chunks at " + new ChunkDimPos((Entity)source.m_81375_()));
        return success[0];
    }

    private static int unclaimAll(CommandSourceStack source, Team team) {
        ChunkTeamDataImpl data = FTBChunksCommands.claimManager().getOrCreateData(team);
        for (ClaimedChunkImpl c : new ArrayList<ClaimedChunkImpl>(data.getClaimedChunks())) {
            data.unclaim(source, c.getPos(), false);
        }
        data.markDirty();
        return 1;
    }

    private static int unloadAll(CommandSourceStack source, Team team) {
        ChunkTeamDataImpl data = FTBChunksCommands.claimManager().getOrCreateData(team);
        for (ClaimedChunk claimedChunk : new ArrayList<ClaimedChunkImpl>(data.getClaimedChunks())) {
            data.unForceLoad(source, claimedChunk.getPos(), false);
        }
        data.markDirty();
        return 1;
    }

    private static int info(CommandSourceStack source, ChunkDimPos pos) {
        source.m_288197_(() -> Component.m_237113_((String)("Location: " + pos)), true);
        ClaimedChunkImpl chunk = FTBChunksCommands.claimManager().getChunk(pos);
        if (chunk == null) {
            source.m_288197_(() -> Component.m_237113_((String)"Chunk not claimed!"), true);
            return 0;
        }
        source.m_288197_(() -> Component.m_237113_((String)"Owner: ").m_7220_(chunk.getTeamData().getTeam().getColoredName()).m_130946_(" / " + UUIDTypeAdapter.fromUUID((UUID)chunk.getTeamData().getTeam().getId())), true);
        if (source.m_6761_(2)) {
            source.m_288197_(() -> Component.m_237113_((String)("Force Loaded: " + chunk.isForceLoaded())), true);
        }
        return 1;
    }

    private static int getExtraClaimChunks(CommandSourceStack source, ServerPlayer player) {
        ChunkTeamDataImpl personalData = FTBChunksCommands.claimManager().getPersonalData(player.m_20148_());
        if (personalData == null) {
            source.m_81352_((Component)Component.m_237113_((String)"can't get personal team data for ").m_7220_(player.m_5446_()));
            return 0;
        }
        source.m_288197_(() -> player.m_5446_().m_6881_().m_130946_("/extra_claim_chunks = " + personalData.getExtraClaimChunks()), false);
        return 1;
    }

    private static int setExtraClaimChunks(CommandSourceStack source, ServerPlayer player, int extra, boolean adding) {
        ChunkTeamDataImpl personalData = FTBChunksCommands.claimManager().getPersonalData(player.m_20148_());
        if (personalData == null) {
            source.m_81352_((Component)Component.m_237113_((String)"can't get personal team data for ").m_7220_(player.m_5446_()));
            return 0;
        }
        personalData.setExtraClaimChunks(Math.max(0, extra + (adding ? personalData.getExtraClaimChunks() : 0)));
        personalData.markDirty();
        ChunkTeamDataImpl teamData = FTBChunksCommands.claimManager().getOrCreateData(player);
        teamData.updateLimits();
        SendGeneralDataPacket.send((ChunkTeamData)teamData, player);
        source.m_288197_(() -> player.m_5446_().m_6881_().m_130946_("/extra_claim_chunks = " + personalData.getExtraClaimChunks()), false);
        return 1;
    }

    private static int getExtraForceLoadChunks(CommandSourceStack source, ServerPlayer player) {
        ChunkTeamDataImpl personalData = FTBChunksCommands.claimManager().getPersonalData(player.m_20148_());
        if (personalData == null) {
            source.m_81352_((Component)Component.m_237113_((String)"can't get personal team data for ").m_7220_(player.m_5446_()));
            return 0;
        }
        source.m_288197_(() -> player.m_5446_().m_6881_().m_130946_("/extra_force_load_chunks = " + personalData.getExtraForceLoadChunks()), false);
        return 1;
    }

    private static int setExtraForceLoadChunks(CommandSourceStack source, ServerPlayer player, int extra, boolean adding) {
        ChunkTeamDataImpl personalData = FTBChunksCommands.claimManager().getPersonalData(player.m_20148_());
        if (personalData == null) {
            source.m_81352_((Component)Component.m_237113_((String)"can't get personal team data for ").m_7220_(player.m_5446_()));
            return 0;
        }
        personalData.setExtraForceLoadChunks(Math.max(0, extra + (adding ? personalData.getExtraForceLoadChunks() : 0)));
        personalData.markDirty();
        ChunkTeamDataImpl teamData = FTBChunksCommands.claimManager().getOrCreateData(player);
        teamData.updateLimits();
        SendGeneralDataPacket.send((ChunkTeamData)teamData, player);
        source.m_288197_(() -> player.m_5446_().m_6881_().m_130946_("/extra_force_load_chunks = " + personalData.getExtraForceLoadChunks()), false);
        return 1;
    }

    private static int unclaimEverything(CommandSourceStack source) {
        for (ClaimedChunkImpl c : new ArrayList<ClaimedChunkImpl>(FTBChunksCommands.claimManager().getAllClaimedChunks())) {
            c.getTeamData().unclaim(source, c.getPos(), false);
            c.getTeamData().markDirty();
        }
        return 1;
    }

    private static int unloadEverything(CommandSourceStack source) {
        for (ClaimedChunkImpl c : new ArrayList<ClaimedChunkImpl>(FTBChunksCommands.claimManager().getAllClaimedChunks())) {
            c.getTeamData().unForceLoad(source, c.getPos(), false);
            c.getTeamData().markDirty();
        }
        return 1;
    }

    private static int viewLoadedChunks(CommandSourceStack source, ServerLevel level) throws CommandSyntaxException {
        long pos;
        Long2IntOpenHashMap chunks = new Long2IntOpenHashMap();
        for (ChunkHolder holder : level.m_7726_().f_8325_.f_140129_.values()) {
            chunks.put(holder.m_140092_().m_45588_(), 1);
        }
        Long2ObjectMap<UUID> map = FTBChunksCommands.claimManager().getForceLoadedChunks((ResourceKey<Level>)level.m_46472_());
        LongIterator longIterator = map.keySet().iterator();
        while (longIterator.hasNext()) {
            pos = (Long)longIterator.next();
            if (chunks.get(pos) != 1) continue;
            chunks.put(pos, 2);
        }
        longIterator = level.m_8902_().iterator();
        while (longIterator.hasNext()) {
            pos = (Long)longIterator.next();
            if (chunks.get(pos) != 1) continue;
            chunks.put(pos, 2);
        }
        source.m_288197_(() -> Component.m_237113_((String)String.format("Chunks Loaded: %d. Check the map to see loaded chunks", chunks.size())), false);
        new LoadedChunkViewPacket((ResourceKey<Level>)level.m_46472_(), (Long2IntMap)chunks).sendTo(source.m_81375_());
        return 1;
    }

    private static int resetLoadedChunks(CommandSourceStack source, ServerLevel level) throws CommandSyntaxException {
        new LoadedChunkViewPacket((ResourceKey<Level>)level.m_46472_(), (Long2IntMap)Long2IntMaps.EMPTY_MAP).sendTo(source.m_81375_());
        return 1;
    }

    private static RequiredArgumentBuilder<CommandSourceStack, Integer> radiusArg() {
        return Commands.m_82129_((String)"radius_in_blocks", (ArgumentType)IntegerArgumentType.integer((int)0, (int)512));
    }

    private static int getRadiusArg(CommandContext<CommandSourceStack> context) {
        return IntegerArgumentType.getInteger(context, (String)"radius_in_blocks");
    }

    private static RequiredArgumentBuilder<CommandSourceStack, Coordinates> anchorArg() {
        return Commands.m_82129_((String)"anchor", (ArgumentType)new ColumnPosArgument());
    }

    private static ColumnPos getAnchorArg(CommandContext<CommandSourceStack> context) {
        return ColumnPosArgument.m_118992_(context, (String)"anchor");
    }

    private static RequiredArgumentBuilder<CommandSourceStack, ResourceLocation> dimArg() {
        return Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_());
    }

    private static ServerLevel getDimArg(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return DimensionArgument.m_88808_(context, (String)"dimension");
    }

    private static RequiredArgumentBuilder<CommandSourceStack, TeamArgumentProvider> forTeam(ToIntBiFunction<CommandSourceStack, Team> callback) {
        return (RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"team", (ArgumentType)TeamArgument.create()).requires(source -> source.m_6761_(2))).executes(context -> callback.applyAsInt((CommandSourceStack)context.getSource(), TeamArgument.get((CommandContext)context, (String)"team")));
    }

    private static ColumnPos toColumn(Vec3 pos) {
        BlockPos blockPos = BlockPos.m_274446_((Position)pos);
        return new ColumnPos(blockPos.m_123341_(), blockPos.m_123343_());
    }

    private static Team selfTeam(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        return (Team)FTBTeamsAPI.api().getManager().getTeamForPlayer(player).orElseThrow(() -> TeamArgument.TEAM_NOT_FOUND.create((Object)player.m_19879_()));
    }

    private static ClaimedChunkManagerImpl claimManager() {
        return ClaimedChunkManagerImpl.getInstance();
    }

    private static interface ChunkCallback {
        public void accept(ChunkTeamDataImpl var1, ChunkDimPos var2) throws CommandSyntaxException;
    }
}

