/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.api;

import dev.ftb.mods.ftblibrary.config.NameMap;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public interface ClaimResult {
    public String getResultId();

    default public boolean isSuccess() {
        return false;
    }

    public MutableComponent getMessage();

    public static ClaimResult customProblem(String translationKey) {
        return new CustomProblem(translationKey);
    }

    public static ClaimResult success() {
        return null;
    }

    public static class CustomProblem
    implements ClaimResult {
        private final String name;

        private CustomProblem(String name) {
            this.name = name;
        }

        @Override
        public String getResultId() {
            return this.name;
        }

        @Override
        public MutableComponent getMessage() {
            return Component.m_237115_((String)this.name);
        }
    }

    public static enum StandardProblem implements ClaimResult
    {
        NOT_OWNER("not_owner"),
        NOT_ENOUGH_POWER("not_enough_power"),
        ALREADY_CLAIMED("already_claimed"),
        DIMENSION_FORBIDDEN("dimension_forbidden"),
        NOT_CLAIMED("not_claimed"),
        ALREADY_LOADED("already_loaded"),
        NOT_LOADED("not_loaded");

        public static final NameMap<StandardProblem> NAME_MAP;
        private final String resultName;

        private StandardProblem(String resultName) {
            this.resultName = resultName;
        }

        public static Optional<StandardProblem> forName(String name) {
            return Optional.ofNullable((StandardProblem)NAME_MAP.get(name));
        }

        @Override
        public MutableComponent getMessage() {
            return Component.m_237115_((String)("ftbchunks.claim_result." + this.getResultId()));
        }

        @Override
        public String getResultId() {
            return this.resultName;
        }

        static {
            NAME_MAP = NameMap.of((Object)NOT_OWNER, (Object[])StandardProblem.values()).create();
        }
    }
}

