/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.util;

import com.blakebr0.cucumber.helper.NBTHelper;
import com.blakebr0.ironjetpacks.client.handler.InputHandler;
import com.blakebr0.ironjetpacks.compat.curios.CuriosCompat;
import com.blakebr0.ironjetpacks.config.ModConfigs;
import com.blakebr0.ironjetpacks.init.ModItems;
import com.blakebr0.ironjetpacks.item.JetpackItem;
import com.blakebr0.ironjetpacks.registry.Jetpack;
import com.blakebr0.ironjetpacks.registry.JetpackRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public final class JetpackUtils {
    private static final IEnergyStorage EMPTY_ENERGY_STORAGE = new EnergyStorage(0);

    public static boolean isFlying(Player player) {
        if (player.m_5833_()) {
            return false;
        }
        ItemStack stack = JetpackUtils.getEquippedJetpack(player);
        if (!stack.m_41619_() && JetpackUtils.isEngineOn(stack)) {
            Jetpack jetpack = JetpackUtils.getJetpack(stack);
            IEnergyStorage energy = JetpackUtils.getEnergyStorage(stack);
            if (energy.getEnergyStored() > 0 || player.m_7500_() || jetpack.creative) {
                if (JetpackUtils.isHovering(stack)) {
                    return !player.m_20096_();
                }
                return InputHandler.isHoldingUp(player);
            }
        }
        return false;
    }

    public static ItemStack getEquippedJetpack(Player player) {
        ItemStack stack = player.m_6844_(EquipmentSlot.CHEST);
        if (!stack.m_41619_() && stack.m_41720_() instanceof JetpackItem) {
            return stack;
        }
        if (ModConfigs.isCuriosEnabled()) {
            return CuriosCompat.findJetpackCurio((LivingEntity)player).orElse(ItemStack.f_41583_);
        }
        return ItemStack.f_41583_;
    }

    public static IEnergyStorage getEnergyStorage(ItemStack stack) {
        if (ForgeCapabilities.ENERGY == null) {
            return EMPTY_ENERGY_STORAGE;
        }
        return (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY).orElse((Object)EMPTY_ENERGY_STORAGE);
    }

    public static boolean isEngineOn(ItemStack stack) {
        return NBTHelper.getBoolean((ItemStack)stack, (String)"Engine");
    }

    public static boolean toggleEngine(ItemStack stack) {
        boolean current = NBTHelper.getBoolean((ItemStack)stack, (String)"Engine");
        NBTHelper.flipBoolean((ItemStack)stack, (String)"Engine");
        return !current;
    }

    public static boolean isHovering(ItemStack stack) {
        return NBTHelper.getBoolean((ItemStack)stack, (String)"Hover");
    }

    public static boolean toggleHover(ItemStack stack) {
        boolean current = NBTHelper.getBoolean((ItemStack)stack, (String)"Hover");
        NBTHelper.flipBoolean((ItemStack)stack, (String)"Hover");
        return !current;
    }

    public static double getThrottle(ItemStack stack) {
        if (!NBTHelper.hasKey((ItemStack)stack, (String)"Throttle")) {
            NBTHelper.setDouble((ItemStack)stack, (String)"Throttle", (double)1.0);
        }
        return NBTHelper.getDouble((ItemStack)stack, (String)"Throttle");
    }

    public static double incrementThrottle(ItemStack stack) {
        double throttle = JetpackUtils.getThrottle(stack);
        if (throttle < 1.0) {
            throttle = Math.min(throttle + 0.2, 1.0);
            NBTHelper.setDouble((ItemStack)stack, (String)"Throttle", (double)throttle);
        }
        return throttle;
    }

    public static double decrementThrottle(ItemStack stack) {
        double throttle = JetpackUtils.getThrottle(stack);
        if (throttle > 0.2) {
            throttle = Math.max(throttle - 0.2, 0.2);
            NBTHelper.setDouble((ItemStack)stack, (String)"Throttle", (double)throttle);
        }
        return throttle;
    }

    public static CompoundTag makeTag(Jetpack jetpack) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("Id", jetpack.getId().toString());
        return nbt;
    }

    public static ItemStack getItemForJetpack(Jetpack jetpack) {
        CompoundTag nbt = JetpackUtils.makeTag(jetpack);
        ItemStack stack = new ItemStack((ItemLike)ModItems.JETPACK.get());
        stack.m_41751_(nbt);
        return stack;
    }

    public static ItemStack getItemForComponent(Item item, Jetpack jetpack) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("Id", jetpack.getId().toString());
        ItemStack stack = new ItemStack((ItemLike)item);
        stack.m_41751_(nbt);
        return stack;
    }

    public static Jetpack getJetpack(ItemStack stack) {
        String id = NBTHelper.getString((ItemStack)stack, (String)"Id");
        if (!id.isEmpty()) {
            return JetpackRegistry.getInstance().getJetpackById(ResourceLocation.m_135820_((String)id));
        }
        return Jetpack.UNDEFINED;
    }
}

