/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.crafting;

import cofh.core.init.CoreRecipeSerializers;
import cofh.lib.api.control.ISecurable;
import cofh.lib.init.tags.ItemTagsCoFH;
import cofh.lib.util.helpers.SecurityHelper;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class SecureRecipe
extends CustomRecipe {
    public SecureRecipe(ResourceLocation pId, CraftingBookCategory pCategory) {
        super(pId, pCategory);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        Ingredient ingredientSecure = Ingredient.m_204132_(ItemTagsCoFH.LOCKS);
        Ingredient ingredientSecurable = Ingredient.m_204132_(ItemTagsCoFH.SECURABLE);
        boolean lockItem = false;
        boolean securableItem = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (ingredientSecure.test(stack)) {
                lockItem = true;
                continue;
            }
            if (!ingredientSecurable.test(stack) || SecurityHelper.hasSecurity(stack)) continue;
            securableItem = true;
        }
        return lockItem && securableItem;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess pRegistryAccess) {
        Ingredient ingredientSecurable = Ingredient.m_204132_(ItemTagsCoFH.SECURABLE);
        ItemStack result = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !ingredientSecurable.test(stack)) continue;
            result = stack.m_41777_();
            break;
        }
        if (!result.m_41619_()) {
            SecurityHelper.createSecurityTag(result);
            SecurityHelper.setAccess(result, ISecurable.AccessMode.PUBLIC);
        }
        return result;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CoreRecipeSerializers.SECURE_RECIPE_SERIALIZER.get();
    }
}

