/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.biomes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import mcjty.rftoolsdim.dimension.biomes.BiomeControllerType;
import mcjty.rftoolsdim.dimension.data.DimensionSettings;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;

public class RFTBiomeProvider
extends BiomeSource {
    public static final Codec<RFTBiomeProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryOps.retrieveRegistryLookup((ResourceKey)Registries.f_256729_).forGetter(RFTBiomeProvider::getWorldPresetLookup), (App)RegistryOps.retrieveRegistryLookup((ResourceKey)Registries.f_256952_).forGetter(RFTBiomeProvider::getBiomeLookup), (App)DimensionSettings.SETTINGS_CODEC.fieldOf("settings").forGetter(RFTBiomeProvider::getSettings)).apply((Applicative)instance, RFTBiomeProvider::new));
    private final List<Holder<Biome>> biomes;
    private final Set<TagKey<Biome>> biomeCategories;
    private final Map<ResourceLocation, Holder<Biome>> biomeMapping = new HashMap<ResourceLocation, Holder<Biome>>();
    private final HolderLookup.RegistryLookup<WorldPreset> worldPresetLookup;
    private final HolderLookup.RegistryLookup<Biome> biomeLookup;
    private final DimensionSettings settings;
    private final MultiNoiseBiomeSource multiNoiseBiomeSource;
    private final boolean defaultBiomes;
    private Holder<Biome> biome1 = null;
    private Holder<Biome> biome2 = null;

    public RFTBiomeProvider(HolderLookup.RegistryLookup<WorldPreset> worldPresetLookup, HolderLookup.RegistryLookup<Biome> biomeLookup, DimensionSettings settings) {
        this.settings = settings;
        this.biomeLookup = biomeLookup;
        this.worldPresetLookup = worldPresetLookup;
        Optional worldPreset = worldPresetLookup.m_254902_(WorldPresets.f_226437_);
        this.multiNoiseBiomeSource = (MultiNoiseBiomeSource)((LevelStem)((WorldPreset)((Holder.Reference)worldPreset.get()).get()).m_226420_().get()).f_63976_().m_62218_();
        this.biomes = this.getBiomes(biomeLookup, settings);
        this.biomeCategories = this.getBiomeCategories(settings);
        this.defaultBiomes = this.biomes.isEmpty() && this.biomeCategories.isEmpty();
        biomeLookup.m_214062_().forEach(this::getMappedBiome);
        this.getBiome1And2();
    }

    public HolderLookup.RegistryLookup<WorldPreset> getWorldPresetLookup() {
        return this.worldPresetLookup;
    }

    public DimensionSettings getSettings() {
        return this.settings;
    }

    private static List<Holder<Biome>> getDefaultBiomes(HolderLookup.RegistryLookup<Biome> biomeLookup, DimensionSettings settings) {
        List<ResourceLocation> biomes = settings.getCompiledDescriptor().getBiomes();
        if (biomes.isEmpty()) {
            return biomeLookup.m_214062_().collect(Collectors.toList());
        }
        return biomes.stream().map(rl -> biomeLookup.m_254902_(ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)rl))).map(Optional::get).collect(Collectors.toList());
    }

    protected Stream<Holder<Biome>> m_274359_() {
        return RFTBiomeProvider.getDefaultBiomes(this.biomeLookup, this.settings).stream();
    }

    private boolean isCategoryMatching(Holder<Biome> biome) {
        if (this.biomeCategories.isEmpty()) {
            return true;
        }
        return this.biomeLookup.m_255043_((ResourceKey)biome.m_203543_().get()).m_203616_().filter(this.biomeCategories::contains).findAny().isPresent();
    }

    private Holder<Biome> getMappedBiome(Holder<Biome> biome) {
        if (this.defaultBiomes) {
            return biome;
        }
        return this.biomeMapping.computeIfAbsent(((ResourceKey)biome.m_203543_().get()).m_135782_(), resourceLocation -> {
            List<Holder<Biome>> biomes = this.getBiomes(this.biomeLookup, this.settings);
            float[] minDist = new float[]{1.0E9f};
            Holder[] desired = new Holder[]{biome};
            if (biomes.isEmpty()) {
                if (!this.isCategoryMatching((Holder<Biome>)desired[0])) {
                    this.biomeLookup.m_214062_().forEach(b -> {
                        float dist;
                        if (this.isCategoryMatching((Holder<Biome>)b) && (dist = this.distance((Holder<Biome>)b, biome)) < minDist[0]) {
                            desired[0] = b;
                            minDist[0] = dist;
                        }
                    });
                }
            } else {
                for (Holder<Biome> b2 : biomes) {
                    float dist;
                    if (!this.biomeCategories.isEmpty() && !this.isCategoryMatching(b2) || !((dist = this.distance(b2, biome)) < minDist[0])) continue;
                    desired[0] = b2;
                    minDist[0] = dist;
                }
            }
            return desired[0];
        });
    }

    private float distance(Holder<Biome> biome1, Holder<Biome> biome2) {
        if (Objects.equals(biome1, biome2)) {
            return -1.0f;
        }
        if (Objects.equals(biome1.m_203334_(), biome2.m_203334_())) {
            return -1.0f;
        }
        Set tags1 = biome1.m_203616_().collect(Collectors.toSet());
        Set tags2 = biome2.m_203616_().collect(Collectors.toSet());
        tags1.removeAll(tags2);
        tags1 = biome1.m_203616_().collect(Collectors.toSet());
        tags2.removeAll(tags1);
        float d1 = Math.max(tags1.size(), tags2.size());
        float d2 = Math.abs(((Biome)biome1.m_203334_()).m_47554_() - ((Biome)biome2.m_203334_()).m_47554_());
        return d1 + d2 * d2;
    }

    private List<Holder<Biome>> getBiomes(HolderLookup.RegistryLookup<Biome> holderLookup, DimensionSettings settings) {
        List<ResourceLocation> biomes = settings.getCompiledDescriptor().getBiomes();
        return biomes.stream().map(rl -> this.biomeLookup.m_254902_(ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)rl))).map(Optional::get).collect(Collectors.toList());
    }

    private Set<TagKey<Biome>> getBiomeCategories(DimensionSettings settings) {
        Set<TagKey<Biome>> categories = settings.getCompiledDescriptor().getBiomeCategories();
        return categories;
    }

    public HolderLookup.RegistryLookup<Biome> getBiomeLookup() {
        return this.biomeLookup;
    }

    @Nonnull
    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    private void getBiome1And2() {
        if (this.biome1 == null) {
            if (this.biomes.isEmpty()) {
                List list = this.biomeLookup.m_214062_().filter(this::isCategoryMatching).collect(Collectors.toList());
                if (list.isEmpty()) {
                    this.biome1 = this.biome2 = (Holder)this.biomeLookup.m_254902_(Biomes.f_48202_).get();
                } else {
                    this.biome1 = (Holder)list.get(0);
                    this.biome2 = list.size() > 1 ? (Holder)list.get(1) : this.biome1;
                }
            } else {
                this.biome1 = this.biomes.get(0);
                this.biome2 = this.biomes.size() > 1 ? this.biomes.get(1) : this.biome1;
            }
            this.biome1 = this.getMappedBiome(this.biome1);
            if (this.biome1 == null) {
                this.biome1 = (Holder)this.biomeLookup.m_254902_(Biomes.f_48202_).get();
            }
            this.biome2 = this.getMappedBiome(this.biome2);
            if (this.biome2 == null) {
                this.biome2 = this.biome1;
            }
        }
    }

    @Nonnull
    public Holder<Biome> m_203407_(int x, int y, int z, Climate.Sampler climate) {
        return switch (this.settings.getCompiledDescriptor().getBiomeControllerType()) {
            case BiomeControllerType.CHECKER -> this.getCheckerBiome(x, z);
            case BiomeControllerType.SINGLE -> this.getSingleBiome();
            default -> this.getDefaultBiome(x, y, z, climate);
        };
    }

    private Holder<Biome> getDefaultBiome(int x, int y, int z, Climate.Sampler climate) {
        if (this.defaultBiomes) {
            return this.multiNoiseBiomeSource.m_203407_(x, y, z, climate);
        }
        return this.getMappedBiome((Holder<Biome>)this.multiNoiseBiomeSource.m_203407_(x, y, z, climate));
    }

    private Holder<Biome> getSingleBiome() {
        return this.biome1;
    }

    private Holder<Biome> getCheckerBiome(int x, int z) {
        if (((x >> 3) + (z >> 3)) % 2 == 0) {
            return this.biome1;
        }
        return this.biome2;
    }
}

