/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.data;

import java.util.UUID;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.dimension.IDimensionInformation;
import mcjty.rftoolsdim.dimension.descriptor.DimensionDescriptor;
import mcjty.rftoolsdim.dimension.power.PowerHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class DimensionData
implements IDimensionInformation {
    private final ResourceLocation id;
    private final DimensionDescriptor descriptor;
    private final DimensionDescriptor randomizedDescriptor;
    private final UUID owner;
    private final long skyDimletTypes;
    private long energy;
    private int activityProbes;

    public DimensionData(ResourceLocation id, DimensionDescriptor descriptor, DimensionDescriptor randomizedDescriptor, UUID owner, long skyDimletTypes) {
        this.id = id;
        this.descriptor = descriptor;
        this.randomizedDescriptor = randomizedDescriptor;
        this.owner = owner;
        this.skyDimletTypes = skyDimletTypes;
        this.activityProbes = 0;
    }

    public DimensionData(CompoundTag tag) {
        this.id = new ResourceLocation(tag.m_128461_("id"));
        this.descriptor = new DimensionDescriptor();
        this.descriptor.read(tag.m_128461_("descriptor"));
        this.energy = tag.m_128454_("energy");
        if (tag.m_128441_("randomized")) {
            this.randomizedDescriptor = new DimensionDescriptor();
            this.randomizedDescriptor.read(tag.m_128461_("randomized"));
        } else {
            this.randomizedDescriptor = DimensionDescriptor.EMPTY;
        }
        this.skyDimletTypes = tag.m_128454_("skytypes");
        this.activityProbes = tag.m_128451_("probes");
        this.owner = tag.m_128441_("owner") ? tag.m_128342_("owner") : null;
    }

    public void write(CompoundTag tag) {
        tag.m_128359_("id", this.id.toString());
        tag.m_128359_("descriptor", this.descriptor.compact());
        tag.m_128359_("randomized", this.randomizedDescriptor.compact());
        tag.m_128356_("energy", this.energy);
        tag.m_128356_("skytypes", this.skyDimletTypes);
        tag.m_128405_("probes", this.activityProbes);
        if (this.owner != null) {
            tag.m_128362_("owner", this.owner);
        }
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public DimensionDescriptor getDescriptor() {
        return this.descriptor;
    }

    public DimensionDescriptor getRandomizedDescriptor() {
        return this.randomizedDescriptor;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public long getSkyTypes() {
        return this.skyDimletTypes;
    }

    public long getEnergy() {
        return this.energy;
    }

    public long getMaxEnergy(Level world) {
        return PowerHandler.calculateMaxDimensionPower(this.id, world);
    }

    public int getActivityProbes() {
        return this.activityProbes;
    }

    public void setActivityProbes(int activityProbes) {
        this.activityProbes = activityProbes;
    }

    public void setEnergy(Level overworld, long energy) {
        if (energy != this.energy) {
            long old = this.energy;
            this.energy = energy;
            if (overworld == null || (old == 0L && energy > 0L ? (overworld = LevelTools.getLevel((Level)overworld, (ResourceLocation)this.id)) != null : energy != 0L || (overworld = LevelTools.getLevel((Level)overworld, (ResourceLocation)this.id)) != null)) {
                // empty if block
            }
        }
    }
}

