/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.blob.client;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import mcjty.rftoolsdim.modules.blob.client.DimensionalBlobModel;
import mcjty.rftoolsdim.modules.blob.entities.DimensionalBlobEntity;
import mcjty.rftoolsdim.modules.dimlets.data.DimletRarity;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class DimensionalBlobRender
extends LivingEntityRenderer<DimensionalBlobEntity, DimensionalBlobModel<DimensionalBlobEntity>> {
    private static final ResourceLocation TEXTURE_COMMON = new ResourceLocation("rftoolsdim", "textures/entity/dimensional_blob_common.png");
    private static final ResourceLocation TEXTURE_RARE = new ResourceLocation("rftoolsdim", "textures/entity/dimensional_blob_rare.png");
    private static final ResourceLocation TEXTURE_LEGENDARY = new ResourceLocation("rftoolsdim", "textures/entity/dimensional_blob_legendary.png");

    public DimensionalBlobRender(EntityRendererProvider.Context context) {
        super(context, new DimensionalBlobModel(context.m_174027_().m_171103_(DimensionalBlobModel.BLOB_LAYER)), 0.8f);
    }

    @Nonnull
    public ResourceLocation getTextureLocation(DimensionalBlobEntity entity) {
        return switch (entity.getRarity()) {
            default -> throw new IncompatibleClassChangeError();
            case DimletRarity.COMMON -> TEXTURE_COMMON;
            case DimletRarity.UNCOMMON -> TEXTURE_COMMON;
            case DimletRarity.RARE -> TEXTURE_RARE;
            case DimletRarity.LEGENDARY -> TEXTURE_LEGENDARY;
        };
    }

    protected boolean shouldShowName(DimensionalBlobEntity entity) {
        return entity.m_8077_() && super.m_6512_((LivingEntity)entity);
    }

    protected void scale(DimensionalBlobEntity entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        matrixStackIn.m_85841_(0.999f, 0.999f, 0.999f);
        matrixStackIn.m_85837_(0.0, (double)0.301f, 0.0);
        float f1 = 2.0f * entitylivingbaseIn.m_6134_();
        float f2 = Mth.m_14179_((float)partialTickTime, (float)entitylivingbaseIn.prevSquishFactor, (float)entitylivingbaseIn.squishFactor) / (f1 * 0.5f + 1.0f);
        float f3 = 1.0f / (f2 + 1.0f);
        matrixStackIn.m_85841_(f3 * f1, 1.0f / f3 * f1, f3 * f1);
    }
}

