/*
 * Decompiled with CFR 0.152.
 */
package net.deechael.concentration.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;

public abstract class ConcentrationConfigScreen
extends Screen {
    private final Screen parent;
    private ConfigListWidget entries;

    protected ConcentrationConfigScreen(Component title, Screen parent) {
        super(title);
        this.parent = parent;
    }

    protected final void m_7856_() {
        this.entries = new ConfigListWidget(this.f_96541_, this.f_96543_, this.f_96544_ - 64, 32, 25);
        this.addElements();
        this.m_142416_((GuiEventListener)this.entries);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"concentration.option.apply"), button -> this.save()).m_252794_(this.f_96543_ / 2 - 175, this.f_96544_ - 27).m_253046_(150, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> {
            this.save();
            Minecraft.m_91087_().m_91152_(this.parent);
        }).m_252794_(this.f_96543_ / 2 + 25, this.f_96544_ - 27).m_253046_(150, 20).m_253136_());
    }

    public final void m_7861_() {
        this.save();
    }

    public abstract void save();

    public void m_88315_(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.m_88315_(context, mouseX, mouseY, delta);
        Style hoveredStyle = this.entries.getHoveredStyle(mouseX, mouseY);
        if (hoveredStyle != null) {
            context.m_280304_(this.f_96547_, hoveredStyle, mouseX, mouseY);
        }
        context.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 10, 0xFFFFFF);
    }

    public void m_280273_(@NotNull GuiGraphics graphics) {
        super.m_280273_(graphics);
    }

    public abstract void addElements();

    public void addOption(OptionInstance<?> opt) {
        this.entries.addEntry(new ConfigListEntry(Collections.singletonList(opt.m_231507_(this.f_96541_.f_91066_, this.f_96543_ / 2 - 155, 0, 310))));
    }

    public void addOptionsRow(OptionInstance<?> opt, OptionInstance<?> opt2) {
        this.entries.addEntry(new ConfigListEntry(Arrays.asList(opt.m_231507_(this.f_96541_.f_91066_, this.f_96543_ / 2 - 155, 0, 150), opt2.m_231507_(this.f_96541_.f_91066_, this.f_96543_ / 2 - 155 + 160, 0, 150))));
    }

    public void addHeading(Component text) {
        this.entries.addEntry(new ConfigListHeader(text, this.f_96547_, this.f_96543_, this));
    }

    public void addTextField(Component description, Supplier<String> getter, Consumer<String> setter) {
        this.addTextField(description, getter, setter, Objects::nonNull);
    }

    public void addTextField(Component description, Supplier<String> getter, Consumer<String> setter, Predicate<String> validator) {
        this.entries.addEntry(new ConfigListTextField(this.f_96547_, this.f_96543_ / 2 - 154, 0, 308, 18, description, getter, setter, validator));
    }

    public void addIntField(Component description, Supplier<Integer> getter, Consumer<Integer> setter) {
        this.addTextField(description, () -> ((Integer)getter.get()).toString(), value -> setter.accept(Integer.parseInt(value)), value -> {
            try {
                Integer.parseInt(value);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
    }

    public void addFloatField(Component description, Supplier<Float> getter, Consumer<Float> setter) {
        this.addTextField(description, () -> ((Float)getter.get()).toString(), value -> setter.accept(Float.valueOf(Float.parseFloat(value))), value -> {
            try {
                Float.parseFloat(value);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
    }

    private static class ConfigListWidget
    extends ContainerObjectSelectionList<ConfigListEntry> {
        public ConfigListWidget(Minecraft minecraftClient, int width, int height, int y, int itemHeight) {
            super(minecraftClient, width, height, y, minecraftClient.m_91268_().m_85446_(), itemHeight);
        }

        public int addEntry(@NotNull ConfigListEntry entry) {
            return super.m_7085_((AbstractSelectionList.Entry)entry);
        }

        public int m_5759_() {
            return 400;
        }

        protected int m_5756_() {
            return super.m_5756_() + 32;
        }

        public Style getHoveredStyle(int mouseX, int mouseY) {
            Optional hovered = this.m_94729_(mouseX, mouseY);
            return hovered.map(guiEventListener -> ((ConfigListEntry)((Object)guiEventListener)).getHoveredStyle(mouseX, mouseY)).orElse(null);
        }
    }

    public static class ConfigListEntry
    extends ContainerObjectSelectionList.Entry<ConfigListEntry> {
        private final List<AbstractWidget> buttons;

        public ConfigListEntry(List<AbstractWidget> buttons) {
            this.buttons = buttons;
        }

        public void m_6311_(@NotNull GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            for (AbstractWidget widget : this.buttons) {
                widget.m_253211_(y);
                widget.m_88315_(context, mouseX, mouseY, tickDelta);
            }
        }

        public List<? extends NarratableEntry> m_142437_() {
            return this.buttons;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.buttons;
        }

        public Style getHoveredStyle(int mouseX, int mouseY) {
            return null;
        }
    }

    public static class ConfigListHeader
    extends ConfigListEntry {
        private final Component headerText;
        private final Font textRenderer;
        private final int width;
        private final int textWidth;
        private final Screen screen;

        public ConfigListHeader(Component headerText, Font textRenderer, int width, Screen screen) {
            super(Collections.emptyList());
            this.headerText = headerText;
            this.textRenderer = textRenderer;
            this.width = width;
            this.textWidth = textRenderer.m_92852_((FormattedText)headerText);
            this.screen = screen;
        }

        @Override
        public void m_6311_(@NotNull GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            context.m_280653_(this.textRenderer, this.headerText, this.width / 2, y + 5, 0xFFFFFF);
        }

        private Style getStyleAt(int mouseX) {
            int min = this.width / 2 - this.textWidth / 2;
            int max = this.width / 2 + this.textWidth / 2;
            if (mouseX >= min && mouseX <= max) {
                return this.textRenderer.m_92865_().m_92386_((FormattedText)this.headerText, mouseX - min);
            }
            return null;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            return this.screen.m_5561_(this.getStyleAt((int)mouseX));
        }

        @Override
        public Style getHoveredStyle(int mouseX, int mouseY) {
            Style style = this.getStyleAt(mouseX);
            if (style != null && style.m_131186_() != null) {
                return style;
            }
            return null;
        }

        @Override
        public List<? extends NarratableEntry> m_142437_() {
            return Collections.singletonList(new NarratableEntry(){

                public // Could not load outer class - annotation placement on inner may be incorrect
                @NotNull NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(@NotNull NarrationElementOutput builder) {
                    builder.m_169146_(NarratedElementType.TITLE, headerText);
                }
            });
        }
    }

    public static class ConfigListTextField
    extends ConfigListEntry {
        private final EditBox textField = (EditBox)this.m_6702_().get(0);
        private final int textWidth;
        private final Font textRenderer;
        private final int x;

        public ConfigListTextField(Font textRenderer, int x, int y, int width, int height, Component description, Supplier<String> getter, Consumer<String> setter, Predicate<String> validator) {
            super(Collections.singletonList(ConfigListTextField.makeField(textRenderer, x, y, width, height, description)));
            this.textWidth = textRenderer.m_92852_((FormattedText)description);
            this.textRenderer = textRenderer;
            this.x = x;
            this.textField.m_94144_(getter.get());
            this.textField.m_94151_(value -> {
                if (validator.test((String)value)) {
                    setter.accept((String)value);
                    this.textField.m_94202_(0xE0E0E0);
                } else {
                    this.textField.m_94202_(0xFF0000);
                }
            });
        }

        private static EditBox makeField(Font textRenderer, int x, int y, int width, int height, Component description) {
            return new EditBox(textRenderer, x + width / 2 + 7, y, width / 2 - 8, height, description){

                public void m_168797_(NarrationElementOutput builder) {
                    builder.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
                }
            };
        }

        @Override
        public Style getHoveredStyle(int mouseX, int mouseY) {
            Style style;
            int max = this.x + this.textWidth;
            if (mouseX >= this.x && mouseX <= max && (style = this.textRenderer.m_92865_().m_92386_((FormattedText)this.textField.m_6035_(), mouseX - this.x)) != null && style.m_131186_() != null) {
                return style;
            }
            return null;
        }

        @Override
        public void m_6311_(@NotNull GuiGraphics drawContext, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            drawContext.m_280430_(this.textRenderer, this.textField.m_6035_(), this.x, y + 5, 0xFFFFFF);
            super.m_6311_(drawContext, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
        }
    }
}

