/*
 * Decompiled with CFR 0.152.
 */
package net.deechael.concentration.forge.mixin;

import com.mojang.blaze3d.platform.Monitor;
import com.mojang.blaze3d.platform.ScreenManager;
import com.mojang.blaze3d.platform.VideoMode;
import com.mojang.blaze3d.platform.Window;
import net.deechael.concentration.ConcentrationConstants;
import net.deechael.concentration.FullscreenMode;
import net.deechael.concentration.forge.config.ConcentrationConfigForge;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Window.class})
public abstract class WindowMixin {
    @Shadow
    private boolean f_85355_;
    @Shadow
    @Final
    private ScreenManager f_85348_;
    @Shadow
    private int f_85357_;
    @Shadow
    private int f_85358_;
    @Shadow
    private int f_85359_;
    @Shadow
    private int f_85360_;
    @Unique
    private long concentration$lastMonitor = -1L;
    @Unique
    private boolean concentration$cachedSize = false;
    @Unique
    private boolean concentration$cachedPos = false;
    @Unique
    private boolean concentration$cacheSizeLock = false;
    @Unique
    private int concentration$cachedX = 0;
    @Unique
    private int concentration$cachedY = 0;
    @Unique
    private int concentration$cachedWidth = 0;
    @Unique
    private int concentration$cachedHeight = 0;

    @Inject(method={"onMove"}, at={@At(value="HEAD")})
    private void inject$onMove$head(long window, int x, int y, CallbackInfo ci) {
        if (!this.f_85355_) {
            if (!this.concentration$cachedPos) {
                ConcentrationConstants.LOGGER.info("Window position has been cached");
            }
            this.concentration$cachedPos = true;
            this.concentration$cachedX = x;
            this.concentration$cachedY = y;
        }
    }

    @Inject(method={"onResize"}, at={@At(value="HEAD")})
    private void inject$onResize$head(long window, int width, int height, CallbackInfo ci) {
        if (!this.f_85355_ && !this.concentration$cacheSizeLock) {
            if (!this.concentration$cachedSize) {
                ConcentrationConstants.LOGGER.info("Window size has been cached");
            }
            this.concentration$cachedSize = true;
            this.concentration$cachedWidth = width;
            this.concentration$cachedHeight = height;
        }
    }

    @Redirect(method={"setMode"}, at=@At(value="INVOKE", remap=false, target="Lorg/lwjgl/glfw/GLFW;glfwSetWindowMonitor(JJIIIII)V"))
    private void redirect$glfwSetWindowMonitor(long window, long monitor, int xpos, int ypos, int width, int height, int refreshRate) {
        int finalHeight;
        int finalWidth;
        int finalY;
        int finalX;
        ConcentrationConstants.LOGGER.info("================= [Concentration Start] =================");
        ConcentrationConstants.LOGGER.info("Trying to modify window monitor");
        if (monitor != 0L) {
            ConcentrationConstants.LOGGER.info("Modifying window size limits");
            GLFW.glfwSetWindowSizeLimits((long)window, (int)0, (int)0, (int)width, (int)height);
        }
        if (this.f_85355_) {
            ConcentrationConfigForge.ensureLoaded();
            this.concentration$lastMonitor = monitor;
            this.concentration$cacheSizeLock = true;
            ConcentrationConstants.LOGGER.info("Locked size caching");
            if (ConcentrationConfigForge.FULLSCREEN.get() == FullscreenMode.NATIVE) {
                ConcentrationConstants.LOGGER.info("Fullscreen mode is native, apply now!");
                GLFW.glfwSetWindowMonitor((long)window, (long)monitor, (int)xpos, (int)ypos, (int)width, (int)height, (int)-1);
                ConcentrationConstants.LOGGER.info("================= [Concentration End] =================");
                return;
            }
            ConcentrationConstants.LOGGER.info("Trying to switch to borderless fullscreen mode");
            Monitor monitorInstance = this.f_85348_.m_85271_(monitor);
            ConcentrationConstants.LOGGER.info("Current fullscreen monitor is {}", (Object)monitor);
            GLFW.glfwSetWindowAttrib((long)window, (int)131077, (int)0);
            ConcentrationConstants.LOGGER.info("Trying to remove the title bar");
            if (((Boolean)ConcentrationConfigForge.CUSTOMIZED.get()).booleanValue()) {
                boolean related = (Boolean)ConcentrationConfigForge.RELATED.get();
                int configX = (Integer)ConcentrationConfigForge.X.get();
                int configY = (Integer)ConcentrationConfigForge.Y.get();
                int configWidth = (Integer)ConcentrationConfigForge.WIDTH.get();
                int configHeight = (Integer)ConcentrationConfigForge.HEIGHT.get();
                ConcentrationConstants.LOGGER.info("Customization enabled, so replace the fullscreen size with customized size");
                finalX = configX + (related ? monitorInstance.m_84951_() : 0);
                finalY = configY - (configHeight == height ? 1 : 0) + (related ? monitorInstance.m_84952_() : 0);
                finalWidth = configWidth;
                finalHeight = configHeight + (configHeight == height ? 1 : 0);
            } else {
                finalX = monitorInstance.m_84951_();
                finalY = monitorInstance.m_84952_() - 1;
                finalWidth = width;
                finalHeight = height + 1;
            }
            this.f_85357_ = finalX;
            this.f_85358_ = finalY;
            this.f_85359_ = finalWidth;
            this.f_85360_ = finalHeight;
        } else {
            ConcentrationConstants.LOGGER.info("Trying to switch to windowed mode");
            ConcentrationConstants.LOGGER.info("Trying to add title bar back");
            GLFW.glfwSetWindowAttrib((long)window, (int)131077, (int)1);
            ConcentrationConstants.LOGGER.info("Trying to use cached value to resize the window");
            finalWidth = this.concentration$cachedSize ? this.concentration$cachedWidth : width;
            int n = finalHeight = this.concentration$cachedSize ? this.concentration$cachedHeight : height;
            if (this.concentration$cachedPos) {
                finalX = this.concentration$cachedX;
                finalY = this.concentration$cachedY;
            } else if (this.concentration$lastMonitor != -1L) {
                Monitor monitorInstance = this.f_85348_.m_85271_(this.concentration$lastMonitor);
                VideoMode videoMode = monitorInstance.m_84950_();
                finalX = (videoMode.m_85332_() - finalWidth) / 2;
                finalY = (videoMode.m_85335_() - finalHeight) / 2;
            } else {
                finalX = xpos;
                finalY = ypos;
            }
            this.concentration$cacheSizeLock = false;
            ConcentrationConstants.LOGGER.info("Unlocked size caching");
        }
        ConcentrationConstants.LOGGER.info("Window size: {}, {}, position: {}, {}", new Object[]{finalWidth, finalHeight, finalX, finalY});
        ConcentrationConstants.LOGGER.info("Trying to resize and reposition the window");
        GLFW.glfwSetWindowMonitor((long)window, (long)0L, (int)finalX, (int)finalY, (int)finalWidth, (int)finalHeight, (int)-1);
        ConcentrationConstants.LOGGER.info("================= [Concentration End] =================");
    }

    @Redirect(method={"setMode"}, at=@At(value="INVOKE", remap=false, target="Lorg/lwjgl/glfw/GLFW;glfwGetWindowMonitor(J)J"))
    private long redirect$glfwGetWindowMonitor(long window) {
        return 1L;
    }
}

