/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.PreviewType;
import com.misterpemodder.shulkerboxtooltip.api.ShulkerBoxTooltipApi;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.network.ClientNetworking;
import com.misterpemodder.shulkerboxtooltip.impl.util.Key;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class ShulkerBoxTooltipClient {
    private static ItemStack previousStack = null;
    public static Minecraft client;
    private static boolean wasPreviewAccessed;
    private static boolean previewKeyPressed;
    private static boolean fullPreviewKeyPressed;
    private static boolean lockPreviewKeyPressed;
    private static boolean lockKeyHintsEnabled;

    public static void init() {
        client = Minecraft.m_91087_();
        ClientNetworking.init();
    }

    private static boolean isPreviewRequested() {
        return ShulkerBoxTooltip.config.preview.alwaysOn || ShulkerBoxTooltipClient.isPreviewKeyPressed();
    }

    private static List<Component> getTooltipHints(PreviewContext context, PreviewProvider provider) {
        if (!ShulkerBoxTooltip.config.preview.enable || !provider.shouldDisplay(context)) {
            return Collections.emptyList();
        }
        boolean previewRequested = ShulkerBoxTooltipClient.isPreviewRequested();
        ArrayList<Component> hints = new ArrayList<Component>();
        Component previewKeyHint = ShulkerBoxTooltipClient.getPreviewKeyTooltipHint(context, provider, previewRequested);
        Component lockKeyHint = ShulkerBoxTooltipClient.getLockKeyTooltipHint(context, provider, previewRequested);
        if (previewKeyHint != null) {
            hints.add(previewKeyHint);
        }
        if (lockKeyHint != null) {
            hints.add(lockKeyHint);
        }
        return hints;
    }

    @Nullable
    private static Component getPreviewKeyTooltipHint(PreviewContext context, PreviewProvider provider, boolean previewRequested) {
        if (previewRequested && ShulkerBoxTooltipClient.isFullPreviewKeyPressed()) {
            return null;
        }
        boolean fullPreviewAvailable = provider.isFullPreviewAvailable(context);
        if (!fullPreviewAvailable && previewRequested) {
            return null;
        }
        MutableComponent previewKeyHint = Component.m_237113_((String)"");
        Component previewKeyText = ShulkerBoxTooltip.config.controls.previewKey.get().m_84875_();
        if (previewRequested) {
            previewKeyHint.m_7220_(ShulkerBoxTooltip.config.controls.fullPreviewKey.get().m_84875_());
            if (!ShulkerBoxTooltip.config.preview.alwaysOn) {
                previewKeyHint.m_130946_("+").m_7220_(previewKeyText);
            }
        } else {
            previewKeyHint.m_7220_(previewKeyText);
        }
        previewKeyHint.m_130946_(": ");
        previewKeyHint.m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD));
        String contentHint = ShulkerBoxTooltipApi.getCurrentPreviewType(fullPreviewAvailable) == PreviewType.NO_PREVIEW ? (ShulkerBoxTooltip.config.preview.swapModes ? provider.getFullTooltipHintLangKey(context) : provider.getTooltipHintLangKey(context)) : (ShulkerBoxTooltip.config.preview.swapModes ? provider.getTooltipHintLangKey(context) : provider.getFullTooltipHintLangKey(context));
        return previewKeyHint.m_7220_((Component)Component.m_237115_((String)contentHint).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.WHITE)));
    }

    @Nullable
    private static Component getLockKeyTooltipHint(PreviewContext context, PreviewProvider provider, boolean previewRequested) {
        if (!previewRequested || ShulkerBoxTooltipClient.isLockPreviewKeyPressed() || !lockKeyHintsEnabled) {
            return null;
        }
        MutableComponent lockKeyHint = Component.m_237113_((String)"");
        String lockKeyHintLangKey = provider.getLockKeyTooltipHintLangKey(context);
        lockKeyHint.m_7220_(ShulkerBoxTooltip.config.controls.lockTooltipKey.get().m_84875_());
        lockKeyHint.m_130946_(": ");
        lockKeyHint.m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD));
        lockKeyHint.m_7220_((Component)Component.m_237115_((String)lockKeyHintLangKey).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.WHITE)));
        return lockKeyHint;
    }

    public static void modifyStackTooltip(ItemStack stack, Consumer<Collection<Component>> tooltip) {
        if (client == null) {
            return;
        }
        PreviewContext context = PreviewContext.of(stack, (Player)ShulkerBoxTooltipClient.client.f_91074_);
        PreviewProvider provider = ShulkerBoxTooltipApi.getPreviewProviderForStack(stack);
        if (provider == null) {
            return;
        }
        if (previousStack == null || !ItemStack.m_41728_((ItemStack)stack, (ItemStack)previousStack)) {
            wasPreviewAccessed = false;
        }
        previousStack = stack;
        if (!wasPreviewAccessed) {
            provider.onInventoryAccessStart(context);
        }
        wasPreviewAccessed = true;
        if (provider.showTooltipHints(context)) {
            if (ShulkerBoxTooltip.config.tooltip.type == Configuration.ShulkerBoxTooltipType.MOD) {
                tooltip.accept(provider.addTooltip(context));
            }
            if (ShulkerBoxTooltip.config.tooltip.showKeyHints) {
                tooltip.accept(ShulkerBoxTooltipClient.getTooltipHints(context, provider));
            }
        }
    }

    public static boolean isPreviewAvailable(PreviewContext context) {
        if (ShulkerBoxTooltip.config.preview.enable) {
            PreviewProvider provider = ShulkerBoxTooltipApi.getPreviewProviderForStack(context.stack());
            return provider != null && provider.shouldDisplay(context) && ShulkerBoxTooltipApi.getCurrentPreviewType(provider.isFullPreviewAvailable(context)) != PreviewType.NO_PREVIEW;
        }
        return false;
    }

    public static PreviewType getCurrentPreviewType(boolean hasFullPreviewMode) {
        boolean previewRequested = ShulkerBoxTooltipClient.isPreviewRequested();
        if (previewRequested && !hasFullPreviewMode) {
            return PreviewType.COMPACT;
        }
        if (ShulkerBoxTooltip.config.preview.swapModes) {
            if (previewRequested) {
                return ShulkerBoxTooltipClient.isFullPreviewKeyPressed() ? PreviewType.COMPACT : PreviewType.FULL;
            }
        } else if (previewRequested) {
            return ShulkerBoxTooltipClient.isFullPreviewKeyPressed() ? PreviewType.FULL : PreviewType.COMPACT;
        }
        return PreviewType.NO_PREVIEW;
    }

    public static boolean isPreviewKeyPressed() {
        return previewKeyPressed;
    }

    public static boolean isFullPreviewKeyPressed() {
        return fullPreviewKeyPressed;
    }

    public static boolean isLockPreviewKeyPressed() {
        return lockPreviewKeyPressed;
    }

    public static void setLockKeyHintsEnabled(boolean value) {
        lockKeyHintsEnabled = value;
    }

    private static boolean isKeyPressed(@Nullable Key key) {
        if (key == null || key.equals(Key.UNKNOWN_KEY) || key.get().equals((Object)InputConstants.f_84822_)) {
            return false;
        }
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key.get().m_84873_());
    }

    public static void updatePreviewKeys() {
        Configuration config = ShulkerBoxTooltip.config;
        if (config == null) {
            previewKeyPressed = false;
            fullPreviewKeyPressed = false;
            lockPreviewKeyPressed = false;
        } else {
            previewKeyPressed = ShulkerBoxTooltipClient.isKeyPressed(config.controls.previewKey);
            fullPreviewKeyPressed = ShulkerBoxTooltipClient.isKeyPressed(config.controls.fullPreviewKey);
            lockPreviewKeyPressed = ShulkerBoxTooltipClient.isKeyPressed(config.controls.lockTooltipKey);
        }
    }

    static {
        wasPreviewAccessed = false;
        previewKeyPressed = false;
        fullPreviewKeyPressed = false;
        lockPreviewKeyPressed = false;
        lockKeyHintsEnabled = false;
    }
}

