/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.api.reactor;

import java.util.Objects;
import net.minecraft.util.Mth;

public class FuelProperties {
    public static final FuelProperties DEFAULT = new FuelProperties(1.5f, 0.5f, 1.0f, 0.01f, 7.0E-4f);
    public static final FuelProperties INVALID = new FuelProperties(1.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    private float _fuelModerationFactor;
    private float _fuelAbsorptionCoefficient;
    private float _fuelHardnessDivisor;
    private float _fissionEventsPerFuelUnit;
    private float _fuelUnitsPerFissionEvent;

    FuelProperties(float moderationFactor, float absorptionCoefficient, float hardnessDivisor, float fissionEventsPerFuelUnit, float fuelUnitsPerFissionEvent) {
        this.setModerationFactor(moderationFactor);
        this.setAbsorptionCoefficient(absorptionCoefficient);
        this.setHardnessDivisor(hardnessDivisor);
        this.setFissionEventsPerFuelUnit(fissionEventsPerFuelUnit);
        this.setFuelUnitsPerFissionEvent(fuelUnitsPerFissionEvent);
    }

    public float getModerationFactor() {
        return this._fuelModerationFactor;
    }

    public void setModerationFactor(float value) {
        this._fuelModerationFactor = Math.max(1.0f, value);
    }

    public float getAbsorptionCoefficient() {
        return this._fuelAbsorptionCoefficient;
    }

    public void setAbsorptionCoefficient(float value) {
        this._fuelAbsorptionCoefficient = Mth.m_14036_((float)value, (float)0.0f, (float)1.0f);
    }

    public float getHardnessDivisor() {
        return this._fuelHardnessDivisor;
    }

    public void setHardnessDivisor(float value) {
        this._fuelHardnessDivisor = Math.max(1.0f, value);
    }

    public float getFissionEventsPerFuelUnit() {
        return this._fissionEventsPerFuelUnit;
    }

    public void setFissionEventsPerFuelUnit(float value) {
        this._fissionEventsPerFuelUnit = Math.max(0.0f, value);
    }

    public float getFuelUnitsPerFissionEvent() {
        return this._fuelUnitsPerFissionEvent;
    }

    public void setFuelUnitsPerFissionEvent(float value) {
        this._fuelUnitsPerFissionEvent = Math.max(0.0f, value);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FuelProperties)) {
            return false;
        }
        FuelProperties properties = (FuelProperties)other;
        return 0 == Float.compare(this._fuelModerationFactor, properties._fuelModerationFactor) && 0 == Float.compare(this._fuelAbsorptionCoefficient, properties._fuelAbsorptionCoefficient) && 0 == Float.compare(this._fuelHardnessDivisor, properties._fuelHardnessDivisor) && 0 == Float.compare(this._fissionEventsPerFuelUnit, properties._fissionEventsPerFuelUnit) && 0 == Float.compare(this._fuelUnitsPerFissionEvent, properties._fuelUnitsPerFissionEvent);
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this._fuelModerationFactor), Float.valueOf(this._fuelAbsorptionCoefficient), Float.valueOf(this._fuelHardnessDivisor), Float.valueOf(this._fissionEventsPerFuelUnit), Float.valueOf(this._fuelUnitsPerFissionEvent));
    }
}

