/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.datagen.recipe;

import it.zerono.mods.extremereactors.datagen.recipe.AbstractRecipesDataProvider;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.ContentTags;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.ReactorVariant;
import it.zerono.mods.zerocore.lib.compat.Mods;
import it.zerono.mods.zerocore.lib.data.ResourceLocationBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class ReactorRecipesDataProvider
extends AbstractRecipesDataProvider {
    public ReactorRecipesDataProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registryLookup, ResourceLocationBuilder modLocationRoot) {
        super("bigreactors", "Reactor recipes", output, registryLookup, modLocationRoot);
    }

    protected void m_245200_(Consumer<FinishedRecipe> builder) {
        ReactorVariant variant = ReactorVariant.Basic;
        RegistryObject<BlockItem> casing = Content.Items.REACTOR_CASING_BASIC;
        TagKey core = Tags.Items.SAND;
        TagKey metal = Tags.Items.INGOTS_IRON;
        TagKey fallbackMetal = null;
        this.casing(builder, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_CASING_BASIC, (TagKey<Item>)core, (TagKey<Item>)metal, (TagKey<Item>)fallbackMetal);
        this.casingRecycle(builder, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_CASING_BASIC, ContentTags.Items.USING_REACTOR_CASING_BASIC, (Supplier<? extends ItemLike>)Content.Items.REACTOR_GLASS_BASIC);
        this.glass(builder, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_GLASS_BASIC, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)Tags.Items.GLASS);
        this.controller(builder, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_CONTROLLER_BASIC, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)Tags.Items.GEMS_DIAMOND);
        this.fuelRod(builder, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_FUELROD_BASIC, (TagKey<Item>)metal, (TagKey<Item>)fallbackMetal, (TagKey<Item>)Tags.Items.GLASS);
        this.controlRod(builder, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_CONTROLROD_BASIC, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)metal, (TagKey<Item>)fallbackMetal);
        this.solidAccessPort(builder, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_SOLID_ACCESSPORT_BASIC, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)metal, (TagKey<Item>)fallbackMetal);
        this.powerTap(builder, variant, "fe", (Supplier<? extends ItemLike>)Content.Items.REACTOR_POWERTAP_FE_PASSIVE_BASIC, (Supplier<? extends ItemLike>)Content.Items.REACTOR_POWERTAP_FE_ACTIVE_BASIC, (Supplier<? extends ItemLike>)casing, (Supplier<? extends ItemLike>)((Supplier<ItemLike>)() -> Items.f_42153_), (Supplier<? extends ItemLike>)((Supplier<ItemLike>)() -> Items.f_42451_));
        this.redstonePort(builder, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_REDSTONEPORT_BASIC, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)metal, (TagKey<Item>)fallbackMetal, (TagKey<Item>)Tags.Items.INGOTS_GOLD);
        this.chargingPort(builder, this.reactorRoot(variant).buildWithSuffix("chargingfe"), (Supplier<? extends ItemLike>)Content.Items.REACTOR_CHARGINGPORT_FE_BASIC, (Supplier<? extends ItemLike>)Content.Items.REACTOR_POWERTAP_FE_ACTIVE_BASIC, (ItemLike)Items.f_42534_, (ItemLike)Items.f_42451_);
        variant = ReactorVariant.Reinforced;
        casing = Content.Items.REACTOR_CASING_REINFORCED;
        core = Tags.Items.STORAGE_BLOCKS_IRON;
        metal = TAG_INGOTS_STEEL;
        fallbackMetal = Tags.Items.STORAGE_BLOCKS_IRON;
        this.casing(builder, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_CASING_REINFORCED, (TagKey<Item>)core, (TagKey<Item>)metal, (TagKey<Item>)fallbackMetal);
        this.casingUpgrade(builder, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_CASING_REINFORCED, (TagKey<Item>)metal, (TagKey<Item>)fallbackMetal);
        this.casingRecycle(builder, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_CASING_REINFORCED, ContentTags.Items.USING_REACTOR_CASING_REINFORCED, (Supplier<? extends ItemLike>)Content.Items.REACTOR_GLASS_REINFORCED);
        this.glass(builder, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_GLASS_REINFORCED, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)Tags.Items.GLASS);
        this.controller(builder, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_CONTROLLER_REINFORCED, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_DIAMOND);
        this.fuelRod(builder, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_FUELROD_REINFORCED, (TagKey<Item>)metal, (TagKey<Item>)fallbackMetal, (TagKey<Item>)Tags.Items.GLASS);
        this.controlRod(builder, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_CONTROLROD_REINFORCED, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)metal, (TagKey<Item>)fallbackMetal);
        this.solidAccessPort(builder, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_SOLID_ACCESSPORT_REINFORCED, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)metal, (TagKey<Item>)fallbackMetal);
        this.fluidAccessPort(builder, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_FLUID_ACCESSPORT_REINFORCED, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)metal, (TagKey<Item>)fallbackMetal);
        this.powerTap(builder, variant, "fe", (Supplier<? extends ItemLike>)Content.Items.REACTOR_POWERTAP_FE_PASSIVE_REINFORCED, (Supplier<? extends ItemLike>)Content.Items.REACTOR_POWERTAP_FE_ACTIVE_REINFORCED, (Supplier<? extends ItemLike>)casing, (Supplier<? extends ItemLike>)((Supplier<ItemLike>)() -> Items.f_42153_), (Supplier<? extends ItemLike>)((Supplier<ItemLike>)() -> Items.f_42451_));
        this.redstonePort(builder, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_REDSTONEPORT_REINFORCED, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)metal, (TagKey<Item>)fallbackMetal, (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_GOLD);
        this.computerPort(builder, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_COMPUTERPORT_REINFORCED, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)metal, (TagKey<Item>)fallbackMetal);
        this.fluidPort(builder, variant, "forge", (Supplier<? extends ItemLike>)Content.Items.REACTOR_FLUIDPORT_FORGE_PASSIVE_REINFORCED, (Supplier<? extends ItemLike>)Content.Items.REACTOR_FLUIDPORT_FORGE_ACTIVE_REINFORCED, (Supplier<? extends ItemLike>)casing, (Supplier<? extends ItemLike>)((Supplier<ItemLike>)() -> Items.f_42448_), (Supplier<? extends ItemLike>)((Supplier<ItemLike>)() -> Items.f_42447_));
        this.mekFluidPort(builder, variant, (Supplier<? extends ItemLike>)Content.Items.REACTOR_FLUIDPORT_MEKANISM_PASSIVE_REINFORCED, (Supplier<? extends ItemLike>)casing, (Supplier<? extends ItemLike>)((Supplier<ItemLike>)() -> Items.f_42448_), (Supplier<? extends ItemLike>)((Supplier<ItemLike>)() -> Items.f_42447_));
        this.chargingPort(builder, this.reactorRoot(variant).buildWithSuffix("chargingfe"), (Supplier<? extends ItemLike>)Content.Items.REACTOR_CHARGINGPORT_FE_REINFORCED, (Supplier<? extends ItemLike>)Content.Items.REACTOR_POWERTAP_FE_ACTIVE_REINFORCED, (ItemLike)Items.f_41854_, (ItemLike)Items.f_42153_);
    }

    private void casing(Consumer<FinishedRecipe> builder, ReactorVariant variant, Supplier<? extends ItemLike> result, TagKey<Item> core, TagKey<Item> metal, @Nullable TagKey<Item> fallbackMetal) {
        ResourceLocationBuilder idBuilder = this.reactorRoot(variant);
        this.withFallback(builder, idBuilder.buildWithSuffix("casing"), metal, idBuilder.buildWithSuffix("casing_alt"), fallbackMetal, tag -> this.shaped(RecipeCategory.BUILDING_BLOCKS, result).m_206416_(Character.valueOf('I'), tag).m_206416_(Character.valueOf('C'), core).m_206416_(Character.valueOf('G'), ContentTags.Items.INGOTS_GRAPHITE).m_126130_("IGI").m_126130_("GCG").m_126130_("IGI").m_126132_("has_item", (CriterionTriggerInstance)ReactorRecipesDataProvider.m_206406_(ContentTags.Items.INGOTS_GRAPHITE)));
    }

    private void casingUpgrade(Consumer<FinishedRecipe> builder, ReactorVariant variant, Supplier<? extends ItemLike> result, TagKey<Item> metal, @Nullable TagKey<Item> fallbackMetal) {
        ResourceLocationBuilder idBuilder = this.reactorRoot(variant);
        this.withFallback(builder, idBuilder.buildWithSuffix("casing_upgrade"), metal, idBuilder.buildWithSuffix("casing_upgrade_alt"), fallbackMetal, tag -> this.shaped(RecipeCategory.BUILDING_BLOCKS, result).m_206416_(Character.valueOf('I'), tag).m_126127_(Character.valueOf('C'), (ItemLike)Content.Blocks.REACTOR_CASING_BASIC.get()).m_206416_(Character.valueOf('G'), ContentTags.Items.INGOTS_GRAPHITE).m_126130_("IGI").m_126130_("GCG").m_126130_("IGI").m_126132_("has_item", (CriterionTriggerInstance)ReactorRecipesDataProvider.m_125977_((ItemLike)((ItemLike)Content.Blocks.REACTOR_CASING_BASIC.get()))));
    }

    private void casingRecycle(Consumer<FinishedRecipe> builder, ReactorVariant variant, Supplier<? extends ItemLike> casingResult, TagKey<Item> casingSourceTag, Supplier<? extends ItemLike> glassSourceItem) {
        ResourceLocationBuilder idBuilder = this.reactorRoot(variant);
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, casingResult).m_126209_(glassSourceItem.get()).m_126132_("has_item", (CriterionTriggerInstance)ReactorRecipesDataProvider.m_125977_((ItemLike)glassSourceItem.get())).m_126140_(builder, idBuilder.buildWithSuffix("casing_recycle_glass"));
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, casingResult, 4).m_206419_(casingSourceTag).m_126132_("has_item", (CriterionTriggerInstance)ReactorRecipesDataProvider.m_206406_(casingSourceTag)).m_126140_(builder, idBuilder.buildWithSuffix("casing_recycle"));
    }

    private void glass(Consumer<FinishedRecipe> builder, ReactorVariant variant, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> casing, TagKey<Item> glass) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, result).m_126127_(Character.valueOf('C'), casing.get()).m_206416_(Character.valueOf('G'), glass).m_126130_("GCG").m_126132_("has_item", (CriterionTriggerInstance)ReactorRecipesDataProvider.m_125977_((ItemLike)casing.get())).m_126140_(builder, this.reactorRoot(variant).buildWithSuffix("glass"));
    }

    private void controller(Consumer<FinishedRecipe> builder, ReactorVariant variant, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> casing, TagKey<Item> diamond) {
        TAGS_YELLORIUM_INGOTS.forEach(tag -> this.shaped(RecipeCategory.BUILDING_BLOCKS, result).m_126127_(Character.valueOf('C'), (ItemLike)casing.get()).m_206416_(Character.valueOf('Y'), tag).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('D'), diamond).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42351_).m_126130_("CXC").m_126130_("YDY").m_126130_("CRC").m_126132_("has_item", (CriterionTriggerInstance)ReactorRecipesDataProvider.m_125977_((ItemLike)((ItemLike)casing.get()))).m_126132_("has_item2", (CriterionTriggerInstance)ReactorRecipesDataProvider.m_206406_((TagKey)tag)).m_126140_(builder, this.nameForTaggedSubtype("controller", variant, (TagKey<Item>)tag)));
    }

    private void fuelRod(Consumer<FinishedRecipe> builder, ReactorVariant variant, Supplier<? extends ItemLike> result, TagKey<Item> metal, @Nullable TagKey<Item> fallbackMetal, TagKey<Item> glass) {
        TAGS_YELLORIUM_INGOTS.forEach(tag -> this.withFallback(builder, this.nameForTaggedSubtype("fuelrod", variant, (TagKey<Item>)tag), metal, this.nameForTaggedSubtype("fuelrod_alt", variant, (TagKey<Item>)tag), fallbackMetal, arg_0 -> this.lambda$fuelRod$11((Supplier)result, tag, glass, arg_0)));
    }

    private void controlRod(Consumer<FinishedRecipe> builder, ReactorVariant variant, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> casing, TagKey<Item> metal, @Nullable TagKey<Item> fallbackMetal) {
        ResourceLocationBuilder idBuilder = this.reactorRoot(variant);
        this.withFallback(builder, idBuilder.buildWithSuffix("controlrod"), metal, idBuilder.buildWithSuffix("controlrod_alt"), fallbackMetal, tag -> this.shaped(RecipeCategory.BUILDING_BLOCKS, result).m_126127_(Character.valueOf('C'), (ItemLike)casing.get()).m_206416_(Character.valueOf('M'), tag).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('G'), ContentTags.Items.INGOTS_GRAPHITE).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_41869_).m_126130_("CRC").m_126130_("MXM").m_126130_("CGC").m_126132_("has_item", (CriterionTriggerInstance)ReactorRecipesDataProvider.m_125977_((ItemLike)((ItemLike)casing.get()))));
    }

    private void powerTap(Consumer<FinishedRecipe> builder, ReactorVariant variant, String name, Supplier<? extends ItemLike> passiveResult, Supplier<? extends ItemLike> activeResult, Supplier<? extends ItemLike> casing, Supplier<? extends ItemLike> energyBig, Supplier<? extends ItemLike> energySmall) {
        ResourceLocationBuilder idBuilder = this.reactorRoot(variant).append(name);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, passiveResult).m_126127_(Character.valueOf('C'), casing.get()).m_126127_(Character.valueOf('B'), energyBig.get()).m_126127_(Character.valueOf('S'), energySmall.get()).m_126130_("CSC").m_126130_("SBS").m_126130_("CSC").m_126132_("has_item", (CriterionTriggerInstance)ReactorRecipesDataProvider.m_125977_((ItemLike)casing.get())).m_126132_("has_item2", (CriterionTriggerInstance)ReactorRecipesDataProvider.m_125977_((ItemLike)energySmall.get())).m_126140_(builder, idBuilder.buildWithPrefix("passivetap_"));
        this.shaped(RecipeCategory.BUILDING_BLOCKS, activeResult).m_126127_(Character.valueOf('C'), casing.get()).m_126127_(Character.valueOf('B'), energyBig.get()).m_126127_(Character.valueOf('S'), energySmall.get()).m_126130_("CBC").m_126130_("BSB").m_126130_("CBC").m_126132_("has_item", (CriterionTriggerInstance)ReactorRecipesDataProvider.m_125977_((ItemLike)casing.get())).m_126132_("has_item2", (CriterionTriggerInstance)ReactorRecipesDataProvider.m_125977_((ItemLike)energyBig.get())).m_126140_(builder, idBuilder.buildWithPrefix("activetap_"));
    }

    private void fluidPort(Consumer<FinishedRecipe> builder, ReactorVariant variant, String name, Supplier<? extends ItemLike> passiveResult, Supplier<? extends ItemLike> activeResult, Supplier<? extends ItemLike> casing, Supplier<? extends ItemLike> lava, Supplier<? extends ItemLike> water) {
        ResourceLocationBuilder idBuilder = this.reactorRoot(variant).append(name);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, passiveResult).m_126127_(Character.valueOf('C'), casing.get()).m_126127_(Character.valueOf('B'), lava.get()).m_126127_(Character.valueOf('S'), water.get()).m_126130_("CSC").m_126130_("SBS").m_126130_("CSC").m_126132_("has_item", (CriterionTriggerInstance)ReactorRecipesDataProvider.m_125977_((ItemLike)casing.get())).m_126132_("has_item2", (CriterionTriggerInstance)ReactorRecipesDataProvider.m_125977_((ItemLike)water.get())).m_126140_(builder, idBuilder.buildWithPrefix("passivefluidport_"));
        this.shaped(RecipeCategory.BUILDING_BLOCKS, activeResult).m_126127_(Character.valueOf('C'), casing.get()).m_126127_(Character.valueOf('B'), lava.get()).m_126127_(Character.valueOf('S'), water.get()).m_126130_("CBC").m_126130_("BSB").m_126130_("CBC").m_126132_("has_item", (CriterionTriggerInstance)ReactorRecipesDataProvider.m_125977_((ItemLike)casing.get())).m_126132_("has_item2", (CriterionTriggerInstance)ReactorRecipesDataProvider.m_125977_((ItemLike)lava.get())).m_126140_(builder, idBuilder.buildWithPrefix("activefluidport_"));
    }

    private void mekFluidPort(Consumer<FinishedRecipe> builder, ReactorVariant variant, Supplier<? extends ItemLike> passiveResult, Supplier<? extends ItemLike> casing, Supplier<? extends ItemLike> lava, Supplier<? extends ItemLike> water) {
        this.conditional(new ICondition[]{ReactorRecipesDataProvider.modLoaded((String)Mods.MEKANISM.id())}).addRecipe(arg_0 -> ((ShapedRecipeBuilder)this.shaped(RecipeCategory.BUILDING_BLOCKS, passiveResult).m_126127_(Character.valueOf('C'), casing.get()).m_126127_(Character.valueOf('B'), lava.get()).m_126127_(Character.valueOf('S'), water.get()).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42110_).m_126130_("CSC").m_126130_("BXB").m_126130_("CSC").m_126132_("has_item", (CriterionTriggerInstance)ReactorRecipesDataProvider.m_125977_((ItemLike)casing.get())).m_126132_("has_item2", (CriterionTriggerInstance)ReactorRecipesDataProvider.m_125977_((ItemLike)water.get()))).m_176498_(arg_0)).build(builder, this.reactorRoot(variant).buildWithSuffix("passivefluidport_mekanism"));
    }

    private void solidAccessPort(Consumer<FinishedRecipe> builder, ReactorVariant variant, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> casing, TagKey<Item> metal, @Nullable TagKey<Item> fallbackMetal) {
        ResourceLocationBuilder idBuilder = this.reactorRoot(variant);
        this.withFallback(builder, idBuilder.buildWithSuffix("solidaccessport"), metal, idBuilder.buildWithSuffix("solidaccessport_alt"), fallbackMetal, tag -> this.shaped(RecipeCategory.BUILDING_BLOCKS, result).m_126127_(Character.valueOf('C'), (ItemLike)casing.get()).m_206416_(Character.valueOf('M'), tag).m_126127_(Character.valueOf('H'), (ItemLike)Items.f_42155_).m_206416_(Character.valueOf('W'), Tags.Items.CHESTS_WOODEN).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_41869_).m_126130_("CHC").m_126130_("MWM").m_126130_("CXC").m_126132_("has_item", (CriterionTriggerInstance)ReactorRecipesDataProvider.m_125977_((ItemLike)((ItemLike)casing.get()))));
    }

    private void fluidAccessPort(Consumer<FinishedRecipe> builder, ReactorVariant variant, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> casing, TagKey<Item> metal, @Nullable TagKey<Item> fallbackMetal) {
        ResourceLocationBuilder idBuilder = this.reactorRoot(variant);
        this.withFallback(builder, idBuilder.buildWithSuffix("fluidaccessport"), metal, idBuilder.buildWithSuffix("fluidaccessport_alt"), fallbackMetal, tag -> this.shaped(RecipeCategory.BUILDING_BLOCKS, result).m_126127_(Character.valueOf('C'), (ItemLike)casing.get()).m_206416_(Character.valueOf('M'), tag).m_126127_(Character.valueOf('H'), (ItemLike)Items.f_42155_).m_126127_(Character.valueOf('W'), (ItemLike)Items.f_42446_).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_41869_).m_126130_("CHC").m_126130_("MWM").m_126130_("CXC").m_126132_("has_item", (CriterionTriggerInstance)ReactorRecipesDataProvider.m_125977_((ItemLike)((ItemLike)casing.get()))));
    }

    private void redstonePort(Consumer<FinishedRecipe> builder, ReactorVariant variant, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> casing, TagKey<Item> metal, @Nullable TagKey<Item> fallbackMetal, TagKey<Item> gold) {
        ResourceLocationBuilder idBuilder = this.reactorRoot(variant);
        this.withFallback(builder, idBuilder.buildWithSuffix("redstoneport"), metal, idBuilder.buildWithSuffix("redstoneport_alt"), fallbackMetal, tag -> this.shaped(RecipeCategory.BUILDING_BLOCKS, result).m_126127_(Character.valueOf('C'), (ItemLike)casing.get()).m_206416_(Character.valueOf('M'), tag).m_206416_(Character.valueOf('G'), gold).m_126127_(Character.valueOf('Z'), (ItemLike)Items.f_42351_).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42350_).m_126130_("CZC").m_126130_("MGM").m_126130_("CXC").m_126132_("has_item", (CriterionTriggerInstance)ReactorRecipesDataProvider.m_125977_((ItemLike)((ItemLike)casing.get()))));
    }

    private void computerPort(Consumer<FinishedRecipe> builder, ReactorVariant variant, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> casing, TagKey<Item> metal, @Nullable TagKey<Item> fallbackMetal) {
        ResourceLocationBuilder idBuilder = this.reactorRoot(variant);
        this.withFallback(builder, idBuilder.buildWithSuffix("computerport"), metal, idBuilder.buildWithSuffix("computerport_alt"), fallbackMetal, tag -> this.shaped(RecipeCategory.BUILDING_BLOCKS, result).m_126127_(Character.valueOf('C'), (ItemLike)casing.get()).m_206416_(Character.valueOf('M'), tag).m_206416_(Character.valueOf('G'), Tags.Items.STORAGE_BLOCKS_GOLD).m_206416_(Character.valueOf('Z'), Tags.Items.GEMS_LAPIS).m_206416_(Character.valueOf('X'), Tags.Items.DUSTS_GLOWSTONE).m_126130_("CZC").m_126130_("MGM").m_126130_("CXC").m_126132_("has_item", (CriterionTriggerInstance)ReactorRecipesDataProvider.m_125977_((ItemLike)((ItemLike)casing.get()))));
    }

    private ResourceLocation nameForTaggedSubtype(String baseName, ReactorVariant variant, TagKey<Item> tag) {
        return this.reactorRoot(variant).buildWithSuffix(baseName + "_" + tag.f_203868_().m_135815_().replace('/', '_'));
    }

    private /* synthetic */ ShapedRecipeBuilder lambda$fuelRod$11(Supplier result, TagKey tag, TagKey glass, TagKey metalTag) {
        return this.shaped(RecipeCategory.BUILDING_BLOCKS, result).m_206416_(Character.valueOf('M'), metalTag).m_206416_(Character.valueOf('Y'), tag).m_206416_(Character.valueOf('G'), ContentTags.Items.INGOTS_GRAPHITE).m_206416_(Character.valueOf('L'), glass).m_126130_("MGM").m_126130_("LYL").m_126130_("MGM").m_126132_("has_item", (CriterionTriggerInstance)ReactorRecipesDataProvider.m_206406_((TagKey)tag));
    }
}

