/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer;

import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.IFluidizerRecipeHolder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.FluidizerFluidMixingRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.FluidizerSolidMixingRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.FluidizerSolidRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.IFluidizerRecipe;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.recipe.ModRecipe;
import it.zerono.mods.zerocore.lib.recipe.holder.IHeldRecipe;
import it.zerono.mods.zerocore.lib.recipe.holder.IRecipeHolder;
import it.zerono.mods.zerocore.lib.recipe.holder.RecipeHolder;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.LogicalSide;

class FluidizerRecipeHolder<Recipe extends ModRecipe>
implements IFluidizerRecipeHolder {
    private final RecipeHolder<Recipe> _recipeHolder;
    private final IFluidizerRecipe.Type _recipeType;

    public static IFluidizerRecipeHolder solid(IFluidizerRecipeHolder.Callbacks callbacks, Function<IRecipeHolder<FluidizerSolidRecipe>, IHeldRecipe<FluidizerSolidRecipe>> factory) {
        return new FluidizerRecipeHolder(IFluidizerRecipe.Type.Solid, RecipeHolder.builder(factory, recipe -> recipe.getRecipeType().getTicks()).onHasIngredientsChanged(callbacks::hasIngredientsChanged).onRecipeTickProcessed(callbacks::onRecipeTickProcessed).onCanProcess(callbacks::canProcessRecipe).onRecipeChanged(callbacks::onRecipeChanged).build());
    }

    public static IFluidizerRecipeHolder solidMixing(IFluidizerRecipeHolder.Callbacks callbacks, Function<IRecipeHolder<FluidizerSolidMixingRecipe>, IHeldRecipe<FluidizerSolidMixingRecipe>> factory) {
        return new FluidizerRecipeHolder(IFluidizerRecipe.Type.SolidMixing, RecipeHolder.builder(factory, recipe -> recipe.getRecipeType().getTicks()).onHasIngredientsChanged(callbacks::hasIngredientsChanged).onRecipeTickProcessed(callbacks::onRecipeTickProcessed).onCanProcess(callbacks::canProcessRecipe).onRecipeChanged(callbacks::onRecipeChanged).build());
    }

    public static IFluidizerRecipeHolder fluidMixing(IFluidizerRecipeHolder.Callbacks callbacks, Function<IRecipeHolder<FluidizerFluidMixingRecipe>, IHeldRecipe<FluidizerFluidMixingRecipe>> factory) {
        return new FluidizerRecipeHolder(IFluidizerRecipe.Type.FluidMixing, RecipeHolder.builder(factory, recipe -> recipe.getRecipeType().getTicks()).onHasIngredientsChanged(callbacks::hasIngredientsChanged).onRecipeTickProcessed(callbacks::onRecipeTickProcessed).onCanProcess(callbacks::canProcessRecipe).onRecipeChanged(callbacks::onRecipeChanged).build());
    }

    @Override
    public IFluidizerRecipe.Type getRecipeType() {
        return this._recipeType;
    }

    @Override
    public double getProgress() {
        return this._recipeHolder.getHeldRecipe().map(IHeldRecipe::getProgress).orElse(0.0);
    }

    @Override
    public int getCurrentTick() {
        return this._recipeHolder.getHeldRecipe().map(IHeldRecipe::getCurrentTick).orElse(-1);
    }

    @Override
    public boolean processRecipe() {
        return this._recipeHolder.getCurrentRecipe().map(IHeldRecipe::processRecipe).orElse(false);
    }

    @Override
    public void refresh() {
        this._recipeHolder.refresh();
    }

    @Override
    public int getEnergyUsageMultiplier() {
        return this._recipeHolder.getCurrentRecipe().map(held -> ((IFluidizerRecipe)held.getRecipe()).getEnergyUsageMultiplier()).orElse(1);
    }

    @Override
    public boolean isValidIngredient(ItemStack stack) {
        return Content.Recipes.FLUIDIZER_RECIPE_TYPE.findFirst(recipe -> {
            if (recipe instanceof FluidizerSolidRecipe) {
                return ((FluidizerSolidRecipe)recipe).matchIgnoreAmount(stack);
            }
            if (recipe instanceof FluidizerSolidMixingRecipe) {
                return ((FluidizerSolidMixingRecipe)recipe).matchIgnoreAmount(stack);
            }
            return false;
        }).isPresent();
    }

    @Override
    public boolean isValidIngredient(FluidStack stack) {
        return Content.Recipes.FLUIDIZER_RECIPE_TYPE.findFirst(recipe -> {
            if (recipe instanceof FluidizerFluidMixingRecipe) {
                return ((FluidizerFluidMixingRecipe)recipe).matchIgnoreAmount(stack);
            }
            return false;
        }).isPresent();
    }

    public void syncDataFrom(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        this._recipeHolder.refresh();
        this.syncChildDataEntityFrom((ISyncableEntity)this._recipeHolder, "recipe", data, syncReason);
    }

    public CompoundTag syncDataTo(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        this.syncChildDataEntityTo((ISyncableEntity)this._recipeHolder, "recipe", data, syncReason);
        return data;
    }

    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        messages.addUnlocalized("Current tick %d", new Object[]{this._recipeHolder.getHeldRecipe().map(IHeldRecipe::getCurrentTick).orElse(-1)});
    }

    protected FluidizerRecipeHolder(IFluidizerRecipe.Type recipeType, RecipeHolder<Recipe> holder) {
        this._recipeHolder = holder;
        this._recipeType = recipeType;
    }
}

