/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.client.model;

import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.FluidizerPartType;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartType;
import it.zerono.mods.zerocore.lib.client.model.multiblock.CuboidPartVariantsModelBuilder;
import java.util.function.Function;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;

public class FluidizerModelBuilder
extends CuboidPartVariantsModelBuilder {
    public FluidizerModelBuilder() {
        this("assembledplating");
    }

    protected FluidizerModelBuilder(String templateName) {
        super(FluidizerModelBuilder.getModelRL(templateName), true);
        this.build();
    }

    protected void build() {
        Function<String, ResourceLocation> modelToReplaceIdGetter = blockName -> new ModelResourceLocation(ExtremeReactors.ROOT_LOCATION.buildWithSuffix("fluidizer" + blockName), "");
        Function<String, ResourceLocation> variantModelIdGetter = FluidizerModelBuilder::getModelRL;
        this.addBlockWithVariants(modelToReplaceIdGetter, variantModelIdGetter, (IMultiblockPartType)FluidizerPartType.Casing, "casing", new String[]{"casing_01_face", "casing_02_frame_ds", "casing_03_frame_de", "casing_04_frame_dn", "casing_05_frame_dw", "casing_06_frame_us", "casing_07_frame_ue", "casing_08_frame_un", "casing_09_frame_uw", "casing_10_frame_se", "casing_11_frame_ne", "casing_12_frame_nw", "casing_13_frame_sw", "casing_14_corner_dsw", "casing_15_corner_dse", "casing_16_corner_dne", "casing_17_corner_dnw", "casing_18_corner_usw", "casing_19_corner_use", "casing_20_corner_une", "casing_21_corner_unw"});
        this.addBlockWithVariants(modelToReplaceIdGetter, variantModelIdGetter, (IMultiblockPartType)FluidizerPartType.Controller, "controller", new String[]{"controller_on", "controller_off"});
        this.addBlockWithVariants(modelToReplaceIdGetter, variantModelIdGetter, (IMultiblockPartType)FluidizerPartType.PowerPort, "powerport", new String[0]);
        this.addBlockWithVariants(modelToReplaceIdGetter, variantModelIdGetter, (IMultiblockPartType)FluidizerPartType.SolidInjector, "solidinjector", new String[]{"solidinjector_connected"});
        this.addBlockWithVariants(modelToReplaceIdGetter, variantModelIdGetter, (IMultiblockPartType)FluidizerPartType.FluidInjector, "fluidinjector", new String[]{"fluidinjector_connected"});
        this.addBlockWithVariants(modelToReplaceIdGetter, variantModelIdGetter, (IMultiblockPartType)FluidizerPartType.OutputPort, "outputport", new String[]{"outputport_connected"});
    }

    protected static ResourceLocation getModelRL(String modelName) {
        return ExtremeReactors.ROOT_LOCATION.appendPath(new String[]{"block", "fluidizer"}).buildWithSuffix(modelName);
    }
}

