/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen.control;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CommonIcons;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen.control.HeatBar;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen.control.ReactantBar;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.container.IReactorControllerContainer;
import it.zerono.mods.zerocore.base.client.screen.BaseScreenToolTipsBuilder;
import it.zerono.mods.zerocore.base.client.screen.ClientBaseHelper;
import it.zerono.mods.zerocore.base.client.screen.control.BarsPanel;
import it.zerono.mods.zerocore.base.client.screen.control.CommonPanels;
import it.zerono.mods.zerocore.base.client.screen.control.EnergyBar;
import it.zerono.mods.zerocore.base.client.screen.control.FluidBar;
import it.zerono.mods.zerocore.base.client.screen.control.InformationDisplay;
import it.zerono.mods.zerocore.base.client.screen.control.OnOff;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.ButtonState;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.ToolTipsBuilder;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractButtonControl;
import it.zerono.mods.zerocore.lib.client.gui.control.Button;
import it.zerono.mods.zerocore.lib.client.gui.control.Panel;
import it.zerono.mods.zerocore.lib.client.gui.control.SwitchPictureButton;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IBindableData;
import it.zerono.mods.zerocore.lib.text.TextHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.common.util.NonNullSupplier;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;

public class ReactorControllerPanel
extends Panel {
    private static final MutableComponent TEXT_AUTOMATIC_WASTE_EJECT = TextHelper.translatable((String)"gui.bigreactors.reactor.controller.wasteeject.mode.automatic", ClientBaseHelper::formatAsValue);
    private static final MutableComponent TEXT_MANUAL_WASTE_EJECT = TextHelper.translatable((String)"gui.bigreactors.reactor.controller.wasteeject.mode.manual", ClientBaseHelper::formatAsValue);

    public ReactorControllerPanel(ModContainerScreen<? extends ModContainer> gui, int width, int height, IReactorControllerContainer container, BooleanConsumer onActiveStateChanged, BooleanConsumer onWasteEjectionChanged, @Nullable Runnable onVoidReactants, @Nullable Runnable onScram, TriConsumer<AbstractButtonControl, ButtonState, NonNullSupplier<ISprite>> setButtonSpritesAndOverlayForState) {
        super(gui);
        HeatBar coreHeatBar = ReactorControllerPanel.coreHeatBar(gui, container);
        BarsPanel barsPanel = new BarsPanel(gui, "bars").add((IControl)ReactorControllerPanel.fuelBar(gui, container)).addVerticalSeparator().add((IControl)coreHeatBar).addTemperatureScale().add((IControl)ReactorControllerPanel.casingHeatBar(gui, container)).addVerticalSeparator();
        if (container.getReactorMode().isPassive()) {
            barsPanel.add((IControl)ReactorControllerPanel.energyBar(gui, container)).addEmptyPanel(29);
        } else {
            NonNullSupplier fluidCapacityText = container.fluidCapacity().asBindableText(capacity -> TextHelper.literal((String)CodeHelper.formatAsHumanReadableNumber((long)(capacity / 1000), (String)"B"), ClientBaseHelper::formatAsValue));
            barsPanel.add((IControl)ReactorControllerPanel.coolantBar(gui, container, (NonNullSupplier<Component>)fluidCapacityText)).addTemperatureScale().add((IControl)ReactorControllerPanel.vaporBar(gui, container, (NonNullSupplier<Component>)fluidCapacityText));
        }
        barsPanel.addVerticalSeparator();
        barsPanel.add((IControl)ReactorControllerPanel.commandPanel(gui, container, onActiveStateChanged, onWasteEjectionChanged, onVoidReactants, onScram, setButtonSpritesAndOverlayForState));
        this.setDesiredDimension(width, height);
        this.setLayoutEngine((ILayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)new VerticalLayoutEngine().setZeroMargins()).setControlsSpacing(2)).setVerticalAlignment(VerticalAlignment.Top)).setHorizontalAlignment(HorizontalAlignment.Left));
        this.addControl((IControl)barsPanel);
        this.addControl((IControl)CommonPanels.horizontalSeparator(gui, (int)(width - 1)));
        this.addControl((IControl)ReactorControllerPanel.infoDisplay(gui, container, coreHeatBar));
    }

    private static ReactantBar fuelBar(ModContainerScreen<? extends ModContainer> gui, IReactorControllerContainer container) {
        return new ReactantBar(gui, "fuelBar", container.reactantCapacity(), container.fuelStack(), container.wasteStack(), container.fuelRodsCount());
    }

    private static HeatBar coreHeatBar(ModContainerScreen<? extends ModContainer> gui, IReactorControllerContainer container) {
        return new HeatBar(gui, "coreHeatBar", 2000.0, container.coreHeat(), CommonIcons.ButtonSensorOutputFuelTemperature, "gui.bigreactors.reactor.controller.coreheatbar.tooltip.title", "gui.bigreactors.reactor.controller.coreheatbar.tooltip.value", "gui.bigreactors.reactor.controller.coreheatbar.tooltip.body");
    }

    private static HeatBar casingHeatBar(ModContainerScreen<? extends ModContainer> gui, IReactorControllerContainer container) {
        return new HeatBar(gui, "casingHeatBar", 2000.0, container.casingHeat(), CommonIcons.ButtonSensorOutputCasingTemperature, "gui.bigreactors.reactor.controller.casingheatbar.tooltip.title", "gui.bigreactors.reactor.controller.casingheatbar.tooltip.value", "gui.bigreactors.reactor.controller.casingheatbar.tooltip.body");
    }

    private static EnergyBar energyBar(ModContainerScreen<? extends ModContainer> gui, IReactorControllerContainer container) {
        EnergyBar bar = new EnergyBar(gui, "energyBar", container.getOutputEnergySystem(), WideAmount.ZERO, container.energyStored(), "gui.bigreactors.reactor_turbine.controller.energybar.tooltip.body");
        bar.bindMaxValue(container.energyCapacity());
        return bar;
    }

    private static FluidBar coolantBar(ModContainerScreen<? extends ModContainer> gui, IReactorControllerContainer container, NonNullSupplier<Component> fluidCapacityText) {
        FluidBar coolantBar = new FluidBar(gui, "coolantBar", 0, container.coolantStack(), (NonNullSupplier)CommonIcons.CoolantIcon);
        coolantBar.bindMaxValue(container.fluidCapacity());
        coolantBar.setTooltips((ToolTipsBuilder)new BaseScreenToolTipsBuilder().addTranslatableAsTitle("gui.bigreactors.reactor.controller.coolantbar.tooltip.title").addTranslatableAsValue("gui.bigreactors.reactor.controller.coolantbar.tooltip.value1").addTextAsValue(TextHelper.translatable((String)"gui.bigreactors.reactor.controller.coolantbar.tooltip.value2a"), new Component[]{TextHelper.translatable((String)"gui.bigreactors.reactor.controller.coolantbar.tooltip.value2b")}).addTextAsValue(TextHelper.translatable((String)"gui.bigreactors.reactor.controller.coolantbar.tooltip.value3a"), new Component[]{TextHelper.translatable((String)"gui.bigreactors.reactor.controller.coolantbar.tooltip.value3b")}).addEmptyLine().addTranslatable("gui.bigreactors.reactor.controller.coolantbar.tooltip.body").addBindableObjectAsValue((IBindableData)container.coolantStack(), arg_0 -> ((FluidBar)coolantBar).formatFluidText(arg_0)).addBindableObjectAsValue(container.coolantStack().amount(), arg_0 -> ((FluidBar)coolantBar).formatAmountText(arg_0)).addObject(fluidCapacityText).addBindableObjectAsValue(container.coolantStack().amount(), arg_0 -> ((FluidBar)coolantBar).formatPercentageText(arg_0)));
        return coolantBar;
    }

    private static FluidBar vaporBar(ModContainerScreen<? extends ModContainer> gui, IReactorControllerContainer container, NonNullSupplier<Component> fluidCapacityText) {
        FluidBar vaporBar = new FluidBar(gui, "vaporBar", 0, container.vaporStack(), (NonNullSupplier)CommonIcons.VaporIcon);
        vaporBar.bindMaxValue(container.fluidCapacity());
        vaporBar.setTooltips((ToolTipsBuilder)new BaseScreenToolTipsBuilder().addTranslatableAsTitle("gui.bigreactors.reactor.controller.vaporbar.tooltip.title").addTranslatableAsValue("gui.bigreactors.reactor.controller.vaporbar.tooltip.value1").addTextAsValue(TextHelper.translatable((String)"gui.bigreactors.reactor.controller.vaporbar.tooltip.value2a"), new Component[]{TextHelper.translatable((String)"gui.bigreactors.reactor.controller.vaporbar.tooltip.value2b")}).addTextAsValue(TextHelper.translatable((String)"gui.bigreactors.reactor.controller.vaporbar.tooltip.value3a"), new Component[]{TextHelper.translatable((String)"gui.bigreactors.reactor.controller.vaporbar.tooltip.value3b")}).addEmptyLine().addTranslatable("gui.bigreactors.reactor.controller.vaporbar.tooltip.body").addBindableObjectAsValue((IBindableData)container.vaporStack(), arg_0 -> ((FluidBar)vaporBar).formatFluidText(arg_0)).addBindableObjectAsValue(container.vaporStack().amount(), arg_0 -> ((FluidBar)vaporBar).formatAmountText(arg_0)).addObject(fluidCapacityText).addBindableObjectAsValue(container.vaporStack().amount(), arg_0 -> ((FluidBar)vaporBar).formatPercentageText(arg_0)));
        return vaporBar;
    }

    private static Panel commandPanel(ModContainerScreen<? extends ModContainer> gui, IReactorControllerContainer container, BooleanConsumer onActiveStateChanged, BooleanConsumer onWasteEjectionChanged, @Nullable Runnable onVoidReactants, @Nullable Runnable onScram, TriConsumer<AbstractButtonControl, ButtonState, NonNullSupplier<ISprite>> setButtonSpritesAndOverlayForState) {
        Button button;
        Panel commandPanel = CommonPanels.verticalCommandPanel(gui, (int)50);
        commandPanel.setLayoutEngine((ILayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)new VerticalLayoutEngine().setZeroMargins()).setControlsSpacing(3)).setVerticalAlignment(VerticalAlignment.Top)).setHorizontalAlignment(HorizontalAlignment.Center));
        OnOff onOff = new OnOff(gui, (IBindableData)container.active(), btn -> onActiveStateChanged.accept(btn.getActive()), (Component)TextHelper.translatable((String)"gui.bigreactors.reactor.controller.on.title"), (Component)TextHelper.translatable((String)"gui.bigreactors.reactor.controller.off.title"));
        commandPanel.addControl((IControl)onOff);
        if (null != onVoidReactants) {
            button = new Button(gui, "voidreactants", "");
            button.Clicked.subscribe((btn, $) -> onVoidReactants.run());
            button.setIconForState(CommonIcons.TrashCan.get(), ButtonState.Default);
            button.enablePaintBlending(true);
            button.setPadding(1);
            button.setDesiredDimension(18, 18);
            button.setTooltips((ToolTipsBuilder)new BaseScreenToolTipsBuilder().addTranslatableAsTitle("gui.bigreactors.reactor.controller.voidreactants.tooltip.title").addEmptyLine().addTranslatable("gui.bigreactors.reactor.controller.voidreactants.tooltip.body"));
            commandPanel.addControl((IControl)button);
        }
        SwitchPictureButton wasteEjectionSettings = new SwitchPictureButton(gui, "wasteeject", false);
        wasteEjectionSettings.Activated.subscribe(btn -> onWasteEjectionChanged.accept(btn.getActive()));
        wasteEjectionSettings.Deactivated.subscribe(btn -> onWasteEjectionChanged.accept(btn.getActive()));
        setButtonSpritesAndOverlayForState.accept((Object)wasteEjectionSettings, (Object)ButtonState.Default, (Object)CommonIcons.ButtonDumpWaste);
        setButtonSpritesAndOverlayForState.accept((Object)wasteEjectionSettings, (Object)ButtonState.Active, (Object)CommonIcons.ButtonDumpWasteActive);
        wasteEjectionSettings.setBackground(CommonIcons.ImageButtonBackground.get());
        wasteEjectionSettings.enablePaintBlending(true);
        wasteEjectionSettings.setPadding(1);
        wasteEjectionSettings.setDesiredDimension(18, 18);
        wasteEjectionSettings.setTooltips((ToolTipsBuilder)new BaseScreenToolTipsBuilder().addTranslatableAsTitle("gui.bigreactors.reactor.controller.wasteeject.tooltip.title").addTranslatableAsValue("gui.bigreactors.reactor.controller.wasteeject.tooltip.value").addEmptyLine().addTranslatable("gui.bigreactors.reactor.controller.wasteeject.tooltip.body").addBindableObjectAsValue(container.wasteEjectionSetting(), settings -> settings.isAutomatic() ? TEXT_AUTOMATIC_WASTE_EJECT : TEXT_MANUAL_WASTE_EJECT));
        container.wasteEjectionSetting().bind(settings -> wasteEjectionSettings.setActive(settings.isAutomatic()));
        commandPanel.addControl((IControl)wasteEjectionSettings);
        if (null != onScram) {
            button = new Button(gui, "scram", "SCRAM");
            button.Clicked.subscribe((btn, $) -> onScram.run());
            button.setTooltips((ToolTipsBuilder)new BaseScreenToolTipsBuilder().addTranslatableAsTitle("gui.bigreactors.reactor.controller.scram.tooltip.title").addEmptyLine().addTranslatable("gui.bigreactors.reactor.controller.scram.tooltip.body"));
            button.setDesiredDimension(50, 25);
            commandPanel.addControl((IControl)button);
        }
        return commandPanel;
    }

    private static InformationDisplay infoDisplay(ModContainerScreen<? extends ModContainer> gui, IReactorControllerContainer container, HeatBar coreHeatBar) {
        InformationDisplay infoDisplay = new InformationDisplay(gui, "info", layout -> layout.columns(2, new int[]{88, 107}).rows(3));
        infoDisplay.addInformationCell(builder -> builder.name("coreHeat").bindText((IBindableData)container.coreHeat(), heat -> String.format("%.0f C", heat)).icon((NonNullSupplier)CommonIcons.TemperatureIcon).useTooltipsFrom((IControl)coreHeatBar));
        if (container.getReactorMode().isPassive()) {
            infoDisplay.addInformationCell(builder -> builder.name("energyRatio").bindText((IBindableData)container.generatedLastTick(), generated -> CodeHelper.formatAsHumanReadableNumber((double)generated, (String)(container.getOutputEnergySystem().getUnit() + "/t"))).icon((NonNullSupplier)CommonIcons.EnergyRatioIcon).tooltips(new BaseScreenToolTipsBuilder().addTranslatableAsTitle("gui.bigreactors.reactor.controller.energyratio.tooltip.title").addTranslatableAsValue("gui.bigreactors.reactor.controller.energyratio.tooltip.value").addEmptyLine().addTranslatable("gui.bigreactors.reactor.controller.energyratio.tooltip.body").addBindableObjectAsValue((IBindableData)container.generatedLastTick(), generated -> TextHelper.literal((String)CodeHelper.formatAsHumanReadableNumber((double)generated, (String)(container.getOutputEnergySystem().getUnit() + "/t"))))));
        } else {
            infoDisplay.addInformationCell(builder -> builder.name("vaporRatio").bindText((IBindableData)container.generatedLastTick(), generated -> CodeHelper.formatAsHumanReadableNumber((double)(generated / 1000.0), (String)"B/t")).icon((NonNullSupplier)CommonIcons.VaporIcon).tooltips(new BaseScreenToolTipsBuilder().addTranslatableAsTitle("gui.bigreactors.reactor.controller.vaporratio.tooltip.title").addTranslatableAsValue("gui.bigreactors.reactor.controller.vaporratio.tooltip.value").addEmptyLine().addTranslatable("gui.bigreactors.reactor.controller.vaporratio.tooltip.body").addBindableObjectAsValue((IBindableData)container.generatedLastTick(), generated -> TextHelper.literal((String)CodeHelper.formatAsHumanReadableNumber((double)(generated / 1000.0), (String)"B/t")))));
        }
        infoDisplay.addInformationCell(builder -> builder.name("fuelusage").bindText((IBindableData)container.fuelConsumedLastTick(), consumed -> CodeHelper.formatAsMillibuckets((float)consumed.floatValue()) + "/t").icon((NonNullSupplier)CommonIcons.FuelMix).tooltips(new BaseScreenToolTipsBuilder().addTranslatableAsTitle("gui.bigreactors.reactor.controller.fuelusage.tooltip.title").addEmptyLine().addTranslatable("gui.bigreactors.reactor.controller.fuelusage.tooltip.body")));
        infoDisplay.addEmptyCell();
        infoDisplay.addInformationCell(builder -> builder.name("fuelRichness").bindText((IBindableData)container.fuelRichness(), richness -> String.format("%2.0f%%", Float.valueOf(richness.floatValue() * 100.0f))).icon((NonNullSupplier)CommonIcons.ReactivityIcon).tooltips(new BaseScreenToolTipsBuilder().addTranslatableAsTitle("gui.bigreactors.reactor.controller.fuelrichness.tooltip.title").addEmptyLine().addTranslatable("gui.bigreactors.reactor.controller.fuelrichness.tooltip.body")));
        return infoDisplay;
    }
}

