/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.sensor;

import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IReactorReader;
import it.zerono.mods.zerocore.base.redstone.sensor.ISensorType;
import it.zerono.mods.zerocore.base.redstone.sensor.SensorBehavior;
import it.zerono.mods.zerocore.base.redstone.sensor.SensorTypeData;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import it.zerono.mods.zerocore.lib.IMachineReader;
import it.zerono.mods.zerocore.lib.functional.NonNullToIntFunction;
import java.util.List;
import net.minecraftforge.fml.LogicalSide;

public enum ReactorSensorType implements ISensorType<IReactorReader>,
IDebuggable
{
    Disabled(SensorBehavior.Disabled),
    inputActive(SensorBehavior.SetFromSignal, SensorBehavior.ToggleOnPulse),
    inputSetControlRod(SensorBehavior.SetFromSignal, SensorBehavior.SetFromSignalLevel, SensorBehavior.SetOnPulse, SensorBehavior.AugmentOnPulse, SensorBehavior.ReduceOnPulse),
    inputEjectWaste(SensorBehavior.PerformOnPulse),
    outputFuelTemperature((NonNullToIntFunction<IReactorReader>)((NonNullToIntFunction)r -> (int)r.getFuelHeatValue().getAsDouble()), SensorBehavior.ActiveWhileAbove, SensorBehavior.ActiveWhileBelow, SensorBehavior.ActiveWhileBetween),
    outputCasingTemperature((NonNullToIntFunction<IReactorReader>)((NonNullToIntFunction)r -> (int)r.getReactorHeatValue().getAsDouble()), SensorBehavior.ActiveWhileAbove, SensorBehavior.ActiveWhileBelow, SensorBehavior.ActiveWhileBetween),
    outputFuelRichness((NonNullToIntFunction<IReactorReader>)((NonNullToIntFunction)r -> (int)(r.getUiStats().getFuelRichness() * 100.0f)), SensorBehavior.ActiveWhileAbove, SensorBehavior.ActiveWhileBelow, SensorBehavior.ActiveWhileBetween),
    outputFuelAmount((NonNullToIntFunction<IReactorReader>)((NonNullToIntFunction)IReactorReader::getFuelAmount), SensorBehavior.ActiveWhileAbove, SensorBehavior.ActiveWhileBelow, SensorBehavior.ActiveWhileBetween),
    outputWasteAmount((NonNullToIntFunction<IReactorReader>)((NonNullToIntFunction)IReactorReader::getWasteAmount), SensorBehavior.ActiveWhileAbove, SensorBehavior.ActiveWhileBelow, SensorBehavior.ActiveWhileBetween),
    outputEnergyAmount((NonNullToIntFunction<IReactorReader>)((NonNullToIntFunction)r -> (int)(r.getEnergyStoredPercentage() * 100.0)), SensorBehavior.ActiveWhileAbove, SensorBehavior.ActiveWhileBelow, SensorBehavior.ActiveWhileBetween),
    outputCoolantAmount((NonNullToIntFunction<IReactorReader>)((NonNullToIntFunction)IReactorReader::getCoolantAmount), SensorBehavior.ActiveWhileAbove, SensorBehavior.ActiveWhileBelow, SensorBehavior.ActiveWhileBetween),
    outputVaporAmount((NonNullToIntFunction<IReactorReader>)((NonNullToIntFunction)IReactorReader::getVaporAmount), SensorBehavior.ActiveWhileAbove, SensorBehavior.ActiveWhileBelow, SensorBehavior.ActiveWhileBetween);

    private final SensorTypeData<IReactorReader> _data;
    private final String _translationBaseName;

    private ReactorSensorType(SensorBehavior ... behaviors) {
        this((SensorTypeData<IReactorReader>)SensorTypeData.input((SensorBehavior[])behaviors));
    }

    private ReactorSensorType(NonNullToIntFunction<IReactorReader> outputSupplier, SensorBehavior ... behaviors) {
        this((SensorTypeData<IReactorReader>)SensorTypeData.output(outputSupplier, (SensorBehavior[])behaviors));
    }

    public boolean isDisabled() {
        return Disabled == this;
    }

    public boolean isInput() {
        return this._data.isInput();
    }

    public boolean isOutput() {
        return this._data.isOutput();
    }

    public List<SensorBehavior> getBehaviors() {
        return this._data.getBehaviors();
    }

    public int applyAsInt(IReactorReader reader) {
        return this._data.applyAsInt((IMachineReader)reader);
    }

    public String getTranslationBaseName() {
        return this._translationBaseName;
    }

    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        messages.addUnlocalized("Reactor Sensor Type: %1$s", new Object[]{this});
    }

    private ReactorSensorType(SensorTypeData<IReactorReader> _data) {
        this._data = _data;
        this._translationBaseName = "gui.bigreactors.reactor.redstoneport.sensortype." + CodeHelper.neutralLowercase((String)this.name());
    }
}

