/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.icetower;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.world.components.structures.TFStructureComponent;
import twilightforest.world.components.structures.icetower.IceTowerStairsComponent;
import twilightforest.world.components.structures.icetower.IceTowerWingComponent;

public class IceTowerEntranceComponent
extends IceTowerWingComponent {
    public IceTowerEntranceComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super((StructurePieceType)TFStructurePieceTypes.TFITEnt.get(), nbt);
    }

    public IceTowerEntranceComponent(int i, int x, int y, int z, int pSize, int pHeight, Direction direction) {
        super((StructurePieceType)TFStructurePieceTypes.TFITEnt.get(), i, x, y, z, pSize, pHeight, direction);
    }

    @Override
    protected boolean shouldHaveBase(RandomSource rand) {
        return true;
    }

    @Override
    public void m_214092_(StructurePiece parent, StructurePieceAccessor list, RandomSource rand) {
        if (parent != null && parent instanceof TFStructureComponent) {
            TFStructureComponent tfStructureComponent = (TFStructureComponent)parent;
            this.deco = tfStructureComponent.deco;
        }
        this.addOpening(0, 1, this.size / 2, Rotation.CLOCKWISE_180);
        this.addStairs(list, rand, this.m_73548_() + 1, this.size - 1, 1, this.size / 2, Rotation.NONE);
        this.addStairs(list, rand, this.m_73548_() + 1, this.size / 2, 1, 0, Rotation.COUNTERCLOCKWISE_90);
        this.addStairs(list, rand, this.m_73548_() + 1, this.size / 2, 1, this.size - 1, Rotation.CLOCKWISE_90);
        this.hasBase = this.shouldHaveBase(rand);
        this.makeARoof(parent, list, rand);
    }

    private boolean addStairs(StructurePieceAccessor list, RandomSource rand, int index, int x, int y, int z, Rotation rotation) {
        this.addOpening(x, y, z, rotation);
        Direction direction = this.getStructureRelativeRotation(rotation);
        BlockPos dx = this.offsetTowerCCoords(x, y, z, this.size, direction);
        IceTowerStairsComponent entrance = new IceTowerStairsComponent(index, dx.m_123341_(), dx.m_123342_(), dx.m_123343_(), this.size, this.height, direction);
        list.m_142679_((StructurePiece)entrance);
        entrance.m_214092_(this, list, rand);
        return true;
    }

    @Override
    public boolean makeTowerWing(StructurePieceAccessor list, RandomSource rand, int index, int x, int y, int z, int wingSize, int wingHeight, Rotation rotation) {
        return false;
    }

    @Override
    protected void makeFloorsForTower(WorldGenLevel world, RandomSource rand, BoundingBox sbb) {
        this.decoratePillarsCornersHigh(world, 0, 11, Rotation.NONE, sbb);
    }

    protected void decoratePillarsCornersHigh(WorldGenLevel world, int bottom, int top, Rotation rotation, BoundingBox sbb) {
        BlockState pillarXAxis = (BlockState)this.deco.pillarState.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X);
        BlockState pillarZAxis = (BlockState)this.deco.pillarState.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z);
        this.fillBlocksRotated(world, sbb, 3, bottom + 5, 1, 3, bottom + 5, 9, pillarZAxis, rotation);
        this.fillBlocksRotated(world, sbb, 7, bottom + 5, 1, 7, bottom + 5, 9, pillarZAxis, rotation);
        this.fillBlocksRotated(world, sbb, 1, bottom + 5, 3, 9, bottom + 5, 3, pillarXAxis, rotation);
        this.fillBlocksRotated(world, sbb, 1, bottom + 5, 7, 9, bottom + 5, 7, pillarXAxis, rotation);
        this.fillAirRotated(world, sbb, 3, bottom + 5, 3, 7, bottom + 5, 7, rotation);
        this.fillBlocksRotated(world, sbb, 3, bottom + 5, 3, 3, top - 1, 3, this.deco.pillarState, rotation);
        this.fillBlocksRotated(world, sbb, 7, bottom + 5, 3, 7, top - 1, 3, this.deco.pillarState, rotation);
        this.fillBlocksRotated(world, sbb, 3, bottom + 5, 7, 3, top - 1, 7, this.deco.pillarState, rotation);
        this.fillBlocksRotated(world, sbb, 7, bottom + 5, 7, 7, top - 1, 7, this.deco.pillarState, rotation);
    }
}

