/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.advancements;

import com.google.gson.JsonObject;
import mods.railcraft.advancements.MinecartPredicate;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.util.JsonUtil;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.vehicle.AbstractMinecart;

public class CartLinkingTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation ID = RailcraftConstants.rl("cart_linking");

    public ResourceLocation m_7295_() {
        return ID;
    }

    public Instance createInstance(JsonObject json, ContextAwarePredicate contextAwarePredicate, DeserializationContext deserializationContext) {
        MinecartPredicate owned = JsonUtil.getAsJsonObject(json, "owned").map(MinecartPredicate::deserialize).orElse(MinecartPredicate.ANY);
        MinecartPredicate other = JsonUtil.getAsJsonObject(json, "other").map(MinecartPredicate::deserialize).orElse(MinecartPredicate.ANY);
        return new Instance(contextAwarePredicate, owned, other);
    }

    public void trigger(ServerPlayer playerEntity, AbstractMinecart owned, AbstractMinecart other) {
        this.m_66234_(playerEntity, criterionInstance -> criterionInstance.matches(playerEntity, owned, other));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final MinecartPredicate owned;
        private final MinecartPredicate other;

        private Instance(ContextAwarePredicate contextAwarePredicate, MinecartPredicate owned, MinecartPredicate other) {
            super(ID, contextAwarePredicate);
            this.owned = owned;
            this.other = other;
        }

        public static Instance hasLinked() {
            return new Instance(ContextAwarePredicate.f_285567_, MinecartPredicate.ANY, MinecartPredicate.ANY);
        }

        public boolean matches(ServerPlayer player, AbstractMinecart owned, AbstractMinecart other) {
            return this.owned.test(player, owned) && this.other.test(player, other);
        }

        public ResourceLocation m_7294_() {
            return ID;
        }

        public JsonObject m_7683_(SerializationContext serializer) {
            JsonObject json = new JsonObject();
            json.add("owned", this.owned.serializeToJson());
            json.add("other", this.other.serializeToJson());
            return json;
        }
    }
}

