/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.particle;

import mods.railcraft.particle.FireSparkParticleOptions;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.phys.Vec3;

public class FireSparkParticle
extends TextureSheetParticle {
    private final Vec3 destination;
    private final double maxHorizontalDist;
    private final float lavaParticleScale;

    private FireSparkParticle(ClientLevel level, double x, double y, double z, double dx, double dy, double dz, FireSparkParticleOptions options, SpriteSet sprites) {
        super(level, x, y, z, dx, dy, dz);
        this.destination = options.destination();
        this.maxHorizontalDist = this.getHorizontalDistSq(this.destination);
        this.calculateVector(this.maxHorizontalDist);
        this.m_6569_(0.5f);
        this.f_107229_ = 1.0f;
        this.f_107228_ = 1.0f;
        this.f_107227_ = 1.0f;
        this.f_107663_ *= this.f_107223_.m_188501_() * 2.0f + 0.2f;
        this.lavaParticleScale = this.f_107663_;
        this.m_107257_(2000);
        this.f_107219_ = false;
        this.m_108335_(sprites);
    }

    private double getHorizontalDistSq(Vec3 point) {
        double xDiff = this.f_107212_ - point.f_82479_;
        double zDiff = this.f_107214_ - point.f_82481_;
        return xDiff * xDiff + zDiff * zDiff;
    }

    private void calculateVector(double dist) {
        Vec3 vecParticle = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        Vec3 vel = this.destination.m_82546_(vecParticle);
        vel = vel.m_82541_();
        float velScale = 0.1f;
        this.f_107215_ = vel.f_82479_ * (double)velScale;
        this.f_107216_ = vel.f_82480_ * (double)velScale + 0.4 * (dist / this.maxHorizontalDist);
        this.f_107217_ = vel.f_82481_ * (double)velScale;
    }

    protected int m_6355_(float partialTick) {
        int brightness = super.m_6355_(partialTick);
        int j = brightness >> 16 & 0xFF;
        return 0xF0 | j << 16;
    }

    public float m_5902_(float scaleFactor) {
        float f6 = ((float)this.f_107224_ + scaleFactor) / (float)this.f_107225_;
        this.f_107663_ = this.lavaParticleScale * (1.0f - f6 * f6);
        return this.f_107663_;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            double dist;
            float f = (float)this.f_107224_ / (float)this.f_107225_;
            if (this.f_107208_.f_46441_.m_188501_() > f) {
                this.f_107208_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.f_107212_, this.f_107213_, this.f_107214_, this.f_107215_, this.f_107216_, this.f_107217_);
            }
            if ((dist = this.destination.m_82531_(this.f_107212_, this.f_107213_, this.f_107214_)) <= 0.1) {
                this.m_107274_();
            } else {
                this.calculateVector(this.getHorizontalDistSq(this.destination));
                this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            }
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public static class Provider
    implements ParticleProvider<FireSparkParticleOptions> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(FireSparkParticleOptions options, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new FireSparkParticle(level, x, y, z, dx, dy, dz, options, this.sprites);
        }
    }
}

