/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.recipes.builders;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.world.item.crafting.RailcraftRecipeSerializers;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class RollingRecipeBuilder {
    public static final int DEFAULT_PROCESSING_TIME = 100;
    private final Item result;
    private final int count;
    private final int processTime;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();

    private RollingRecipeBuilder(ItemLike result, int count, int processTime) {
        this.result = result.m_5456_();
        this.count = count;
        this.processTime = processTime;
    }

    public static RollingRecipeBuilder rolled(ItemLike result) {
        return RollingRecipeBuilder.rolled(result, 1);
    }

    public static RollingRecipeBuilder rolled(ItemLike result, int count) {
        return RollingRecipeBuilder.rolled(result, count, 100);
    }

    public static RollingRecipeBuilder rolled(ItemLike result, int count, int processTime) {
        return new RollingRecipeBuilder(result, count, processTime);
    }

    public RollingRecipeBuilder define(Character key, TagKey<Item> itemTagValue) {
        return this.define(key, Ingredient.m_204132_(itemTagValue));
    }

    public RollingRecipeBuilder define(Character key, ItemLike itemValue) {
        return this.define(key, Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemValue}));
    }

    public RollingRecipeBuilder define(Character key, Ingredient itemValue) {
        if (this.key.containsKey(key)) {
            throw new IllegalArgumentException("Symbol '" + key + "' is already defined!");
        }
        if (key.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(key, itemValue);
        return this;
    }

    public RollingRecipeBuilder pattern(String pattern) {
        if (!this.rows.isEmpty() && pattern.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(pattern);
        return this;
    }

    public void save(Consumer<FinishedRecipe> finishedRecipe) {
        this.save(finishedRecipe, ForgeRegistries.ITEMS.getKey((Object)this.result));
    }

    public void save(Consumer<FinishedRecipe> finishedRecipe, ResourceLocation resourceLocation) {
        String path = resourceLocation.m_135815_();
        ResourceLocation customResourceLocation = RailcraftConstants.rl("rolling/" + path);
        finishedRecipe.accept(new Result(customResourceLocation, this.result, this.count, this.processTime, this.rows, this.key));
    }

    private static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Item resultItem;
        private final int count;
        private final int processTime;
        private final List<String> pattern;
        private final Map<Character, Ingredient> key;

        public Result(ResourceLocation resourceLocation, Item resultItem, int resultCount, int processTime, List<String> recipePattern, Map<Character, Ingredient> ingredientMap) {
            this.id = resourceLocation;
            this.resultItem = resultItem;
            this.count = resultCount;
            this.processTime = processTime;
            this.pattern = recipePattern;
            this.key = ingredientMap;
        }

        public void m_7917_(JsonObject jsonOut) {
            JsonArray jsonarray = new JsonArray();
            for (String string : this.pattern) {
                jsonarray.add(string);
            }
            jsonOut.add("pattern", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
                jsonobject.add(String.valueOf(entry.getKey()), entry.getValue().m_43942_());
            }
            jsonOut.add("key", (JsonElement)jsonobject);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.resultItem).toString());
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            jsonOut.add("result", (JsonElement)jsonObject);
            if (this.processTime != 100) {
                jsonOut.addProperty("processTime", (Number)this.processTime);
            }
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RailcraftRecipeSerializers.ROLLING.get();
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

