/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util.container;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mods.railcraft.api.container.manipulator.ContainerManipulator;
import mods.railcraft.api.container.manipulator.ContainerSlotAccessor;
import mods.railcraft.api.container.manipulator.ModifiableSlotAccessor;
import mods.railcraft.util.Predicates;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ContainerMapper
implements Container,
ContainerManipulator<ModifiableSlotAccessor> {
    private final List<ModifiableSlotAccessor> slots;
    private final Container container;
    private boolean checkItems = true;
    private final int start;
    private final int size;
    private int maxStackSize = -1;
    private Predicate<ItemStack> filter = Predicates.alwaysTrue();

    public static ContainerMapper make(Container container) {
        return new ContainerMapper(container, 0, container.m_6643_());
    }

    public static ContainerMapper make(Container container, int start, int size) {
        return new ContainerMapper(container, start, size);
    }

    public ContainerMapper(Container container, int start, int size) {
        this.slots = ContainerSlotAccessor.createSlots(container, start, start + size).toList();
        this.container = container;
        this.start = start;
        this.size = size;
    }

    public ContainerMapper ignoreItemChecks() {
        this.checkItems = false;
        return this;
    }

    @SafeVarargs
    public final ContainerMapper addFilters(Predicate<ItemStack> ... filters) {
        this.filter = Predicates.and(this.filter, filters);
        return this;
    }

    public Predicate<ItemStack> filter() {
        return this.filter;
    }

    public ContainerMapper withStackSizeLimit(int limit) {
        this.maxStackSize = limit;
        return this;
    }

    public int m_6643_() {
        return this.size;
    }

    public ItemStack m_8020_(int slot) {
        this.validSlot(slot);
        return this.container.m_8020_(this.start + slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        this.validSlot(slot);
        return this.container.m_7407_(this.start + slot, amount);
    }

    public void m_6836_(int slot, ItemStack itemstack) {
        this.validSlot(slot);
        this.container.m_6836_(this.start + slot, itemstack);
    }

    public int m_6893_() {
        return this.maxStackSize > 0 ? this.maxStackSize : this.container.m_6893_();
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        this.validSlot(slot);
        return !this.checkItems || this.filter.test(stack) && this.container.m_7013_(this.start + slot, stack);
    }

    @Override
    public Stream<ModifiableSlotAccessor> stream() {
        return this.slots.stream();
    }

    public ItemStack m_8016_(int slot) {
        return this.container.m_8016_(slot);
    }

    public void m_6596_() {
        this.container.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return this.container.m_6542_(player);
    }

    public void m_5856_(Player player) {
        this.container.m_5856_(player);
    }

    public void m_5785_(Player player) {
        this.container.m_5785_(player);
    }

    public void m_6211_() {
        this.container.m_6211_();
    }

    public boolean checkItems() {
        return this.checkItems;
    }

    public boolean m_7983_() {
        return this.container.m_7983_();
    }

    public boolean containsSlot(int absoluteIndex) {
        return absoluteIndex >= this.start && absoluteIndex < this.start + this.size;
    }

    private void validSlot(int slot) {
        if (slot < 0 || slot >= this.size) {
            throw new IllegalArgumentException("Slot index out of bounds.");
        }
    }
}

