/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import mods.railcraft.Translations;
import mods.railcraft.advancements.RailcraftCriteriaTriggers;
import mods.railcraft.api.track.RailShapeUtil;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.api.track.TrackUtil;
import mods.railcraft.world.level.block.track.TrackBlock;
import mods.railcraft.world.level.block.track.TrackTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraftforge.registries.RegistryObject;

public class TrackKitItem
extends Item {
    private final Map<ResourceLocation, Supplier<? extends BaseRailBlock>> outfittedBlocks;
    private final boolean allowedOnSlopes;

    public TrackKitItem(Properties properties) {
        super((Item.Properties)properties);
        this.outfittedBlocks = properties.outfittedBlocks.build();
        this.allowedOnSlopes = properties.allowedOnSlopes;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        TrackType trackType;
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        InteractionHand hand = context.m_43724_();
        ItemStack itemStack = player.m_21120_(hand);
        BlockPos blockPos = context.m_8083_();
        BlockState oldState = level.m_8055_(blockPos);
        if (!BaseRailBlock.m_49416_((BlockState)oldState)) {
            return InteractionResult.PASS;
        }
        Block block = oldState.m_60734_();
        if (block instanceof TrackBlock) {
            TrackBlock trackBlock = (TrackBlock)block;
            trackType = trackBlock.getTrackType();
        } else if (oldState.m_60734_() == Blocks.f_50156_) {
            trackType = (TrackType)TrackTypes.IRON.get();
        } else {
            return InteractionResult.PASS;
        }
        RailShape shape = TrackUtil.getRailShapeRaw((BlockGetter)level, blockPos);
        if (RailShapeUtil.isTurn(shape)) {
            player.m_5661_((Component)Component.m_237115_((String)Translations.Tips.TRACK_KIT_CORNERS_UNSUPPORTED).m_130940_(ChatFormatting.RED), true);
            return InteractionResult.PASS;
        }
        if (shape.m_61745_() && !this.allowedOnSlopes) {
            player.m_5661_((Component)Component.m_237115_((String)Translations.Tips.TRACK_KIT_SLOPES_UNSUPPORTED).m_130940_(ChatFormatting.RED), true);
            return InteractionResult.PASS;
        }
        BaseRailBlock outfittedBlock = this.outfittedBlocks.getOrDefault(TrackTypes.REGISTRY.get().getKey((Object)trackType), () -> null).get();
        if (outfittedBlock == null) {
            player.m_5661_((Component)Component.m_237115_((String)Translations.Tips.TRACK_KIT_INVALID_TRACK_TYPE).m_130940_(ChatFormatting.RED), true);
            return InteractionResult.PASS;
        }
        BlockState outfittedBlockState = outfittedBlock.m_5573_(new BlockPlaceContext(context));
        if (level.m_46597_(blockPos, outfittedBlockState)) {
            SoundType soundType = outfittedBlock.getSoundType(outfittedBlockState, (LevelReader)level, blockPos, (Entity)player);
            level.m_5594_(player, blockPos, soundType.m_56777_(), SoundSource.BLOCKS, soundType.m_56773_(), soundType.m_56774_());
            if (!level.m_5776_()) {
                RailcraftCriteriaTriggers.TRACK_KIT_USE.trigger((ServerPlayer)player, (ServerLevel)level, blockPos, itemStack);
            }
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static class Properties
    extends Item.Properties {
        private final ImmutableMap.Builder<ResourceLocation, Supplier<? extends BaseRailBlock>> outfittedBlocks = ImmutableMap.builder();
        private boolean allowedOnSlopes;

        public Properties addOutfittedBlock(RegistryObject<? extends TrackType> trackType, Supplier<? extends BaseRailBlock> block) {
            return this.addOutfittedBlock(trackType.getId(), block);
        }

        public Properties addOutfittedBlock(ResourceLocation trackTypeId, Supplier<? extends BaseRailBlock> block) {
            this.outfittedBlocks.put((Object)trackTypeId, block);
            return this;
        }

        public Properties setAllowedOnSlopes(boolean allowedOnSlopes) {
            this.allowedOnSlopes = allowedOnSlopes;
            return this;
        }
    }
}

