/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.detector;

import java.util.List;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.world.level.block.detector.DetectorBlock;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class DetectorBlockEntity
extends RailcraftBlockEntity {
    private static final float SENSITIVITY = 0.2f;
    private int powerState;
    private int powerDelay;
    private int tick;

    protected DetectorBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
    }

    protected int updateInterval() {
        return 0;
    }

    protected boolean shouldTest() {
        return true;
    }

    protected int testCarts(List<AbstractMinecart> minecarts) {
        return minecarts.isEmpty() ? 0 : 15;
    }

    private static List<AbstractMinecart> getCarts(Level level, BlockPos blockPos) {
        return EntitySearcher.findMinecarts().at(blockPos).upTo(0.2f).list(level);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, DetectorBlockEntity blockEntity) {
        ++blockEntity.tick;
        if (blockEntity.powerDelay > 0) {
            --blockEntity.powerDelay;
            return;
        }
        if (blockEntity.updateInterval() == 0 || blockEntity.tick % blockEntity.updateInterval() == 0) {
            int newPowerState;
            int n = newPowerState = blockEntity.shouldTest() ? blockEntity.testCarts(DetectorBlockEntity.getCarts(level, blockPos)) : 0;
            if (newPowerState != blockEntity.powerState) {
                boolean powered;
                blockEntity.powerState = newPowerState;
                boolean bl = powered = blockEntity.powerState > 0;
                if (powered) {
                    blockEntity.powerDelay = 10;
                }
                level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)DetectorBlock.POWERED, (Comparable)Boolean.valueOf(powered)));
                BlockPos offsetPos = blockPos.m_121955_(((Direction)blockState.m_61143_((Property)DetectorBlock.FACING)).m_122436_());
                level.m_46672_(offsetPos, blockState.m_60734_());
            }
            blockEntity.tick = 0;
        }
    }

    public int getPowerState() {
        return this.powerState;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.powerState = tag.m_128451_("powerState");
        this.powerDelay = tag.m_128451_("powerDelay");
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("powerState", this.powerState);
        tag.m_128405_("powerDelay", this.powerDelay);
    }

    @Override
    public void writeToBuf(FriendlyByteBuf out) {
        super.writeToBuf(out);
        out.m_130130_(this.powerState);
        out.m_130130_(this.powerDelay);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf in) {
        super.readFromBuf(in);
        this.powerState = in.m_130242_();
        this.powerDelay = in.m_130242_();
    }
}

