/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.detector;

import java.util.List;
import java.util.function.Predicate;
import mods.railcraft.Translations;
import mods.railcraft.api.container.manipulator.ContainerManipulator;
import mods.railcraft.api.container.manipulator.SlotAccessor;
import mods.railcraft.api.util.EnumUtil;
import mods.railcraft.util.container.StackFilter;
import mods.railcraft.world.inventory.detector.ItemDetectorMenu;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.detector.FilterDetectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class ItemDetectorBlockEntity
extends FilterDetectorBlockEntity {
    private PrimaryMode primaryMode = PrimaryMode.ANYTHING;
    private FilterMode filterMode = FilterMode.AT_LEAST;

    public ItemDetectorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.ITEM_DETECTOR.get(), blockPos, blockState, 9);
    }

    @Override
    protected int testCarts(List<AbstractMinecart> minecarts) {
        block8: for (AbstractMinecart cart : minecarts) {
            LazyOptional cap = cart.getCapability(ForgeCapabilities.ITEM_HANDLER);
            if (!cap.resolve().isPresent()) continue;
            IItemHandler itemHandler = (IItemHandler)cap.resolve().get();
            ContainerManipulator<SlotAccessor> containerManipulator = ContainerManipulator.of(itemHandler);
            if (itemHandler.getSlots() <= 0) continue;
            switch (this.primaryMode) {
                case ANYTHING: {
                    return 15;
                }
                case EMPTY: {
                    if (!containerManipulator.hasNoItems()) continue block8;
                    return 15;
                }
                case FULL: {
                    if (!containerManipulator.isFull()) continue block8;
                    return 15;
                }
                case FILTERED: {
                    if (!this.matchesFilter(containerManipulator)) continue block8;
                    return 15;
                }
                case NOT_EMPTY: {
                    if (!containerManipulator.hasItems()) continue block8;
                    return 15;
                }
                case ANALOG: {
                    return containerManipulator.calcRedstone();
                }
            }
        }
        return 0;
    }

    private boolean matchesFilter(ContainerManipulator<SlotAccessor> containerManipulator) {
        block7: for (int i = 0; i < this.invFilters.m_6643_(); ++i) {
            ItemStack filter = this.invFilters.m_8020_(i);
            if (filter.m_41619_()) continue;
            Predicate<ItemStack> stackFilter = StackFilter.anyMatch(filter);
            int amountFilter = this.stream().filter(x -> x.matches(stackFilter)).map(x -> x.item().m_41613_()).reduce(Integer::sum).orElse(0);
            int amountCart = containerManipulator.countItems(stackFilter);
            switch (this.filterMode) {
                case EXACTLY: {
                    if (amountCart == amountFilter) continue block7;
                    return false;
                }
                case AT_LEAST: {
                    if (amountCart >= amountFilter) continue block7;
                    return false;
                }
                case AT_MOST: {
                    if (amountCart <= amountFilter) continue block7;
                    return false;
                }
                case GREATER_THAN: {
                    if (amountCart > amountFilter) continue block7;
                    return false;
                }
                case LESS_THAN: {
                    if (amountCart < amountFilter) continue block7;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.primaryMode = PrimaryMode.fromName(tag.m_128461_("primaryMode"));
        this.filterMode = FilterMode.fromName(tag.m_128461_("filterMode"));
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("primaryMode", this.primaryMode.m_7912_());
        tag.m_128359_("filterMode", this.filterMode.m_7912_());
    }

    @Override
    public void writeToBuf(FriendlyByteBuf out) {
        super.writeToBuf(out);
        out.m_130068_((Enum)this.primaryMode);
        out.m_130068_((Enum)this.filterMode);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf in) {
        super.readFromBuf(in);
        this.primaryMode = (PrimaryMode)in.m_130066_(PrimaryMode.class);
        this.filterMode = (FilterMode)in.m_130066_(FilterMode.class);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new ItemDetectorMenu(id, inventory, this);
    }

    public PrimaryMode getPrimaryMode() {
        return this.primaryMode;
    }

    public FilterMode getFilterMode() {
        return this.filterMode;
    }

    public void setPrimaryMode(PrimaryMode value) {
        this.primaryMode = value;
    }

    public void setFilterMode(FilterMode value) {
        this.filterMode = value;
    }

    public static enum PrimaryMode implements StringRepresentable
    {
        EMPTY("empty"),
        FULL("full"),
        ANYTHING("anything"),
        FILTERED("filtered"),
        NOT_EMPTY("not_empty"),
        ANALOG("analog");

        private static final StringRepresentable.EnumCodec<PrimaryMode> CODEC;
        private final String name;

        private PrimaryMode(String name) {
            this.name = name;
        }

        public PrimaryMode next() {
            return (PrimaryMode)EnumUtil.next((Enum)this, (Enum[])PrimaryMode.values());
        }

        public PrimaryMode previous() {
            return (PrimaryMode)EnumUtil.previous((Enum)this, (Enum[])PrimaryMode.values());
        }

        public Component getName() {
            return Component.m_237115_((String)Translations.makeKey("screen", "item_detector.primary_mode." + this.name));
        }

        public String m_7912_() {
            return this.name;
        }

        public static PrimaryMode fromName(String name) {
            return (PrimaryMode)CODEC.m_262792_(name, (Enum)ANYTHING);
        }

        static {
            CODEC = StringRepresentable.m_216439_(PrimaryMode::values);
        }
    }

    public static enum FilterMode implements StringRepresentable
    {
        AT_LEAST("at_least"),
        AT_MOST("at_most"),
        EXACTLY("exactly"),
        LESS_THAN("less_than"),
        GREATER_THAN("greater_than");

        private static final StringRepresentable.EnumCodec<FilterMode> CODEC;
        private final String name;

        private FilterMode(String name) {
            this.name = name;
        }

        public FilterMode next() {
            return (FilterMode)EnumUtil.next((Enum)this, (Enum[])FilterMode.values());
        }

        public FilterMode previous() {
            return (FilterMode)EnumUtil.previous((Enum)this, (Enum[])FilterMode.values());
        }

        public Component getName() {
            return Component.m_237115_((String)Translations.makeKey("screen", "item_detector.filter_mode." + this.name));
        }

        public String m_7912_() {
            return this.name;
        }

        public static FilterMode fromName(String name) {
            return (FilterMode)CODEC.m_262792_(name, (Enum)AT_LEAST);
        }

        static {
            CODEC = StringRepresentable.m_216439_(FilterMode::values);
        }
    }
}

