/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.signal;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.api.signal.SignalReceiver;
import mods.railcraft.api.signal.SimpleSignalController;
import mods.railcraft.api.signal.SingleSignalReceiver;
import mods.railcraft.api.signal.entity.SignalControllerEntity;
import mods.railcraft.api.signal.entity.SignalReceiverEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.signal.AbstractSignalBoxBlockEntity;
import mods.railcraft.world.level.block.signal.SignalBoxBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SignalInterlockBoxBlockEntity
extends AbstractSignalBoxBlockEntity
implements SignalControllerEntity,
SignalReceiverEntity {
    private final SimpleSignalController signalController = new SimpleSignalController(1, this::syncToClient, this, true);
    private final SingleSignalReceiver signalReceiver = new SingleSignalReceiver(this, this::syncToClient, this::signalAspectChanged);
    private InterlockController interlockController;
    private SignalAspect neighborSignalAspect;

    public SignalInterlockBoxBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.SIGNAL_INTERLOCK_BOX.get(), blockPos, blockState);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.f_58857_.m_5776_()) {
            this.findOrCreateInterlockController();
            this.signalReceiver.refresh();
            this.signalController.refresh();
        }
    }

    @Override
    public void blockRemoved() {
        super.blockRemoved();
        this.signalController.destroy();
        this.signalReceiver.destroy();
        if (this.interlockController != null) {
            this.interlockController.remove(this);
        }
    }

    @Override
    public void neighborSignalBoxChanged(AbstractSignalBoxBlockEntity neighborSignalBox, Direction neighborDirection, boolean removed) {
        this.findOrCreateInterlockController();
        this.neighborSignalAspect = SignalAspect.GREEN;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            AbstractSignalBoxBlockEntity signalBox;
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction));
            if (!(blockEntity instanceof AbstractSignalBoxBlockEntity) || !SignalBoxBlock.isAspectEmitter((signalBox = (AbstractSignalBoxBlockEntity)blockEntity).m_58900_())) continue;
            this.neighborSignalAspect = SignalAspect.mostRestrictive(this.neighborSignalAspect, signalBox.getSignalAspect(direction.m_122424_()));
        }
        if (!this.f_58857_.m_5776_()) {
            this.interlockController.peersUpdateSignalAspect();
        }
    }

    private void findOrCreateInterlockController() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        InterlockController lastInterlockController = this.interlockController;
        this.interlockController = null;
        for (Direction direction : Direction.values()) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(direction));
            if (!(blockEntity instanceof SignalInterlockBoxBlockEntity)) continue;
            SignalInterlockBoxBlockEntity signalBox = (SignalInterlockBoxBlockEntity)blockEntity;
            if (signalBox.interlockController == null) continue;
            this.interlockController = signalBox.interlockController;
            break;
        }
        if (this.interlockController == null) {
            this.interlockController = new InterlockController();
        }
        if (this.interlockController != lastInterlockController) {
            this.interlockController.add(this);
            this.refreshSignalAspect();
        }
    }

    private void refreshSignalAspect() {
        this.signalAspectChanged(this.getRequestedSignalAspect());
    }

    private void signalAspectChanged(SignalAspect signalAspect) {
        if (this.interlockController != null) {
            if (SignalInterlockBoxBlockEntity.isLockableSignalAspect(signalAspect)) {
                this.interlockController.requestLock(this);
            } else {
                this.interlockController.discardLock(this);
            }
        }
    }

    private SignalAspect getRequestedSignalAspect() {
        return this.signalReceiver.getPrimarySignalAspect();
    }

    @Override
    public SignalAspect getSignalAspect(Direction direction) {
        return this.signalController.aspect();
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("signalController", (Tag)this.signalController.serializeNBT());
        tag.m_128365_("signalReceiver", (Tag)this.signalReceiver.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.signalController.deserializeNBT(tag.m_128469_("signalController"));
        this.signalReceiver.deserializeNBT(tag.m_128469_("signalReceiver"));
    }

    @Override
    public void writeToBuf(FriendlyByteBuf data) {
        super.writeToBuf(data);
        this.signalController.writeToBuf(data);
        this.signalReceiver.writeToBuf(data);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf data) {
        super.readFromBuf(data);
        this.signalController.readFromBuf(data);
        this.signalReceiver.readFromBuf(data);
    }

    @Override
    public SimpleSignalController getSignalController() {
        return this.signalController;
    }

    @Override
    public SignalReceiver getSignalReceiver() {
        return this.signalReceiver;
    }

    private static boolean isLockableSignalAspect(SignalAspect signalAspect) {
        return signalAspect.ordinal() <= SignalAspect.YELLOW.ordinal();
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, SignalInterlockBoxBlockEntity blockEntity) {
        blockEntity.signalController.spawnTuningAuraParticles();
    }

    private static class InterlockController {
        private final Set<SignalInterlockBoxBlockEntity> peers = new HashSet<SignalInterlockBoxBlockEntity>();
        private final Queue<SignalInterlockBoxBlockEntity> lockRequests = new ArrayDeque<SignalInterlockBoxBlockEntity>();
        @Nullable
        private SignalInterlockBoxBlockEntity activeSignalBox;

        private InterlockController() {
        }

        private void add(SignalInterlockBoxBlockEntity signalBox) {
            this.peers.add(signalBox);
            this.updateSignalAspect(signalBox);
        }

        private void remove(SignalInterlockBoxBlockEntity signalBox) {
            this.peers.remove(signalBox);
            this.discardLock(signalBox);
        }

        private void discardLock(SignalInterlockBoxBlockEntity signalBox) {
            if (this.isActive(signalBox)) {
                this.next();
            } else {
                this.updateSignalAspect(signalBox);
                this.lockRequests.remove(signalBox);
            }
        }

        private void requestLock(SignalInterlockBoxBlockEntity signalBox) {
            if (this.activeSignalBox != signalBox) {
                this.lockRequests.add(signalBox);
                if (this.activeSignalBox == null) {
                    this.next();
                } else {
                    this.updateSignalAspect(signalBox);
                }
            }
        }

        private void next() {
            do {
                this.activeSignalBox = this.lockRequests.poll();
            } while (this.activeSignalBox != null && !SignalInterlockBoxBlockEntity.isLockableSignalAspect(this.activeSignalBox.getRequestedSignalAspect()));
            this.peersUpdateSignalAspect();
        }

        private void peersUpdateSignalAspect() {
            this.peers.forEach(this::updateSignalAspect);
        }

        private void updateSignalAspect(SignalInterlockBoxBlockEntity signalBox) {
            if (this.isActive(signalBox)) {
                SignalAspect signalAspect = signalBox.signalReceiver.getPrimarySignalAspect();
                for (SignalInterlockBoxBlockEntity box : this.peers) {
                    signalAspect = SignalAspect.mostRestrictive(signalAspect, box.neighborSignalAspect);
                }
                signalBox.signalController.setSignalAspect(signalAspect);
            } else {
                signalBox.signalController.setSignalAspect(SignalAspect.RED);
            }
        }

        private boolean isActive(SignalInterlockBoxBlockEntity signalBox) {
            return signalBox == this.activeSignalBox;
        }
    }
}

